/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.rawdata;

import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.rawdata.RawData;
import com.softaspects.framework.galileo.support.components.rawdata.RawDataModel;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;

public class RawDataRenderer
extends ContextRendererImpl {
    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        RawData rawData = (RawData)this.getComponent();
        RawDataModel rawDataModel = rawData.getDataModel();
        String dataType = rawDataModel.getDataType();
        if (dataType == null) {
            throw new IllegalStateException("RawData: type of data must be set.");
        }
        byte[] data = rawDataModel.getData();
        StringBuffer sBuffer = new StringBuffer();
        try {
            if (dataType.equalsIgnoreCase("text/html")) {
                if (rawData.isEnvelope()) {
                    sBuffer.append("<DIV");
                    Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(rawData);
                    while (htmlProperties.hasNext()) {
                        sBuffer.append(' ');
                        HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                        sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
                    }
                    Iterator presentationEvents = rawData.getPresentationEvents();
                    while (presentationEvents.hasNext()) {
                        sBuffer.append(' ');
                        PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
                        String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
                        String value = presentationEvent.getValue();
                        sBuffer.append(RendererFactory.createHtmlStylePropertyString(type, value));
                    }
                    sBuffer.append('>');
                }
                if (data != null) {
                    sBuffer.append(new String(data));
                }
                if (rawData.isEnvelope()) {
                    sBuffer.append("</DIV>");
                }
            } else if (data != null) {
                ServletResponse servletResponse = this.fPageContext.getResponse();
                servletResponse.setContentType(dataType);
                servletResponse.getOutputStream().write(data);
                servletResponse.getOutputStream().close();
            }
            String result = sBuffer.toString();
            if (rawData.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }
}

