/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.frame;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.frame.FrameComponent;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;

public class FrameComponentRenderer
extends ContextRendererImpl {
    private static final String FRAME_MODEL_SCRIPT_WAS_LOADED = "FRAME_MODEL_SCRIPT_WAS_LOADED";
    private static final String FRAME_SCRIPT_FUNCTION = "FrameComponent";
    private static final String FRAME_MODEL_SCRIPT = "framecomponent.js";

    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        FrameComponent frame = (FrameComponent)this.getComponent();
        try {
            StringBuffer sBuffer = new StringBuffer("<FRAME");
            Iterator htmlProperties = RendererFactory.componentBaseHtmlPropertiesIterator(frame);
            while (htmlProperties.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            ArrayList<HtmlProperty> aList = new ArrayList<HtmlProperty>();
            if (frame.getSrc() != null) {
                aList.add(new HtmlProperty("SRC", frame.getSrc()));
            }
            if (frame.getHintText() != null) {
                aList.add(new HtmlProperty("TITLE", frame.getHintText()));
            }
            if (frame.getFrameBorder() != null) {
                aList.add(new HtmlProperty("FRAMEBORDER", frame.getFrameBorder()));
            }
            if (frame.getBorderColor() != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(frame.getBorderColor());
                aList.add(new HtmlProperty("BORDERCOLOR", color));
            }
            if (frame.getBorder() != 0) {
                aList.add(new HtmlProperty("BORDER", frame.getBorder()));
            }
            if (frame.getScrolling() != -1) {
                String scrolling = TagFactory.getScrollingValue(frame.getScrolling());
                aList.add(new HtmlProperty("SCROLLING", scrolling));
            }
            if (!frame.isResizable()) {
                aList.add(new HtmlProperty("NORESIZE", null));
            }
            if (frame.getMarginHeight() != -1) {
                aList.add(new HtmlProperty("MARGINHEIGH", frame.getMarginHeight()));
            }
            if (frame.getMarginWidth() != -1) {
                aList.add(new HtmlProperty("MARGINWIDTH", frame.getMarginWidth()));
            }
            Iterator uniqHtmlProperty = ((AbstractList)aList).iterator();
            while (uniqHtmlProperty.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)uniqHtmlProperty.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            sBuffer.append(">");
            String result = sBuffer.toString();
            if (frame.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }
}

