/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.container.layout;

import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.Inset;
import com.softaspects.framework.galileo.support.components.container.decorator.Decorator;
import com.softaspects.framework.galileo.support.components.container.layout.AbsoluteLayoutManager;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManager;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public abstract class LayoutRenderer
extends ContextRendererImpl {
    private static final String CONTAINER_SCRIPT_WAS_LOADED = "CONTAINER_SCRIPT_WAS_LOADED";
    private static final String CONTAINER_SCRIPT_FUNCTION = "Container";

    public abstract String componentsRender(Container var1) throws RendererException;

    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        Container container = (Container)this.getComponent();
        LayoutManager layoutManager = container.getLayoutManager();
        layoutManager.doLayout(container);
        StringBuffer sBuffer = new StringBuffer();
        String containerStyle = container.getStyle();
        try {
            try {
                Object flag = this.fPageContext.getAttribute(CONTAINER_SCRIPT_WAS_LOADED, 2);
                if (flag == null) {
                    JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                    sBuffer.append(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource("CONTAINER"), null));
                    sBuffer.append(RendererFactory.createJScriptEndTag());
                    sBuffer.append("\n");
                    this.fPageContext.setAttribute(CONTAINER_SCRIPT_WAS_LOADED, (Object)CONTAINER_SCRIPT_WAS_LOADED, 2);
                }
                sBuffer.append("<DIV");
                Inset inset = container.getInset();
                if (inset != null && (inset.getPaddingLeft() != null || inset.getPaddingRight() != null || inset.getPaddingTop() != null || inset.getPaddingBottom() != null)) {
                    StringBuffer padding = new StringBuffer();
                    padding.append(inset.getPaddingTop() != null ? inset.getPaddingTop() : "0px");
                    padding.append(' ');
                    padding.append(inset.getPaddingRight() != null ? inset.getPaddingRight() : "0px");
                    padding.append(' ');
                    padding.append(inset.getPaddingBottom() != null ? inset.getPaddingBottom() : "0px");
                    padding.append(' ');
                    padding.append(inset.getPaddingLeft() != null ? inset.getPaddingLeft() : "0px");
                    padding.append(';');
                    container.addStyleProperty("PADDING", padding.toString());
                }
                int overflow = container.getLayoutManager().getOverflow();
                container.addStyleProperty("OVERFLOW", TagFactory.getOverflowValue(overflow));
                if (layoutManager instanceof AbsoluteLayoutManager) {
                    AbsoluteLayoutManager absoluteLayoutManager = (AbsoluteLayoutManager)layoutManager;
                    ComponentBase parent = container.getParentComponent();
                    if (parent == null || parent instanceof AbsoluteLayoutManager) {
                        container.addStyleProperty("POSITION", "absolute");
                    }
                    if (absoluteLayoutManager.getLeft() != null) {
                        container.addStyleProperty("LEFT", absoluteLayoutManager.getLeft());
                    }
                    if (absoluteLayoutManager.getTop() != null) {
                        container.addStyleProperty("TOP", absoluteLayoutManager.getTop());
                    }
                    if (absoluteLayoutManager.getWidth() != null) {
                        container.addStyleProperty("WIDTH", absoluteLayoutManager.getWidth());
                    }
                    if (absoluteLayoutManager.getHeight() != null) {
                        container.addStyleProperty("HEIGHT", absoluteLayoutManager.getHeight());
                    }
                }
                Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(container);
                while (htmlProperties.hasNext()) {
                    sBuffer.append(' ');
                    HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
                }
                Iterator presentationEvents = container.getPresentationEvents();
                while (presentationEvents.hasNext()) {
                    sBuffer.append(' ');
                    PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
                    String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
                    String value = presentationEvent.getValue();
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString(type, value));
                }
                sBuffer.append('>');
                StringBuffer params = new StringBuffer();
                Iterator headers = container.getHeaderDecorators();
                while (headers.hasNext()) {
                    Decorator header = (Decorator)headers.next();
                    sBuffer.append(RendererFactory.componentRender(header, this.fPageContext));
                    params.append(RendererFactory.createJScriptVariableName(header));
                    params.append(',');
                }
                sBuffer.append(this.componentsRender(container));
                Iterator footers = container.getFooterDecorators();
                while (footers.hasNext()) {
                    sBuffer.append(RendererFactory.componentRender((Decorator)footers.next(), this.fPageContext));
                }
                sBuffer.append("</DIV>");
                sBuffer.append(RendererFactory.createHtmlJScriptVariable((ComponentBase)container, CONTAINER_SCRIPT_FUNCTION, params.toString()));
                String result = sBuffer.toString();
                if (container.isPageContextRendering()) {
                    out.println(result);
                }
                String string = result;
                Object var15_18 = null;
                container.setStyle(containerStyle);
                return string;
            }
            catch (IOException e) {
                throw new RendererException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            container.setStyle(containerStyle);
            throw throwable;
        }
    }
}

