/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.base;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.components.base.Renderer;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRenderer;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfo;
import com.softaspects.framework.galileo.support.components.container.constraint.LayoutConstraint;
import com.softaspects.framework.galileo.support.util.ReverseHashMap;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public class RendererFactory {
    private static final int INDENT_STEP = 2;
    public static final short BROWSER_TYPE_UNKNOWN = 0;
    public static final short BROWSER_TYPE_EXPLORER = 1;
    public static final short BROWSER_TYPE_NETSCAPE = 2;
    public static final short BROWSER_TYPE_MOZILLA = 3;
    public static final short BROWSER_TYPE_OPERA = 4;
    public static final short BROWSER_TYPE_ICE = 5;
    public static final short BROWSER_TYPE_LAST = 5;
    private static HashMap fPresentationEventsMap = new HashMap();
    private static ReverseHashMap fBrowserTypeToBrowserNameMap = new ReverseHashMap();
    public static final String EVENT_ONCLICK_NAME = "onClick";
    public static final String EVENT_ONDBLCLICK_NAME = "onDblClick";
    public static final String EVENT_ONMOUSEDOWN_NAME = "onMouseDown";
    public static final String EVENT_ONMOUSEOUT_NAME = "onMouseOut";
    public static final String EVENT_ONMOUSEUP_NAME = "onMouseUp";
    public static final String EVENT_ONMOUSEOVER_NAME = "onMouseOver";
    public static final String EVENT_ONRESET_NAME = "onReset";
    public static final String EVENT_ONSUBMIT_NAME = "onSubmit";
    public static final String EVENT_ONBLUR_NAME = "onBlur";
    public static final String EVENT_ONSELECT_NAME = "onSelect";
    public static final String EVENT_ONSCROLL_NAME = "onScroll";
    public static final String EVENT_ONLOAD_NAME = "onLoad";
    public static final String EVENT_ONUNLOAD_NAME = "onUnload";
    public static final String EVENT_ONRESIZE_NAME = "onResize";
    public static final String EVENT_ONFOCUS_NAME = "onFocus";
    public static final String EVENT_ONHELP_NAME = "onHelp";
    public static final String EVENT_ONKEYDOWN_NAME = "onKeyDown";
    public static final String EVENT_ONKEYPRESS_NAME = "onKeyPress";
    public static final String EVENT_ONKEYUP_NAME = "onKeyUp";
    public static final String EVENT_ONCHANGE_NAME = "onChange";
    public static final String EVENT_ONAFTERUPDATE_NAME = "onAfterUpdate";
    public static final String EVENT_ONBEFOREUPDATE_NAME = "onBeforeUpdate";
    public static final String EVENT_ONBEFOREUNLOAD_NAME = "onBeforeUnload";
    public static final String EVENT_ONROWEXIT_NAME = "onRowExit";
    public static final String EVENT_ONROWENTER_NAME = "OnRowEnter";
    public static final String EVENT_ONDRAGSTART_NAME = "OnDragStart";
    public static final String EVENT_ONFILTERCHANGE_NAME = "OnFilterChange";
    public static final String EVENT_ONERRORUPDATE_NAME = "OnErrorUpdate";
    public static final String EVENT_ONSELECTSTART_NAME = "OnSelectStart";
    private static String fPathToImages;
    private static String fPathToRenderers;
    private static String fPathToJavaScriptsExplorer;
    private static String fPathToJavaScriptsNetscape;
    private static String fPathToJavaScriptsIce;
    private static String fPathToJavaScriptsOpera;
    private static String suffixPathToJavaScriptsExplorer;
    private static String suffixPathToJavaScriptsNetscape;
    private static String suffixPathToJavaScriptsOpera;
    private static String suffixPathToJavaScriptsIce;
    private static String variableListing;
    private static ServletContext servletContext;
    private static String treeDynamicDataModelProviderServletUrl;
    private static final String TRANSPARENT_IMAGE_SRC = "transparent.gif";

    static {
        RendererFactory.initPresentationEventsMap();
        RendererFactory.initBrowserTypeMap();
        fPathToImages = "";
        fPathToRenderers = "";
        fPathToJavaScriptsExplorer = "";
        fPathToJavaScriptsNetscape = "";
        fPathToJavaScriptsIce = "";
        fPathToJavaScriptsOpera = "";
        suffixPathToJavaScriptsExplorer = "";
        suffixPathToJavaScriptsNetscape = "";
        suffixPathToJavaScriptsOpera = "";
        suffixPathToJavaScriptsIce = "";
        variableListing = "";
        servletContext = null;
        treeDynamicDataModelProviderServletUrl = "";
    }

    private static void initPresentationEventsMap() {
        fPresentationEventsMap.put(new Integer(1), EVENT_ONDBLCLICK_NAME);
        fPresentationEventsMap.put(new Integer(2), EVENT_ONMOUSEDOWN_NAME);
        fPresentationEventsMap.put(new Integer(3), EVENT_ONMOUSEOUT_NAME);
        fPresentationEventsMap.put(new Integer(4), EVENT_ONMOUSEUP_NAME);
        fPresentationEventsMap.put(new Integer(5), EVENT_ONMOUSEOVER_NAME);
        fPresentationEventsMap.put(new Integer(6), EVENT_ONRESET_NAME);
        fPresentationEventsMap.put(new Integer(7), EVENT_ONSUBMIT_NAME);
        fPresentationEventsMap.put(new Integer(8), EVENT_ONBLUR_NAME);
        fPresentationEventsMap.put(new Integer(9), EVENT_ONSELECT_NAME);
        fPresentationEventsMap.put(new Integer(10), EVENT_ONSCROLL_NAME);
        fPresentationEventsMap.put(new Integer(31), EVENT_ONLOAD_NAME);
        fPresentationEventsMap.put(new Integer(11), EVENT_ONUNLOAD_NAME);
        fPresentationEventsMap.put(new Integer(12), EVENT_ONRESIZE_NAME);
        fPresentationEventsMap.put(new Integer(13), EVENT_ONFOCUS_NAME);
        fPresentationEventsMap.put(new Integer(14), EVENT_ONHELP_NAME);
        fPresentationEventsMap.put(new Integer(15), EVENT_ONKEYDOWN_NAME);
        fPresentationEventsMap.put(new Integer(16), EVENT_ONKEYPRESS_NAME);
        fPresentationEventsMap.put(new Integer(17), EVENT_ONKEYUP_NAME);
        fPresentationEventsMap.put(new Integer(18), EVENT_ONCHANGE_NAME);
        fPresentationEventsMap.put(new Integer(19), EVENT_ONAFTERUPDATE_NAME);
        fPresentationEventsMap.put(new Integer(20), EVENT_ONBEFOREUPDATE_NAME);
        fPresentationEventsMap.put(new Integer(21), EVENT_ONBEFOREUNLOAD_NAME);
        fPresentationEventsMap.put(new Integer(22), EVENT_ONCLICK_NAME);
        fPresentationEventsMap.put(new Integer(23), EVENT_ONROWEXIT_NAME);
        fPresentationEventsMap.put(new Integer(24), EVENT_ONROWENTER_NAME);
        fPresentationEventsMap.put(new Integer(25), EVENT_ONDRAGSTART_NAME);
        fPresentationEventsMap.put(new Integer(26), EVENT_ONFILTERCHANGE_NAME);
        fPresentationEventsMap.put(new Integer(27), EVENT_ONERRORUPDATE_NAME);
        fPresentationEventsMap.put(new Integer(25), EVENT_ONDRAGSTART_NAME);
        fPresentationEventsMap.put(new Integer(28), EVENT_ONSELECTSTART_NAME);
    }

    private static void initBrowserTypeMap() {
        fBrowserTypeToBrowserNameMap.put(new Short(1), "MSIE".toUpperCase());
        fBrowserTypeToBrowserNameMap.put(new Short(2), "Netscape6".toUpperCase());
        fBrowserTypeToBrowserNameMap.put(new Short(3), "Mozilla".toUpperCase());
        fBrowserTypeToBrowserNameMap.put(new Short(5), "ICE Browser".toUpperCase());
        fBrowserTypeToBrowserNameMap.put(new Short(4), "Opera".toUpperCase());
    }

    public static String getPresentationEventName(int aType) {
        return (String)fPresentationEventsMap.get(new Integer(aType));
    }

    public static String indentString(int aIndent) {
        char[] clob = new char[aIndent * 2];
        Arrays.fill(clob, ' ');
        return new String(clob);
    }

    public static String indentString(int aIndent, String aString) {
        return String.valueOf(RendererFactory.indentString(aIndent)) + aString;
    }

    public static String getStyleParameterValue(String aStyleString, String aStyleParameterName) {
        String styleParameter = RendererFactory.getStyleParameter(aStyleString, aStyleParameterName);
        if (styleParameter == null) {
            return null;
        }
        return styleParameter.substring(styleParameter.indexOf(58) + 1, styleParameter.indexOf(59)).trim();
    }

    public static void setPathToImages(String aPathToImages) {
        fPathToImages = RendererFactory.normalizePath(aPathToImages, false);
    }

    public static String getPathToImages() {
        if ("".equals(fPathToImages)) {
            throw new IllegalStateException("pathToImages init param must be set in ComponentInitializer Servlet section of web.xml descriptor");
        }
        return fPathToImages;
    }

    public static String getPathToImage(String aImage) {
        if (aImage != null) {
            StringBuffer sBuffer = new StringBuffer(RendererFactory.getPathToImages()).append(aImage);
            return sBuffer.toString();
        }
        return null;
    }

    public static void setPathToRenderers(String aPathToRenderers) {
        fPathToRenderers = RendererFactory.normalizePath(aPathToRenderers, false);
    }

    public static String getPathToRenderers() {
        if ("".equals(fPathToRenderers)) {
            throw new IllegalStateException("pathToRenderers init param must be set in ComponentInitializer Servlet section of web.xml descriptor");
        }
        return fPathToRenderers;
    }

    public static String getPathToJavaScripts() {
        return RendererFactory.getPathToJavaScriptsExplorer();
    }

    public static void setPathToJavaScriptsExplorer(String aPathToJavaScriptsExplorer) {
        fPathToJavaScriptsExplorer = RendererFactory.normalizePath(aPathToJavaScriptsExplorer, true);
    }

    public static String getPathToJavaScriptsExplorer() {
        if ("".equals(fPathToJavaScriptsExplorer)) {
            throw new IllegalStateException("pathToJavaScriptsExplorer init param must be set in ComponentInitializer Servlet section of web.xml descriptor");
        }
        return fPathToJavaScriptsExplorer;
    }

    public static void setPathToJavaScriptsNetscape(String aPathToJavaScriptsNetscape) {
        fPathToJavaScriptsNetscape = RendererFactory.normalizePath(aPathToJavaScriptsNetscape, true);
    }

    public static String getPathToJavaScriptsNetscape() {
        return fPathToJavaScriptsNetscape;
    }

    public static void setPathToJavaScriptsOpera(String aPathToJavaScriptsOpera) {
        fPathToJavaScriptsOpera = RendererFactory.normalizePath(aPathToJavaScriptsOpera, true);
    }

    public static String getPathToJavaScriptsOpera() {
        if ("".equals(fPathToJavaScriptsOpera)) {
            throw new IllegalStateException("pathToJavaScriptsOpera init param must be set in ComponentInitializer Servlet section of web.xml descriptor");
        }
        return fPathToJavaScriptsOpera;
    }

    public static void setPathToJavaScriptsIce(String aPathToJavaScriptsIce) {
        fPathToJavaScriptsIce = RendererFactory.normalizePath(aPathToJavaScriptsIce, true);
    }

    public static String getPathToJavaScriptsIce() {
        if ("".equals(fPathToJavaScriptsIce)) {
            throw new IllegalStateException("pathToJavaScriptsIce init param must be set in ComponentInitializer Servlet section of web.xml descriptor");
        }
        return fPathToJavaScriptsIce;
    }

    public static String getStyleParameter(String aStyleString, String aStyleParameterName) {
        if (aStyleString == null || aStyleString.length() == 0 || aStyleParameterName == null || aStyleParameterName.length() == 0) {
            throw new IllegalStateException("RendererUtils/getStyleParameter : StyleString or StyleParameterName mustn't be null or empty.");
        }
        String tempString = null;
        String savedString = null;
        StringBuffer resultString = new StringBuffer();
        String styleParameterName = aStyleParameterName.trim().toUpperCase();
        StringTokenizer styleStringTokenizer = new StringTokenizer(aStyleString, ";");
        while (styleStringTokenizer.hasMoreTokens()) {
            savedString = styleStringTokenizer.nextToken();
            int ind = savedString.indexOf(58);
            if (ind < 0 || !(tempString = savedString.substring(0, ind).trim().toUpperCase()).equals(styleParameterName)) continue;
            resultString.append(savedString);
            resultString.append(';');
            break;
        }
        return resultString.length() == 0 ? null : resultString.toString();
    }

    public static String parenthesizeString(String aString) {
        if (aString == null || aString.length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('(').append(aString).append(')');
        return buffer.toString();
    }

    public static String createJScriptBeginTag(String aScriptVersion) {
        StringBuffer buffer = new StringBuffer("<SCRIPT LANGUAGE=\"JavaScript");
        if (aScriptVersion != null) {
            buffer.append(aScriptVersion);
        }
        buffer.append("\">\n");
        return buffer.toString();
    }

    public static String createJScriptEndTag() {
        return "</SCRIPT>\n";
    }

    public static String bracketString(String aString) {
        if (aString == null || aString.length() == 0) {
            return "null";
        }
        char bracket = aString.indexOf(34) > 0 ? (char)'\'' : '\"';
        char sym = aString.charAt(0);
        StringBuffer sb = new StringBuffer();
        if (sym != '\"' && sym != '\'') {
            sb.append(bracket);
        }
        sb.append(aString);
        sym = aString.charAt(aString.length() - 1);
        if (sym != bracket) {
            sb.append(bracket);
        }
        return sb.toString();
    }

    public static String createJScriptVariableName(String aPrefix, String aId) {
        RendererFactory.validateValue(aId, "Java script variable ID");
        StringBuffer sBuffer = new StringBuffer();
        if (aPrefix != null) {
            sBuffer.append(aPrefix.toLowerCase());
            sBuffer.append('_');
        }
        sBuffer.append(aId);
        return sBuffer.toString();
    }

    public static String createJScriptVariableName(ComponentBase aComponentBase) {
        return RendererFactory.createJScriptVariableName(aComponentBase.getComponentTypeName(), aComponentBase.getId());
    }

    public static String createHtmlJScriptVariable(String aVarName, String aJScriptComponent, String aParam) {
        RendererFactory.validateValue(aJScriptComponent, "Java script component");
        StringBuffer sBuffer = new StringBuffer(RendererFactory.indentString(1, "var "));
        sBuffer.append(aVarName);
        sBuffer.append(" = new ");
        sBuffer.append(aJScriptComponent);
        sBuffer.append('(');
        RendererFactory.processParams(sBuffer, aParam, false);
        sBuffer.append(");");
        return RendererFactory.createHtmlJScriptCommand(sBuffer.toString());
    }

    public static String createHtmlJScriptVariable(String aPrefix, String aId, String aJScriptComponent, String aParam) {
        RendererFactory.validateValue(aJScriptComponent, "Java script component");
        StringBuffer sBuffer = new StringBuffer(RendererFactory.indentString(1, "var "));
        sBuffer.append(RendererFactory.createJScriptVariableName(aPrefix, aId));
        sBuffer.append("= new");
        sBuffer.append(' ');
        sBuffer.append(aJScriptComponent);
        sBuffer.append('(');
        sBuffer.append(RendererFactory.bracketString(aId));
        RendererFactory.processParams(sBuffer, aParam, true);
        sBuffer.append(");");
        return RendererFactory.createHtmlJScriptCommand(sBuffer.toString());
    }

    public static String createHtmlJScriptVariable(String aPrefix, String aId, String aJScriptComponent, Iterator aParams) {
        StringBuffer params = new StringBuffer();
        if (aParams != null) {
            while (aParams.hasNext()) {
                params.append((String)aParams.next());
                params.append(',');
            }
        }
        return RendererFactory.createHtmlJScriptVariable(aPrefix, aId, aJScriptComponent, params.toString());
    }

    public static String createHtmlJScriptVariable(ComponentBase aComponentBase, String aJScriptComponent, String aParam) {
        return RendererFactory.createHtmlJScriptVariable(aComponentBase.getComponentTypeName(), aComponentBase.getId(), aJScriptComponent, aParam);
    }

    public static String createHtmlJScriptVariable(ComponentBase aComponentBase, String aJScriptComponent, Iterator aParams) {
        return RendererFactory.createHtmlJScriptVariable(aComponentBase.getComponentTypeName(), aComponentBase.getId(), aJScriptComponent, aParams);
    }

    public static String createHtmlJScriptVariable(ComponentBase aComponentBase, String aJScriptComponent) {
        return RendererFactory.createHtmlJScriptVariable(aComponentBase, aJScriptComponent, null);
    }

    public static String createHtmlJScriptCommand(String aCommand, String aSrc) {
        RendererFactory.validateCommand(aCommand, aSrc);
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererFactory.produceJScriptCommandHeader(aSrc));
        sBuffer.append(RendererFactory.produceJScriptCommandBody(aCommand));
        sBuffer.append(RendererFactory.createJScriptEndTag());
        return sBuffer.toString();
    }

    private static void validateCommand(String aCommand, String aSrc) {
        if (aCommand == null || aCommand.length() == 0) {
            RendererFactory.validateValue(aSrc, "Src");
        }
        if (aSrc == null || aSrc.length() == 0) {
            RendererFactory.validateValue(aCommand, "Command");
        }
    }

    public static String createHtmlJScriptCommand(String aCommand, String aSrc, short aBrowserType) {
        RendererFactory.validateCommand(aCommand, aSrc);
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererFactory.produceJScriptCommandHeader(aSrc, aBrowserType));
        sBuffer.append(RendererFactory.produceJScriptCommandBody(aCommand));
        sBuffer.append(RendererFactory.createJScriptEndTag());
        return sBuffer.toString();
    }

    private static String produceJScriptCommandBody(String aCommand) {
        StringBuffer sBuffer = new StringBuffer();
        if (aCommand != null && aCommand.length() > 0) {
            sBuffer.append("<!--\n");
            sBuffer.append(RendererFactory.indentString(1, aCommand)).append("\n");
            sBuffer.append("// -->\n");
        }
        return sBuffer.toString();
    }

    public static String createJScriptBeginTag(String aSrc, String aScriptVersion) {
        RendererFactory.validateValue(aSrc, "Script source");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<SCRIPT LANGUAGE=\"JavaScript");
        if (aScriptVersion != null) {
            buffer.append(aScriptVersion);
        }
        buffer.append("\" ");
        buffer.append(RendererFactory.createHtmlStylePropertyString("SRC", aSrc));
        buffer.append(">\n");
        return buffer.toString();
    }

    private static String produceJScriptCommandHeader(String aSrc, short aBrowserType) {
        StringBuffer sBuffer = new StringBuffer("<SCRIPT");
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("LANGUAGE", "JavaScript"));
        if (aSrc != null && aSrc.length() > 0) {
            sBuffer.append(' ');
            StringBuffer path = null;
            switch (aBrowserType) {
                case 2: 
                case 3: {
                    path = new StringBuffer(RendererFactory.getPathToJavaScriptsNetscape());
                    break;
                }
                default: {
                    path = new StringBuffer(RendererFactory.getPathToJavaScriptsExplorer());
                    break;
                }
                case 5: {
                    path = new StringBuffer(RendererFactory.getPathToJavaScriptsIce());
                    break;
                }
                case 4: {
                    path = new StringBuffer(RendererFactory.getPathToJavaScriptsOpera());
                }
            }
            path.append(aSrc);
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("SRC", path.toString()));
        }
        sBuffer.append('>').append("\n");
        return sBuffer.toString();
    }

    public static String createHtmlJScriptCommand(String aCommand) {
        return RendererFactory.createHtmlJScriptCommand(aCommand, null);
    }

    public static String createHtmlJScriptString(String aSrc) {
        return RendererFactory.createHtmlJScriptCommand(null, aSrc);
    }

    public static String createHtmlJScriptString(String aSrc, short aBrowserType) {
        return RendererFactory.createHtmlJScriptCommand(null, aSrc, aBrowserType);
    }

    public static String createHtmlStylePropertyString(String aName, String aValue) {
        RendererFactory.validateValue(aName, "Property");
        StringBuffer sb = new StringBuffer(aName);
        if (aValue != null) {
            sb.append('=');
            sb.append(RendererFactory.bracketString(aValue));
        }
        return sb.toString();
    }

    public static String createHtmlStylePropertyString(String aName, int aValue) {
        return RendererFactory.createHtmlStylePropertyString(aName, String.valueOf(aValue));
    }

    public static String createHtmlStylePropertyString(String aName, char aValue) {
        return RendererFactory.createHtmlStylePropertyString(aName, String.valueOf(aValue));
    }

    public static String createHtmlStylePropertyString(String aName, boolean aValue) {
        return RendererFactory.createHtmlStylePropertyString(aName, String.valueOf(aValue));
    }

    public static String createHtmlStylePropertyString(HtmlProperty aHtmlProperty) {
        return RendererFactory.createHtmlStylePropertyString(aHtmlProperty.getKey(), aHtmlProperty.getValue());
    }

    public static String createHtmlStyleString(String aName, String aValue) {
        RendererFactory.validateValue(aName, "Style property name");
        StringBuffer sb = new StringBuffer(aName);
        sb.append(':');
        if (aValue != null) {
            sb.append(aValue);
        }
        sb.append(';');
        return sb.toString();
    }

    public static String createHtmlStartTagForTableCell(Component aComponent, int aColSpan, int aRowSpan, int aDefaultAlign, int aDefaultValign) {
        Constraint constraint;
        StringBuffer sBuffer = new StringBuffer("<TD");
        int align = aDefaultAlign;
        int valign = aDefaultValign;
        String width = null;
        String height = null;
        if (aComponent != null && (constraint = aComponent.getConstraint()) != null && constraint instanceof LayoutConstraint) {
            LayoutConstraint layoutConstraint = (LayoutConstraint)constraint;
            if (layoutConstraint.getAlign() != -1) {
                align = layoutConstraint.getAlign();
            }
            if (layoutConstraint.getValign() != -1) {
                valign = layoutConstraint.getValign();
            }
            if (layoutConstraint.getWidth() != null) {
                width = layoutConstraint.getWidth();
            }
            if (layoutConstraint.getHeight() != null) {
                height = layoutConstraint.getHeight();
            }
        }
        ArrayList<HtmlProperty> propertyList = new ArrayList<HtmlProperty>();
        if (align != -1) {
            propertyList.add(new HtmlProperty("ALIGN", TagFactory.getAlignValue(align)));
        }
        if (valign != -1) {
            propertyList.add(new HtmlProperty("VALIGN", TagFactory.getValignValue(valign)));
        }
        if (width != null) {
            propertyList.add(new HtmlProperty("WIDTH", width));
        }
        if (height != null) {
            propertyList.add(new HtmlProperty("HEIGHT", height));
        }
        if (aColSpan > 1) {
            propertyList.add(new HtmlProperty("COLSPAN", aColSpan));
        }
        if (aRowSpan > 1) {
            propertyList.add(new HtmlProperty("ROWSPAN", aRowSpan));
        }
        Iterator uniqHtmlProperty = ((AbstractList)propertyList).iterator();
        while (uniqHtmlProperty.hasNext()) {
            sBuffer.append(' ');
            HtmlProperty htmlProperty = (HtmlProperty)uniqHtmlProperty.next();
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
        }
        sBuffer.append('>');
        return sBuffer.toString();
    }

    public static String componentRender(Renderer aComponentRender, PageContext aPageContext) throws RendererException {
        RendererFactory.validateValue(aPageContext, "PageContext");
        RendererFactory.validateValue(aComponentRender, "Renderer");
        if (aComponentRender instanceof ContextRenderer) {
            ((ContextRenderer)aComponentRender).setPageContext(aPageContext);
        }
        String result = aComponentRender.render();
        return result;
    }

    public static String componentRender(ComponentBase aComponentBase, PageContext aPageContext) throws RendererException {
        RendererFactory.validateValue(aPageContext, "PageContext");
        RendererFactory.validateValue(aComponentBase, "Component");
        RendererFactory.validateValue(aComponentBase.getRenderer(), "Renderer");
        Renderer renderer = aComponentBase.getRenderer();
        if (renderer.getComponent() == null) {
            renderer.setComponent(aComponentBase);
        }
        if (renderer instanceof ContextRenderer) {
            aPageContext.setAttribute(aComponentBase.getId(), (Object)aComponentBase, 2);
        }
        return RendererFactory.componentRender(renderer, aPageContext);
    }

    public static String freeSpaceRender(PageContext aPageContext) throws RendererException {
        try {
            RendererFactory.validateValue(aPageContext, "PageContext");
            StringBuffer sBuffer = new StringBuffer("<IMG");
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("SRC", RendererFactory.getPathToImage(TRANSPARENT_IMAGE_SRC)));
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("WIDTH", 1));
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("HEIGHT", 1));
            sBuffer.append('>');
            return sBuffer.toString();
        }
        catch (Exception e) {
            throw new RendererException(e.toString());
        }
    }

    public static Iterator componentBaseHtmlPropertiesIterator(ComponentBase aComponentBase) {
        RendererFactory.validateValue(aComponentBase, "Component");
        ArrayList<HtmlProperty> aList = new ArrayList<HtmlProperty>();
        if (aComponentBase.getId() != null) {
            aList.add(new HtmlProperty("ID", aComponentBase.getId()));
        }
        if (aComponentBase.getName() != null) {
            aList.add(new HtmlProperty("NAME", aComponentBase.getName()));
        }
        if (aComponentBase.getStyleClass() != null) {
            aList.add(new HtmlProperty("CLASS", aComponentBase.getStyleClass()));
        }
        if (aComponentBase.getStyle() != null) {
            aList.add(new HtmlProperty("STYLE", aComponentBase.getStyle()));
        }
        return ((AbstractList)aList).iterator();
    }

    public static Iterator componentHtmlPropertiesIterator(Component aComponent) {
        RendererFactory.validateValue(aComponent, "Component");
        ArrayList aList = new ArrayList();
        if (aComponent.getLeft() != null || aComponent.getTop() != null || aComponent.getZindex() != -1) {
            aComponent.addStyleProperty("POSITION", "absolute");
            if (aComponent.getLeft() != null) {
                aComponent.addStyleProperty("LEFT", aComponent.getLeft());
            }
            if (aComponent.getTop() != null) {
                aComponent.addStyleProperty("TOP", aComponent.getTop());
            }
            if (aComponent.getZindex() != -1) {
                aComponent.addStyleProperty("Z-INDEX", String.valueOf(aComponent.getZindex()));
            }
        }
        if (!aComponent.isVisible()) {
            aComponent.addStyleProperty("DISPLAY", "none");
        }
        if (aComponent.getWidth() != null) {
            aComponent.addStyleProperty("WIDTH", aComponent.getWidth());
        }
        if (aComponent.getHeight() != null) {
            aComponent.addStyleProperty("HEIGHT", aComponent.getHeight());
        }
        Iterator baseProperty = RendererFactory.componentBaseHtmlPropertiesIterator(aComponent);
        while (baseProperty.hasNext()) {
            aList.add(baseProperty.next());
        }
        if (aComponent.getHintText() != null) {
            aList.add(new HtmlProperty("TITLE", aComponent.getHintText()));
        }
        if (aComponent.getTabIndex() != -1) {
            aList.add(new HtmlProperty("TABINDEX", aComponent.getTabIndex()));
        }
        if (aComponent.getAlign() != -1) {
            String align = TagFactory.getAlignValue(aComponent.getAlign());
            aList.add(new HtmlProperty("ALIGN", align));
        }
        if (aComponent.getAccessKey() != '\u0000') {
            aList.add(new HtmlProperty("ACCESSKEY", aComponent.getAccessKey()));
        }
        if (!aComponent.isEnabled()) {
            aList.add(new HtmlProperty("DISABLED", null));
        }
        return ((AbstractList)aList).iterator();
    }

    public static String getJSPPath(PageContext aPageContext) {
        ServletRequest request = aPageContext.getRequest();
        if (request != null && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            StringBuffer path = new StringBuffer();
            path.append(httpRequest.getRequestURI());
            return path.toString();
        }
        throw new IllegalStateException(request != null ? "Request not found." : "Type of request not supported.");
    }

    public static String getEncodedURL(String aPath, PageContext aPageContext) {
        if (aPath == null) {
            throw new IllegalArgumentException("GetEncodeURL: Path can't be null.");
        }
        ServletRequest request = aPageContext.getRequest();
        if (request == null || !(request instanceof HttpServletRequest)) {
            throw new IllegalStateException("GetEncodeURL: Invalid request.");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ServletResponse response = aPageContext.getResponse();
        if (response == null || !(response instanceof HttpServletResponse)) {
            throw new IllegalStateException("GetEncodeURL: Invalid response.");
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        return httpResponse.encodeURL(aPath);
    }

    public static boolean isExplorerBrowser(ClientAgentInfo aUserAgentInfo) {
        String browserName = aUserAgentInfo.getBrowserName().toUpperCase();
        String explorerName = "MSIE".toUpperCase();
        return browserName.equals(explorerName);
    }

    public static boolean isNetscapeBrowser(ClientAgentInfo aUserAgentInfo) {
        String browserName = aUserAgentInfo.getBrowserName().toUpperCase();
        String netscapeName = "Netscape6".toUpperCase();
        return browserName.equals(netscapeName);
    }

    public static boolean isOperaBrowser(ClientAgentInfo aUserAgentInfo) {
        String browserName = aUserAgentInfo.getBrowserName().toUpperCase();
        String operaName = "Opera".toUpperCase();
        return browserName.equals(operaName);
    }

    public static boolean isMozillaBrowser(ClientAgentInfo aUserAgentInfo) {
        String browserName = aUserAgentInfo.getBrowserName().toUpperCase();
        String mozillaName = "Mozilla".toUpperCase();
        return browserName.equals(mozillaName);
    }

    public static boolean isIceBrowser(ClientAgentInfo aUserAgentInfo) {
        String browserName = aUserAgentInfo.getBrowserName().toUpperCase();
        String iceName = "ICE Browser".toUpperCase();
        return browserName.equals(iceName);
    }

    public static short getBrowserType(ClientAgentInfo aUserAgentInfo) {
        String browserName = aUserAgentInfo.getBrowserName().toUpperCase();
        Object browserType = null;
        browserType = fBrowserTypeToBrowserNameMap.getKey(browserName);
        if (browserType != null) {
            return (Short)browserType;
        }
        return 0;
    }

    private static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("RendererUtils: " + aName + " can't be null.");
        }
    }

    private static void validateValue(String aValue, String aName) {
        if (aValue == null || aValue.length() == 0) {
            throw new IllegalArgumentException("RendererUtils: " + aName + " value is invalid.");
        }
    }

    private static String produceJScriptCommandHeader(String aSrc) {
        StringBuffer sBuffer = new StringBuffer("<SCRIPT ");
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("LANGUAGE", "JavaScript"));
        if (aSrc != null && aSrc.length() > 0) {
            sBuffer.append(' ');
            StringBuffer path = new StringBuffer(RendererFactory.getPathToJavaScripts());
            path.append(aSrc);
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("SRC", path.toString()));
        }
        sBuffer.append(">\n");
        return sBuffer.toString();
    }

    private static String getBrowserDependenceJavaScriptPath(String aSuffix) {
        StringBuffer sBuffer = new StringBuffer(RendererFactory.getPathToJavaScripts());
        if (aSuffix != null) {
            sBuffer.append(aSuffix);
        }
        return sBuffer.toString();
    }

    private static String normalizePath(String aPath, boolean aCanBeNull) {
        if (aPath == null || aPath.length() == 0) {
            return aCanBeNull ? null : "";
        }
        if ((aPath = aPath.replace(File.separatorChar, '/')).endsWith("/")) {
            return aPath;
        }
        StringBuffer sBuffer = new StringBuffer(aPath);
        sBuffer.append('/');
        return sBuffer.toString();
    }

    private static void processParams(StringBuffer aBuffer, String aParams, boolean aCommaIndicator) {
        if (aParams != null && aParams.length() > 0) {
            String param;
            if (aCommaIndicator) {
                aBuffer.append(',');
            }
            if ((param = aParams.trim()).charAt(0) == ',') {
                param = param.substring(1);
            }
            if (param.length() > 0 && param.charAt(param.length() - 1) == ',') {
                param = param.substring(0, param.length() - 1);
            }
            aBuffer.append(param);
        }
    }

    public static String getSuffixPathToJavaScriptsExplorer() {
        return suffixPathToJavaScriptsExplorer;
    }

    public static String getSuffixPathToJavaScriptsIce() {
        return suffixPathToJavaScriptsIce;
    }

    public static String getSuffixPathToJavaScriptsNetscape() {
        return suffixPathToJavaScriptsNetscape;
    }

    public static String getSuffixPathToJavaScriptsOpera() {
        return suffixPathToJavaScriptsOpera;
    }

    public static void setSuffixPathToJavaScriptsExplorer(String string) {
        suffixPathToJavaScriptsExplorer = string;
    }

    public static void setSuffixPathToJavaScriptsIce(String string) {
        suffixPathToJavaScriptsIce = string;
    }

    public static void setSuffixPathToJavaScriptsNetscape(String string) {
        suffixPathToJavaScriptsNetscape = string;
    }

    public static void setSuffixPathToJavaScriptsOpera(String string) {
        suffixPathToJavaScriptsOpera = string;
    }

    public static Object findAttributeValueInAllScopes(String attributeName, HttpServletRequest request) throws IllegalStateException {
        Object result = null;
        if (request.getAttribute(attributeName) != null) {
            result = request.getAttribute(attributeName);
        } else if (request.getSession(true).getAttribute(attributeName) != null) {
            result = request.getSession(true).getAttribute(attributeName);
        } else if (RendererFactory.getServletContext().getAttribute(attributeName) != null) {
            result = RendererFactory.getServletContext().getAttribute(attributeName);
        } else {
            throw new IllegalStateException("Value for the Attribute:" + attributeName + " haven't been found in REQUEST,SESSION,APPLICATION scopes");
        }
        return result;
    }

    public static String getTreeDynamicDataModelProviderServletUrl() {
        if ("".equals(treeDynamicDataModelProviderServletUrl)) {
            throw new IllegalStateException("treeDynamicDataModelProviderServletUrl init param must be set in ComponentInitializer Servlet section of web.xml descriptor");
        }
        return treeDynamicDataModelProviderServletUrl;
    }

    public static void setTreeDynamicDataModelProviderServletUrl(String string) {
        treeDynamicDataModelProviderServletUrl = string;
    }

    public static String getVariableListing() {
        return variableListing;
    }

    public static void setVariableListing(String string) {
        variableListing = string;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        RendererFactory.servletContext = servletContext;
    }
}

