/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.base;

import com.softaspects.framework.galileo.renderers.html.base.ExplorerJavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProvider;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.NetscapeJavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfo;
import com.softaspects.framework.galileo.support.components.clientagent.ClientAgentInfoGenerator;
import com.softaspects.framework.galileo.support.util.ReverseHashMap;
import javax.servlet.http.HttpServletRequest;

public class JavaScriptProviderBase
implements JavaScriptProvider {
    private static ReverseHashMap fJavaScriptResourcesMap = new ReverseHashMap();

    static {
        fJavaScriptResourcesMap.put(new Short(1), new ExplorerJavaScriptResource());
        fJavaScriptResourcesMap.put(new Short(3), new NetscapeJavaScriptResource());
        fJavaScriptResourcesMap.put(new Short(2), new NetscapeJavaScriptResource());
    }

    public JavaScriptResource getJavaScriptResource(HttpServletRequest aRequest) {
        Object userAgentInfo = aRequest.getSession().getAttribute("USER_AGENT_INFO");
        if (userAgentInfo == null) {
            userAgentInfo = new ClientAgentInfoGenerator().getUserAgentInfo(aRequest);
            aRequest.getSession().setAttribute("USER_AGENT_INFO", userAgentInfo);
        }
        return this.getResource((ClientAgentInfo)userAgentInfo);
    }

    public JavaScriptResource getJavaScriptResource(ClientAgentInfo aUserAgentInfo) {
        return this.getResource(aUserAgentInfo);
    }

    private JavaScriptResource getResource(ClientAgentInfo aUserAgentInfo) {
        if (aUserAgentInfo == null) {
            throw new IllegalArgumentException("UserAgentInfo can't be null");
        }
        short browserType = RendererFactory.getBrowserType(aUserAgentInfo);
        Object resource = fJavaScriptResourcesMap.getValue(new Short(browserType));
        if (resource == null) {
            return new ExplorerJavaScriptResource();
        }
        return (JavaScriptResource)resource;
    }
}

