/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table.additions.comparators;

import com.softaspects.framework.galileo.components.table.BaseComparator;
import java.math.BigInteger;

public class NumberComparator
extends BaseComparator {
    private static final boolean EXCEPTION_IF_TYPE_NOT_COMPLIANCE = false;

    public int compareValue(Object aValue1, Object aValue2) {
        if (aValue1 instanceof Number && aValue2 instanceof Number) {
            if (aValue1 instanceof Integer || aValue1 instanceof Long || aValue1 instanceof Short || aValue1 instanceof BigInteger && ((BigInteger)aValue1).bitLength() < 64) {
                long value1 = ((Number)aValue1).longValue();
                if (aValue2 instanceof Integer || aValue2 instanceof Long || aValue2 instanceof Short || aValue2 instanceof BigInteger && ((BigInteger)aValue2).bitLength() < 64) {
                    long value2 = ((Number)aValue2).longValue();
                    return value1 < value2 ? -1 : (value1 == value2 ? 0 : 1);
                }
                double value2 = ((Number)aValue2).doubleValue();
                return (double)value1 < value2 ? -1 : ((double)value1 == value2 ? 0 : 1);
            }
            double value1 = ((Number)aValue1).doubleValue();
            if (aValue2 instanceof Integer || aValue2 instanceof Long || aValue2 instanceof Short || aValue2 instanceof BigInteger && ((BigInteger)aValue2).bitLength() < 64) {
                long value2 = ((Number)aValue2).longValue();
                return value1 < (double)value2 ? -1 : (value1 == (double)value2 ? 0 : 1);
            }
            double value2 = ((Number)aValue2).doubleValue();
            return value1 < value2 ? -1 : (value1 == value2 ? 0 : 1);
        }
        NumberComparator.exceptionIfTypeNotCompliance();
        try {
            double value1 = Double.parseDouble(aValue1.toString());
            double value2 = Double.parseDouble(aValue2.toString());
            return value1 < value2 ? -1 : (value1 == value2 ? 0 : 1);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    private static void exceptionIfTypeNotCompliance() {
    }
}

