/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table.additions.changers;

import com.softaspects.framework.galileo.components.table.BaseCellChanger;
import com.softaspects.framework.galileo.components.table.ChangeException;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.components.table.additions.NumberUtil;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class NumberChanger
extends BaseCellChanger {
    private NumberFormat fNumberFormat;

    protected void setNumberFormat(NumberFormat aNumberFormat) {
        this.fNumberFormat = aNumberFormat;
    }

    protected NumberFormat getNumberFormat() {
        return this.fNumberFormat;
    }

    protected String getValue(String aValue) {
        return aValue.trim();
    }

    protected Object createNewCellObject(Class aCellClass, String aValue) throws ChangeException {
        if (aCellClass != null) {
            try {
                Number number = this.getNumberFormat().parse(this.getValue(aValue));
                return NumberUtil.createNumber(aCellClass, number);
            }
            catch (ParseException e) {
                throw new ChangeException(e.toString(), e);
            }
        }
        return null;
    }

    protected Object setValue(Object aCellObject, String aValue) throws ChangeException {
        return this.createNewCellObject(aCellObject.getClass(), aValue);
    }

    protected void initCellChanger(Table aTable, int aRowIndex, int aColumnIndex) {
        Locale locale = aTable.getInterfaceManager().getLocale();
        this.setNumberFormat(NumberFormat.getNumberInstance(locale));
    }
}

