/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.table.DataModelImpl;
import com.softaspects.framework.galileo.components.table.RowIdData;
import com.softaspects.framework.galileo.components.table.RowIdDataModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RowIdDataModelImpl
extends DataModelImpl
implements RowIdDataModel {
    protected HashMap fIDMap = new HashMap();

    public RowIdDataModelImpl(List aDataList, List aColumnsIdeftifiersList) {
        super(aDataList, aColumnsIdeftifiersList);
    }

    public RowIdDataModelImpl(List aDataList) {
        super(aDataList);
    }

    public RowIdDataModelImpl(Object[][] aData, Object[] aColumnsIdeftifiers) {
        super(aData, aColumnsIdeftifiers);
    }

    public RowIdDataModelImpl(Object[][] aData) {
        super(aData);
    }

    public RowIdDataModelImpl(int aRowCount, List aColumnsIdeftifiersList) {
        super(aRowCount, aColumnsIdeftifiersList);
    }

    public RowIdDataModelImpl() {
    }

    public Object getValueAt(int aRowIndex, int aColumnIndex) {
        if (this.validateBounds(aRowIndex, aColumnIndex)) {
            RowIdData rowData = (RowIdData)this.getDataList().get(aRowIndex);
            return rowData.getList().get(aColumnIndex);
        }
        return null;
    }

    public void setValueAt(Object aValue, int aRowIndex, int aColumnIndex) {
        if (this.validateBounds(aRowIndex, aColumnIndex) && this.isCellEditable(aRowIndex, aColumnIndex)) {
            RowIdData rowData = (RowIdData)this.getDataList().get(aRowIndex);
            rowData.getList().set(aColumnIndex, aValue);
        }
    }

    public void addRow(List aRowData, Object aID) {
        List row = aRowData != null ? aRowData : new ArrayList(this.getColumnCount());
        this.getDataList().add(new RowIdData(row, aID));
        if (aID != null) {
            this.fIDMap.put(aID, row);
        }
        ++this.rowCount;
        this.getCursor().setRowsCount(this.getRowCount());
    }

    public void addRow(List aRowData) {
        this.addRow(aRowData, null);
    }

    public void insertRow(int aRowIndex, List aRowData, Object aID) {
        this.validateRows(aRowIndex);
        List row = aRowData != null ? aRowData : new ArrayList(this.getColumnCount());
        this.getDataList().add(aRowIndex, new RowIdData(row, aID));
        if (aID != null) {
            this.fIDMap.put(aID, row);
        }
        ++this.rowCount;
        this.getCursor().setRowsCount(this.getRowCount());
    }

    public void insertRow(int aRowIndex, List aRowDataList) {
        this.insertRow(aRowIndex, aRowDataList, null);
    }

    public void setData(List aNewData, int aColumnsCount) {
        this.getDataList().clear();
        if (aNewData != null) {
            List dataList = this.getDataList();
            int i = 0;
            while (i < aNewData.size()) {
                List row = (List)aNewData.get(i);
                dataList.add(new RowIdData(row));
                ++i;
            }
        }
        this.setColumnCount(aColumnsCount);
        this.getCursor().setRowsCount(this.getRowCount());
    }

    public void setColumnCount(int aColumnCount) {
        List dataList = this.getDataList();
        int i = 0;
        while (i < this.getRowCount()) {
            RowIdData rowData = (RowIdData)dataList.get(i);
            rowData.setColumnCount(aColumnCount);
            ++i;
        }
        this.columnCount = aColumnCount;
        if (aColumnCount > this.fEditList.size()) {
            while (this.fEditList.size() < aColumnCount) {
                this.fEditList.add(DataModelImpl.createDefaultEditBitSet());
            }
        }
    }

    public void setRowCount(int aNewSize) {
        DataModelImpl.validateValue(aNewSize, "Row count");
        if (aNewSize != this.getRowCount()) {
            if (aNewSize > this.getRowCount()) {
                int columnCount = this.getColumnCount();
                while (this.getRowCount() < aNewSize) {
                    ArrayList row = new ArrayList(columnCount);
                    this.getDataList().add(new RowIdData(row));
                }
            }
            this.rowCount = aNewSize;
            this.getCursor().setRowsCount(aNewSize);
        }
    }

    public List getRow(int aRowIndex) {
        RowIdData rowData = (RowIdData)this.getDataList().get(aRowIndex);
        return rowData == null ? null : rowData.getList();
    }

    public Iterator getData() {
        return new DataIterator(this.getDataList().iterator());
    }

    public void clearData() {
        super.clearData();
        this.fIDMap.clear();
    }

    public void removeRow(int aRowIndex) {
        RowIdData rowData;
        if (this.validateRows(aRowIndex) && (rowData = (RowIdData)this.getDataList().get(aRowIndex)).getID() != null) {
            this.fIDMap.remove(rowData.getID());
        }
        super.removeRow(aRowIndex);
    }

    public Comparator getRowComparator(Comparator aColumnComparator, int aIndex, boolean aAsc) {
        return new RowComparator(aColumnComparator, aIndex, aAsc);
    }

    public void setID(Object aID, int aRowIndex) {
        DataModelImpl.validateValue(aID, "Row ID");
        if (this.validateRows(aRowIndex)) {
            RowIdData rowData = (RowIdData)this.getDataList().get(aRowIndex);
            rowData.setID(aID);
            this.fIDMap.put(aID, rowData.getList());
        } else {
            DataModelImpl.generateExceptionOutOfBound("Row index");
        }
    }

    public Object getID(int aRowIndex) {
        if (this.validateRows(aRowIndex)) {
            RowIdData rowData = (RowIdData)this.getDataList().get(aRowIndex);
            return rowData.getID();
        }
        return null;
    }

    public List getRowByID(Object aID) {
        if (aID != null) {
            return (List)this.fIDMap.get(aID);
        }
        return null;
    }

    protected static class DataIterator
    implements Iterator {
        private Iterator fRowDataIterator;

        public DataIterator(Iterator aRowDataIterator) {
            this.fRowDataIterator = aRowDataIterator;
        }

        public Object next() {
            RowIdData next = (RowIdData)this.fRowDataIterator.next();
            return next == null ? null : next.getList();
        }

        public boolean hasNext() {
            return this.fRowDataIterator.hasNext();
        }

        public void remove() {
            this.fRowDataIterator.remove();
        }
    }

    protected static class RowComparator
    implements Comparator {
        private Comparator fColumnComparator;
        private int fDataModelColumnIndex;
        private boolean fAscMode;

        public RowComparator(Comparator aColumnComparator, int aIndex, boolean aAsc) {
            this.fColumnComparator = aColumnComparator;
            this.fAscMode = aAsc;
            this.fDataModelColumnIndex = aIndex;
        }

        public int compare(Object aRow1, Object aRow2) {
            RowIdData rowData1 = (RowIdData)aRow1;
            RowIdData rowData2 = (RowIdData)aRow2;
            Object data1 = rowData1.getList().get(this.fDataModelColumnIndex);
            Object data2 = rowData2.getList().get(this.fDataModelColumnIndex);
            int result = this.fColumnComparator.compare(data1, data2);
            return this.fAscMode ? result : -result;
        }
    }
}

