/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.table.ColumnModel;
import com.softaspects.framework.galileo.components.table.ColumnModelImpl;
import com.softaspects.framework.galileo.components.table.Header;
import com.softaspects.framework.galileo.renderers.html.table.DefaultHeaderRenderer;
import com.softaspects.framework.galileo.renderers.html.table.HeaderRenderer;

public class HeaderImpl
implements Header {
    protected ColumnModel fTableColumnModel;
    protected HeaderRenderer fTableHeaderRenderer;
    protected boolean fShowHeader = true;
    protected boolean fNoWrapMode = false;
    protected boolean fHighLightAllowed = true;
    protected String fHintText = "Double click to sort";
    protected String fHeight = null;
    protected int fAlignMode = 3;
    protected int fValignMode = -1;

    public HeaderImpl(ColumnModel aTableColumnModel) {
        if (aTableColumnModel != null) {
            this.setTableColumnModel(aTableColumnModel);
        } else {
            this.setTableColumnModel(this.createDefaultColumnModel());
        }
        this.setDefaultTableHeaderRenderer(this.createDefaultRenderer());
    }

    public HeaderImpl() {
        this(null);
    }

    public void setTableColumnModel(ColumnModel aTableColumnModel) {
        HeaderImpl.validateValue(aTableColumnModel, "Table column model");
        this.fTableColumnModel = aTableColumnModel;
    }

    public ColumnModel getTableColumnModel() {
        return this.fTableColumnModel;
    }

    public void setShowHeader(boolean aShowHeader) {
        this.fShowHeader = aShowHeader;
    }

    public boolean isShowHeader() {
        return this.fShowHeader;
    }

    public void setDefaultTableHeaderRenderer(HeaderRenderer aTableHeaderRenderer) {
        HeaderImpl.validateValue(aTableHeaderRenderer, "Table header renderer");
        this.fTableHeaderRenderer = aTableHeaderRenderer;
    }

    public HeaderRenderer getDefaultHeaderRenderer() {
        return this.fTableHeaderRenderer;
    }

    protected ColumnModel createDefaultColumnModel() {
        return new ColumnModelImpl();
    }

    protected HeaderRenderer createDefaultRenderer() {
        return new DefaultHeaderRenderer();
    }

    public void setHintText(String aHintText) {
        this.fHintText = aHintText;
    }

    public String getHintText() {
        return this.fHintText;
    }

    public void setNoWrapMode(boolean aNoWrapMode) {
        this.fNoWrapMode = aNoWrapMode;
    }

    public boolean isNoWrapMode() {
        return this.fNoWrapMode;
    }

    public void setAlignMode(int aAlign) {
        if (aAlign < 1 || aAlign > 1) {
            throw new IllegalArgumentException("Table header: Align has wrong value.");
        }
        this.fAlignMode = aAlign;
    }

    public int getAlignMode() {
        return this.fAlignMode;
    }

    public void setValignMode(int aValign) {
        if (aValign < 1 || aValign > 1) {
            throw new IllegalArgumentException("Table header: Valign has wrong value.");
        }
        this.fValignMode = aValign;
    }

    public int getValignMode() {
        return this.fValignMode;
    }

    public void setHeight(String aHeight) {
        this.fHeight = aHeight;
    }

    public String getHeight() {
        return this.fHeight;
    }

    public void setHighLightAllowed(boolean aHighLightAllowed) {
        this.fHighLightAllowed = aHighLightAllowed;
    }

    public boolean isHighLightAllowed() {
        return this.fHighLightAllowed;
    }

    protected static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("TableHeader: " + aName + " can't be null.");
        }
    }
}

