/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.base.Interval;
import com.softaspects.framework.galileo.components.table.CellChanger;
import com.softaspects.framework.galileo.components.table.ChangeCommand;
import com.softaspects.framework.galileo.components.table.ChangeException;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.support.util.LazyHashMap;
import com.softaspects.framework.galileo.support.util.PriorityHashMap;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;

public class ChangeCommandImpl
implements ChangeCommand {
    private static final String OPERATION_VALUE_CHANGE = "Change cell value";
    private static final String OPERATION_ROW_DELETE = "Delete row";
    private static final String OPERATION_COLUMN_DELETE = "Column delete";
    private static final String OPERATION_SORT_BYCOLUMN = "Sort by column";
    private static final String OPERATION_SET_PAGE = "Set page";
    private static final String OPERATION_SELECT_ROW = "Select row";
    private static final String OPERATION_SELECT_COLUMN = "Select column";
    private static final String OPERATION_SMODEL_ROW = "Change row selection model";
    private static final String OPERATION_SMODEL_COLUMN = "Change column selection model";
    private static final int PRIORITY_VALUE_CHANGE = 20;
    private static final int PRIORITY_ROW_DELETE = 10;
    private static final int PRIORITY_COLUMN_DELETE = 10;
    private static final int PRIORITY_SMODEL_COLUMN = 5;
    private static final int PRIORITY_SMODEL_ROW = 5;
    private static final int PRIORITY_SELECT_COLUMN = 3;
    private static final int PRIORITY_SELECT_ROW = 3;
    private static final int PRIORITY_SORT_BYCOLUMN = 1;
    private static final int PRIORITY_SET_PAGE = 0;
    private static LazyHashMap fChangeTypesMap = new LazyHashMap();
    private static HashMap fChangePriorityMap = new HashMap();
    private static HashSet fCursorCommandSet = new HashSet();
    private PriorityHashMap fChangeRequestMap = new PriorityHashMap();
    private Table fTable = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        ChangeCommandImpl.initChangeTypesMap();
        ChangeCommandImpl.initCursorCommnadSet();
        ChangeCommandImpl.initChangePriorityMap();
    }

    public void setTable(Table aTable) {
        this.fTable = aTable;
    }

    public Table getTable() {
        if (this.fTable == null) {
            throw new IllegalStateException("TableChangeRequest: Table can't be null. ");
        }
        return this.fTable;
    }

    private static void initCursorCommnadSet() {
        fCursorCommandSet.add("FORWARD");
        fCursorCommandSet.add("BACKWARD");
        fCursorCommandSet.add("END");
        fCursorCommandSet.add("START");
    }

    private static void initChangeTypesMap() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableColumnDelete");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("CDELETE", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableRowDelete");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("RDELETE", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableSetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("PAGE", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableSortByColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("SORT", clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableChangeCellValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("CHANGE", clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableSelectColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("CSELECT", clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableSelectRow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("RSELECT", clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableChangeColumnSelectionModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("CMODEL", clazz8);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("com.softaspects.framework.galileo.components.table.ChangeCommandImpl$TableChangeRowSelectionModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fChangeTypesMap.putLazyValue("RMODEL", clazz9);
    }

    private static void initChangePriorityMap() {
        fChangePriorityMap.put("CDELETE", new Integer(10));
        fChangePriorityMap.put("RDELETE", new Integer(10));
        fChangePriorityMap.put("PAGE", new Integer(0));
        fChangePriorityMap.put("SORT", new Integer(1));
        fChangePriorityMap.put("CHANGE", new Integer(20));
        fChangePriorityMap.put("CSELECT", new Integer(3));
        fChangePriorityMap.put("RSELECT", new Integer(3));
        fChangePriorityMap.put("CMODEL", new Integer(5));
        fChangePriorityMap.put("RMODEL", new Integer(5));
    }

    public void setChangeRequest(Map aChangesMap) {
        this.clearChangeRequest();
        if (aChangesMap != null) {
            Iterator supportedParams = fChangeTypesMap.keySet().iterator();
            while (supportedParams.hasNext()) {
                String name = (String)supportedParams.next();
                String key = name.toUpperCase();
                if (!aChangesMap.containsKey(key)) continue;
                int priority = (Integer)fChangePriorityMap.get(key);
                this.fChangeRequestMap.put(key, aChangesMap.get(name), priority);
            }
        }
    }

    public void setChangeRequest(ServletRequest aServletRequest) {
        this.clearChangeRequest();
        if (aServletRequest != null && this.getTable().getId().equals(aServletRequest.getParameter("tableID"))) {
            Enumeration paramsName = aServletRequest.getParameterNames();
            while (paramsName.hasMoreElements()) {
                String value;
                String name = (String)paramsName.nextElement();
                String key = name.toUpperCase();
                if (!fChangeTypesMap.containsKey(key) || (value = aServletRequest.getParameter(name)) == null || value.equals("")) continue;
                StringTokenizer sTokenizer = new StringTokenizer(value, ";");
                int count = sTokenizer.countTokens();
                String[] values = new String[count];
                int i = 0;
                while (i < count) {
                    values[i] = sTokenizer.nextToken();
                    ++i;
                }
                int priority = (Integer)fChangePriorityMap.get(key);
                this.fChangeRequestMap.put(key, values, priority);
            }
        }
    }

    public void changeTable() {
        Table table = this.getTable();
        Iterator keys = this.fChangeRequestMap.getKeyIterator();
        while (keys.hasNext()) {
            String task = (String)keys.next();
            TableChanger tableChanger = (TableChanger)fChangeTypesMap.get(task);
            if (tableChanger != null) {
                tableChanger.setTable(table);
                String[] params = (String[])this.fChangeRequestMap.get(task);
                tableChanger.setParams(params);
                tableChanger.makeChange();
                continue;
            }
            table.addChangeResult("Can't create method for task' " + task + " '.");
        }
    }

    public void clearChangeRequest() {
        this.fChangeRequestMap.clear();
    }

    public Iterator getSupportedParams() {
        return fChangeTypesMap.keySet().iterator();
    }

    private static void throwTableChangeException(String aValue) throws ChangeException {
        throw new ChangeException("TableChangeRequest: " + aValue);
    }

    protected interface TableChanger {
        public void setTable(Table var1);

        public void setParams(String[] var1);

        public void makeChange();
    }

    private static abstract class AbstractTableChanger
    implements TableChanger {
        protected Table fTable = null;
        protected String[] fParams = null;

        AbstractTableChanger() {
        }

        public void setTable(Table aTable) {
            this.fTable = aTable;
        }

        protected Table getTable() {
            if (this.fTable == null) {
                throw new IllegalStateException("AbstractTableChanger: Table can't be null");
            }
            return this.fTable;
        }

        public void setParams(String[] aParams) {
            this.fParams = aParams;
        }

        protected String[] getParams() {
            return this.fParams;
        }

        protected abstract String getOperationName();

        protected abstract void operation(Table var1, String var2) throws ChangeException;

        public void makeChange() {
            if (this.getParams() != null) {
                String[] params = this.getParams();
                Table table = this.getTable();
                int i = 0;
                while (i < params.length) {
                    try {
                        this.operation(table, params[i]);
                        StringBuffer sBuffer = new StringBuffer();
                        sBuffer.append(this.getOperationName());
                        sBuffer.append("( ");
                        sBuffer.append(params[i].toLowerCase());
                        sBuffer.append(" ) ");
                        sBuffer.append(" was Successful.");
                        table.getTableChangeResponse().addChangeResult(sBuffer.toString());
                    }
                    catch (ChangeException e) {
                        table.addChangeResult(e);
                    }
                    ++i;
                }
            }
        }
    }

    public static class TableColumnDelete
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_COLUMN_DELETE;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            try {
                aTable.removeColumn(Integer.parseInt(aParam));
            }
            catch (Exception e) {
                ChangeCommandImpl.throwTableChangeException(e.toString());
            }
        }
    }

    public static class TableRowDelete
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_ROW_DELETE;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            try {
                aTable.removeRow(Integer.parseInt(aParam));
            }
            catch (Exception e) {
                ChangeCommandImpl.throwTableChangeException(e.toString());
            }
        }
    }

    public static class TableSetPage
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_SET_PAGE;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            int oldPage = aTable.getCursor().getCurrentStep();
            String param = aParam.toUpperCase();
            if (fCursorCommandSet.contains(param)) {
                if ("FORWARD".equals(param)) {
                    aTable.cursorStepForward();
                } else if ("BACKWARD".equals(param)) {
                    aTable.cursorStepBackward();
                } else if ("START".equals(param)) {
                    aTable.cursorToStart();
                } else if ("END".equals(param)) {
                    aTable.cursorToEnd();
                }
            } else {
                try {
                    if (param.indexOf(":") != -1) {
                        int seriesTotal;
                        String value = param.substring(param.indexOf(":") + 1, param.length());
                        int pageSize = Integer.parseInt(value);
                        aTable.setCursorPageSize(pageSize);
                        int seriesNumber = aTable.getCursorCurrentPage();
                        int rowsTotal = aTable.getRowCount();
                        int rowsPerPage = aTable.getCursorPageSize();
                        int n = seriesTotal = rowsTotal % rowsPerPage > 0 ? rowsTotal / rowsPerPage + 1 : rowsTotal / rowsPerPage;
                        if (seriesNumber - seriesTotal >= 0) {
                            aTable.cursorGoToPage(0);
                        }
                    } else {
                        aTable.cursorGoToPage(Integer.parseInt(param));
                    }
                }
                catch (Exception e) {
                    ChangeCommandImpl.throwTableChangeException(e.toString());
                }
            }
            aTable.changeRowSelectionByCursor();
        }
    }

    public static class TableSortByColumn
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_SORT_BYCOLUMN;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            try {
                boolean asc = true;
                int column = Integer.parseInt(aParam);
                if (aParam.charAt(0) == '-') {
                    asc = false;
                    column = -column;
                }
                if (aTable.isColumnSortSupported(column)) {
                    aTable.sortData(column, asc);
                } else {
                    ChangeCommandImpl.throwTableChangeException("Column sort not supported.");
                }
            }
            catch (Exception e) {
                ChangeCommandImpl.throwTableChangeException(e.toString());
            }
        }
    }

    public static class TableChangeCellValue
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_VALUE_CHANGE;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            try {
                StringTokenizer sTokenizer = new StringTokenizer(aParam, "^;");
                if (sTokenizer.countTokens() < 3) {
                    ChangeCommandImpl.throwTableChangeException("Wrong count of parametrs.");
                }
                int row = Integer.parseInt(sTokenizer.nextToken());
                int column = Integer.parseInt(sTokenizer.nextToken());
                CellChanger changer = aTable.getCellChanger(row, column);
                changer.updateCellValue(aTable, sTokenizer.nextToken(), row, column);
            }
            catch (Exception e) {
                ChangeCommandImpl.throwTableChangeException(e.toString());
            }
        }
    }

    public static class TableSelectColumn
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_SELECT_COLUMN;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            if (!aTable.isColumnSelectionAllowed()) {
                ChangeCommandImpl.throwTableChangeException("Column selection not allowed.");
            }
            try {
                boolean select = true;
                int column = Integer.parseInt(aParam);
                if (aParam.charAt(0) == '-') {
                    select = false;
                }
                if (select) {
                    aTable.addColumnSelectionInterval(new Interval(column));
                } else {
                    aTable.removeColumnSelectionInterval(new Interval(-column));
                }
            }
            catch (Exception e) {
                ChangeCommandImpl.throwTableChangeException(e.toString());
            }
        }
    }

    public static class TableSelectRow
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_SELECT_ROW;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            if (!aTable.isRowSelectionAllowed()) {
                ChangeCommandImpl.throwTableChangeException("Row selection not allowed.");
            }
            try {
                boolean select = true;
                int row = Integer.parseInt(aParam);
                if (aParam.charAt(0) == '-') {
                    select = false;
                }
                if (select) {
                    aTable.addRowSelectionInterval(new Interval(row));
                } else {
                    aTable.removeRowSelectionInterval(new Interval(-row));
                }
            }
            catch (Exception e) {
                ChangeCommandImpl.throwTableChangeException(e.toString());
            }
        }
    }

    public static class TableChangeColumnSelectionModel
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_SMODEL_COLUMN;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            int code = TagFactory.getSelectionCode(aParam);
            if (code == -1) {
                ChangeCommandImpl.throwTableChangeException("Selection model type not supported.");
            }
            aTable.setColumnSelectionType(code);
        }
    }

    public static class TableChangeRowSelectionModel
    extends AbstractTableChanger {
        protected String getOperationName() {
            return ChangeCommandImpl.OPERATION_SMODEL_ROW;
        }

        protected void operation(Table aTable, String aParam) throws ChangeException {
            int code = TagFactory.getSelectionCode(aParam);
            if (code == -1) {
                ChangeCommandImpl.throwTableChangeException("Selection model type not supported.");
            }
            aTable.setRowSelectionType(code);
        }
    }
}

