
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{             Progress dialog              }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_progr;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, fr_const, QTypes, QExtCtrls;


type
  TfrProgressForm = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    FDoc: Pointer;
    FOnBeforeModal: TNotifyEvent;
    procedure Localize;
  public
    { Public declarations }
    FirstCaption: String;
    property OnBeforeModal: TNotifyEvent read FOnBeforeModal write FOnBeforeModal;
    function Show_Modal(Doc: Pointer): Word;
  end;


implementation

uses fr_utils, fr_class;

{$R *.xfm}

function TfrProgressForm.Show_Modal(Doc: Pointer): Word;
begin
  Localize;
  FDoc := Doc;
  Label2.Caption := '';
  Timer1.Enabled := True;
  Result := ShowModal;
end;

procedure TfrProgressForm.Button1Click(Sender: TObject);
begin
  TfrReport(FDoc).Terminated := True;
  ModalResult := mrCancel;
end;

procedure TfrProgressForm.Localize;
begin
  Font.Name := frDefaultFont;
  Button1.Caption := SCancel;
end;

procedure TfrProgressForm.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled := False;
  if Assigned(FOnBeforeModal) then FOnBeforeModal(Self);
end;

end.

