
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{              Picture editor              }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_gedit;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls,
  QForms, QDialogs, QStdCtrls, QButtons, QExtCtrls, fr_class, fr_const;

type
  TfrGEditorForm = class(TfrObjEditorForm)
    Button1: TButton;
    Button2: TButton;
    Image1: TImage;
    GroupBox1: TGroupBox;
    Button3: TButton;
    Button4: TButton;
    ScrollBox1: TScrollBox;
    PB1: TPaintBox;
    procedure BitBtn1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PB1Paint(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
    function ShowEditor(View: TfrView): TModalResult; override;
  end;


implementation

{$R *.xfm}

uses fr_desgn, QClipBrd, Qt, fr_utils;

function TfrGEditorForm.ShowEditor(View: TfrView): TModalResult;
begin
  Image1.Picture.Assign((View as TfrPictureView).Picture);
  Result := ShowModal;
  if Result = mrOk then
  begin
    frDesigner.BeforeChange;
    (View as TfrPictureView).Picture.Assign(Image1.Picture);
  end;
end;

procedure TfrGEditorForm.BitBtn1Click(Sender: TObject);
var
  OpenDlg: TOpenDialog;
begin
  OpenDlg := TOpenDialog.Create(nil);
{$IFDEF JPEG}
  OpenDlg.Filter := (SPictFile) +
    ' (*.bmp *.jpg *.ico *.wmf *.emf)|*.bmp;*.jpg;*.ico;*.wmf;*.emf|' +
    (SAllFiles) + '|*.*';
{$ELSE}
  OpenDlg.Filter := (SPictFile) +
    ' (*.bmp *.ico *.wmf *.emf)|*.bmp;*.ico;*.wmf;*.emf|' +
    (SAllFiles) + '|*.*';
{$ENDIF}
  if OpenDlg.Execute then
    Image1.Picture.LoadFromFile(OpenDlg.FileName);
  OpenDlg.Free;
  PB1Paint(nil);
end;

procedure TfrGEditorForm.Button4Click(Sender: TObject);
begin
  Image1.Picture.Assign(nil);
  PB1Paint(nil);
end;

procedure TfrGEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53460;
  Button3.Caption := S53462;
  Button4.Caption := S53463;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrGEditorForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

procedure TfrGEditorForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ((Key = key_Insert) and (ssShift in Shift)) or
     ((Chr(Key) = 'V') and (ssCtrl in Shift)) then
    Image1.Picture.Assign(Clipboard);
  PB1Paint(nil);
end;

procedure TfrGEditorForm.PB1Paint(Sender: TObject);
var
  dx, dy: Integer;
begin
  with PB1.Canvas do
  begin
    Brush.Color := clWindow;
    FillRect(Rect(0, 0, PB1.Width, PB1.Height));
    if (Image1.Picture.Graphic = nil) or Image1.Picture.Graphic.Empty then
      TextOut((PB1.Width - TextWidth((SNotAssigned))) div 2, 100, (SNotAssigned))
    else
    begin
      dx := Image1.Picture.Width;
      dy := Image1.Picture.Height;
      if (dx > PB1.Width) or (dy > PB1.Height) then
        StretchDraw(Rect(0, 0, PB1.Width, PB1.Height), Image1.Picture.Graphic) else
        Draw((PB1.Width - dx) div 2, (PB1.Height - dy) div 2, Image1.Picture.Graphic);
    end;
  end;
end;

end.

