
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{         Barcode Add-in object             }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
//  Barcode Component
//  Version 1.3
//  Copyright 1998-99 Andreas Schmidt and friends

//  Freeware

//  for use with Delphi 2/3/4


//  this component is for private use only!
//  i am not responsible for wrong barcodes
//  Code128C not implemented

//  bug-reports, enhancements:
//  mailto:shmia@bizerba.de or
//  a_j_schmidt@rocketmail.com

{  fr_barc:     Guilbaud Olivier            }
{               golivier@worldnet.fr        }
{  Ported to FR2.3: Alexander Tzyganenko    }
{                                           }
{*******************************************}

unit fr_barc;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QMenus, frbarcod, fr_class, QExtCtrls, fr_ctrls, QButtons;

type
  TfrbarcodeObject = class(TComponent)  // fake component
  end;

  TfrbarcodeRec = packed record
    cCheckSum : Boolean;
    cShowText : Boolean;
    cCadr     : Boolean;
    cBarType  : TfrbarcodeType;
    cModul    : Integer;
    cRatio    : Double;
    cAngle    : Double;
  end;

  TfrbarcodeView = class(TfrView)
  private
    BarC: Tfrbarcode;
    procedure BarcodeEditor(Sender: TObject);
  public
    Param: TfrbarcodeRec;
    constructor Create; override;
    destructor Destroy; override;
    procedure LoadFromStream(Stream: TStream); override;
    procedure SaveToStream(Stream: TStream); override;
    procedure SaveToFR3Stream(Stream: TStream); override;
    procedure Draw(Canvas: TCanvas); override;
    procedure StreamOut(Stream: TStream); override;
    procedure DefinePopupMenu(Popup: TPopupMenu); override;
    procedure DefineProperties; override;
    procedure ShowEditor; override;
  end;

  TfrbarcodeForm = class(TForm)
    bCancel: TButton;
    bOk: TButton;
    M1: TfrComboEdit;
    Label1: TLabel;
    cbType: TComboBox;
    Label2: TLabel;
    Image1: TImage;
    GroupBox1: TGroupBox;
    ckCheckSum: TCheckBox;
    ckViewText: TCheckBox;
    GroupBox2: TGroupBox;
    RB1: TRadioButton;
    RB2: TRadioButton;
    RB3: TRadioButton;
    RB4: TRadioButton;
    Label3: TLabel;
    eZoom: TEdit;
    Panel1: TPanel;
    frSpeedButton1: TfrSpeedButton;
    frSpeedButton2: TfrSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure bOkClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ExprBtnClick(Sender: TObject);
    procedure frSpeedButton1Click(Sender: TObject);
    procedure frSpeedButton2Click(Sender: TObject);
  private
    procedure Localize;
  public
  end;


implementation

uses fr_const, fr_utils, fr_dbrel;

{$R *.xfm}
{$R *.res}

const
  cbDefaultText = '12345678';


{$HINTS OFF}
function isNumeric(St: String): Boolean;
var
  R: Double;
  E: Integer;
begin
  Val(St, R, E);
  Result := (E = 0);
end;
{$HINTS ON}

constructor TfrbarcodeView.Create;
begin
  inherited Create;

  BarC := Tfrbarcode.Create(nil);
  Param.cCheckSum := True;
  Param.cShowText := True;
  Param.cCadr     := False;
  Param.cBarType  := bcCode39;
  Param.cModul    := 1;
  Param.cRatio    := 2;
  Param.cAngle    := 0;
  Memo.Add(cbDefaultText);
  BaseName := 'Bar';
end;

destructor TfrbarcodeView.Destroy;
begin
  BarC.Free;
  inherited Destroy;
end;

procedure TfrbarcodeView.DefineProperties;
begin
  inherited DefineProperties;
  AddProperty('Barcode', [frdtHasEditor, frdtOneObject], BarcodeEditor);
  AddProperty('DataField', [frdtOneObject, frdtHasEditor, frdtString], frFieldEditor);
end;

procedure TfrbarcodeView.LoadFromStream(Stream:TStream);
begin
  inherited LoadFromStream(Stream);
  Stream.Read(Param, SizeOf(Param));
  if Param.cModul = 1 then
  begin
      Param.cRatio := Param.cRatio / 2;
      Param.cModul := 2;
  end;
end;

procedure TfrbarcodeView.SaveToStream(Stream:TStream);
begin
  inherited SaveToStream(Stream);
  Stream.Write(Param, SizeOf(Param));
end;

procedure TfrbarcodeView.Draw(Canvas: TCanvas);
var
  Txt: String;
  hg: Integer;
  EMF: TBitmap;
begin
  if (dx < 0) or (dy < 0) then Exit;
  BeginDraw(Canvas);
  Memo1.Assign(Memo);

  if (Memo1.Count > 0) and (Memo1[0][1] <> '[') then
    Txt := Memo1[0] else
    Txt := cbDefaultText;
  Param.cAngle := 0;
  BarC.Angle := Param.cAngle;
  BarC.Ratio := Param.cRatio;
  BarC.Modul := Param.cModul;
  BarC.Checksum := Param.cCheckSum;
  if FillColor = clNone then
    BarC.Color := clWhite else
    BarC.Color := FillColor;
  BarC.Typ := Param.cBarType;
  if bcData[Param.cBarType].Num = False then
    BarC.Text := Txt
  else if IsNumeric(Txt) then
    BarC.Text := Txt else
    BarC.Text := cbDefaultText;
  if (Param.cAngle = 90) or (Param.cAngle = 270) then
    dy := BarC.Width else
    dx := BarC.Width;

  if Trim(BarC.Text) = '0' then Exit;

  if (Param.cAngle = 90) or (Param.cAngle = 270) then
    if Param.cShowText then
      hg := dx - 14 else
      hg := dx
  else if Param.cShowText then
      hg := dy - 14 else
      hg := dy;
  BarC.Left := 0;
  BarC.Top := 0;
  BarC.Height := hg;
  if Param.cAngle = 180 then
    BarC.Top := dy - hg
  else if Param.cAngle = 270 then
    BarC.Left := dx - hg;

  EMF := TBitmap.Create;
  EMF.Width := dx;
  EMF.Height := dy;
  with EMF.Canvas do
  begin
    Brush.Color := FillColor;
    FillRect(Rect(0, 0, dx, dy));
  end;
  BarC.DrawBarcode(EMF.Canvas);
  Txt := BarC.Text;

  if Param.cShowText then
  with EMF.Canvas do
  begin
    Font.Color := clBlack;
    Font.Name := 'Courier New';
    Font.Height := -12;
    Font.Style := [];
    if Param.cAngle = 0 then
      TextOut((dx - TextWidth(Txt)) div 2, dy - 12, Txt)
    else if Param.cAngle = 90 then
      TextOut(dx - 12, dy - (dy - TextWidth(Txt)) div 2, Txt)
    else if Param.cAngle = 180 then
      TextOut(dx - (dx - TextWidth(Txt)) div 2, 12, Txt)
    else
      TextOut(12, (dy - TextWidth(Txt)) div 2, Txt);
  end;

  CalcGaps;
  ShowBackground;
  Canvas.StretchDraw(DRect, EMF);
  EMF.Free;
  ShowFrame;
  RestoreCoord;
end;

procedure TfrbarcodeView.StreamOut(Stream: TStream);
var
  SaveTag: String;
begin
  BeginDraw(Canvas);
  Memo1.Assign(Memo);
  CurReport.InternalOnEnterRect(Memo1, Self);
  frInterpretator.DoScript(Script);
  if not Visible then Exit;

  SaveTag := Tag;
  if (Tag <> '') and (Pos('[', Tag) <> 0) then
    ExpandVariables(Tag);

  if Memo1.Count > 0 then
    if (Length(Memo1[0]) > 0) and (Memo1[0][1] = '[') then
    try
      Memo1[0] := frParser.Calc(Memo1[0]);
    except
      Memo1[0] := '0';
    end;

  Stream.Write(Typ, 1);
  frWriteString(Stream, ClassName);
  SaveToStream(Stream);

  Tag := SaveTag;
end;

procedure TfrbarcodeView.DefinePopupMenu(Popup: TPopupMenu);
begin
  // no specific items in popup menu
end;

procedure TfrbarcodeView.BarcodeEditor(Sender: TObject);
begin
  ShowEditor;
end;

procedure TfrbarcodeView.ShowEditor;
begin
  with TfrbarcodeForm.Create(nil) do
  begin
    if Memo.Count > 0 then
      M1.Text := Memo.Strings[0];
    cbType.ItemIndex   := ord(Param.cBarType);
    ckCheckSum.checked := Param.cCheckSum;
    ckViewText.Checked := Param.cShowText;
    eZoom.Text := IntToStr(Param.cModul);
    if Param.cAngle = 0 then
      RB1.Checked := True
    else if Param.cAngle = 90 then
      RB2.Checked := True
    else if Param.cAngle = 180 then
      RB3.Checked := True
    else
      RB4.Checked := True;
    if ShowModal = mrOk then
    begin
      frDesigner.BeforeChange;
      Memo.Clear;
      Memo.Add(M1.Text);
      Param.cModul := StrToInt(eZoom.Text);
      Param.cCheckSum  := ckCheckSum.Checked;
      Param.cShowText  := ckViewText.Checked;
      Param.cBarType := TfrbarcodeType(cbType.ItemIndex);
      if RB1.Checked then
        Param.cAngle := 0
      else if RB2.Checked then
        Param.cAngle := 90
      else if RB3.Checked then
        Param.cAngle := 180
      else
        Param.cAngle := 270;
    end;
    Free;
  end;
end;


//--------------------------------------------------------------------------
procedure TfrbarcodeForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := (S53650);
  Label1.Caption := (S53651);
  Label2.Caption := (S53652);
  Label3.Caption := (S53659);
  GroupBox1.Caption := (S53653);
  ckCheckSum.Caption := (S53654);
  ckViewText.Caption := (S53655);
  M1.ButtonHint := (S53656);
  GroupBox2.Caption := (S53658);
  bOk.Caption := (SOk);
  bCancel.Caption := (SCancel);
end;

procedure TfrbarcodeForm.FormCreate(Sender: TObject);
var
  i: TfrbarcodeType;
begin
  Localize;
  CbType.Items.Clear;
  for i := bcCode_2_5_interleaved to bcCodeEAN128C do
    cbType.Items.Add(bcData[i].Name);
  cbType.ItemIndex := 0;
end;

procedure TfrbarcodeForm.FormActivate(Sender: TObject);
begin
  M1.SetFocus;
end;

procedure TfrbarcodeForm.ExprBtnClick(Sender: TObject);
var
  s: String;
begin
  s := frDesigner.InsertExpression;
  if s <> '' then
    M1.Text := s;
end;

procedure TfrbarcodeForm.bOkClick(Sender: TObject);
var
  bc: Tfrbarcode;
  Bmp: TBitmap;
begin
  bc := Tfrbarcode.Create(nil);
  bc.Text := M1.Text;
  bc.CheckSum  := ckCheckSum.Checked;
  bc.Typ := TfrbarcodeType(cbType.ItemIndex);
  Bmp := TBitmap.Create;
  Bmp.Width := 16; Bmp.Height := 16;
  if (bc.Text = '') or (bc.Text[1] <> '[') then
    try
      bc.DrawBarcode(Bmp.Canvas);
    except
      Application.MessageBox(SBarcodeError, SError,
        [smbOk], smsCritical);
      ModalResult := 0;
    end;
  Bmp.Free;
end;


var
  Bmp: TBitmap;

procedure TfrbarcodeForm.frSpeedButton1Click(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(eZoom.Text);
  Inc(i);
  eZoom.Text := IntToStr(i);
end;

procedure TfrbarcodeForm.frSpeedButton2Click(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(eZoom.Text);
  Dec(i);
  if i <= 0 then i := 1;
  eZoom.Text := IntToStr(i);
end;

procedure TfrBarCodeView.SaveToFR3Stream(Stream: TStream);
var
  ds: TfrTDataSet;
  fld: String;

  procedure WriteStr(const s: String);
  begin
    Stream.Write(s[1], Length(s));
  end;

begin
  inherited;

  if Memo.Count > 0 then
    WriteStr(' Text="' + StrToXML(Memo[0]) + '"');
  WriteStr(' BarType="' + IntToStr(Integer(Param.cBarType)) +
    '" CalcCheckSum="' + IntToStr(Integer(Param.cCheckSum)) +
    '" Rotation="' + FloatToStr(Param.cAngle) +
    '" ShowText="' + IntToStr(Integer(Param.cShowText)) +
    '" Zoom="' + FloatToStr(Param.cRatio) + '"');

  if Memo.Count <> 0 then
  begin
    frGetDataSetAndField(Memo[0], ds, fld);
    if (ds <> nil) and (fld <> '') then
      WriteStr(' DataSet="' + ds.Owner.Name + '.' + ds.Name +
        '" DataField="' + StrToXML(fld) + '"');
  end;
end;


initialization
  Bmp := TBitmap.Create;
  Bmp.LoadFromResourceName(hInstance, 'fr_barcODEVIEW');
  frRegisterObject(TfrbarcodeView, Bmp, (SInsBarcode));

finalization
  Bmp.Free;


end.
