// Tank Fight v1.00
// written by Ari Asulin
// (protricity@usa.net)
// TankFight.cpp controls all major movement of the game objects and User Input.

#include "draw2.h"    		// Required Graphics Header file.
#include "tankfight.h"		// Main Header File - Controls Graphic Sub Functions.
#include "tfintro.h"       // Title Screen and Introduction Functions.
#include "gfxobj.h"			// Initialization file for all Graphic Objects.
#include "terrain.h"			// Initialization file for Level Terrain.
#include "units.h"			// Controls Explosions, Bullets, SFX Sub Functions.

double 	CurTime;				// Current Time.
int 		SleepTime;			// Milliseconds between revolutions.
int      DifLevel;			// Difficulty Level (1=Easy,2=Medium,3=Hard).
int 		LMousex;				// Last Mouse X Position.
int 		LMousey;				// Last Mouse Y Position.
int 		Rev;					// Current Revolution of Game.
int 		UserMaxBullets;   // Max Number of User Bullets.
int		UserMissiles;		// Current number of User's Missiles.
int 		UserNukes;			// Current number of User's Nukes.
int 		UserScore;			// User's Current Score.
int 		lUserScore;			// User's Last Score.
bool 		Pause;				// Is game Paused?
bool 		UsingMouse;			// Is User using Mouse or Keyboard?
bool 		EnemyAim;			// Are Helicopters aiming?
bool 		NextLevel;			// Go to next level?


////////////////////////////////////////////////////////////////////////////////
void DoUserBar(bool ShowHP,bool ShowScore);
// Defined Lower down.
////////////////////////////////////////////////////////////////////////////////
void SetGameVars()
// Set Critical GameVars.
{
	UsingMouse = true;       // Using Mouse.
	EnemyAim = true;			// Helicopter Aiming.
   UserMaxBullets = 5;     // Max Number of User Bullets.
	UserMissiles = 0;       // Current number of User's Missiles.
   UserNukes = 0;          // Current number of User's Nukes.
   UserScore = 0;          // No Starting Score.
   lUserScore = 0;			// Last Starting Score.
   cKeyPressed = 0;			// No Key's pressed.
	Mouse.rbutton = 0;      // No Mouse Buttons clicked yet.
   Mouse.lbutton = 0;      // No Mouse Buttons clicked yet.
   ShowHitScore = true;		// Set to true.
   ChangeFont(20,20,false,false,false,"Arial");	// Set Font
}

////////////////////////////////////////////////////////////////////////////////
void KeyCallBack(char c)
{
// Not In Use
// Needs to be declaired anyway.
}
////////////////////////////////////////////////////////////////////////////////
void Fire(int bulTyp,int x,int y,double vx, double vy)
// Main Fire function.
//	a Bul[] is selected and initialized according to it's buTyp.
// bulTyp is Type of bullet.
// x,y are the x and y coordinates.
// vx,vy are the horizontal and vertical velocitys
{
	if ((User.dead == false) || (bulTyp == 8))
   												// No bullets are fired if User is dead!
   {
		curbul++;                       	// Select next available Bul[]
   	if (curbul>=BulTotal) curbul=1;  // If next available Bul[] is over limit
		Bul[curbul].x=x;							//	select first Bul[]
   	Bul[curbul].y=y;
		Bul[curbul].bulTyp=bulTyp;       // Initialize options x,y,vx,vy,bulTyp.
   	Bul[curbul].vx=vx;
   	Bul[curbul].vy=vy;
   	Bul[curbul].angle=0;					// Angle of Bullet.
   	Bul[curbul].scale=1;             // Scale - Size of bullet.
   	Bul[curbul].grav=.3;					// Gravity that affects the bullet.
   	Bul[curbul].dmg=5;					// Damage that bullet inflicts.
   	Bul[curbul].grow=0; 					// Amount that bullet shrinks or grows.
   	Bul[curbul].EnTarget=1;				// Amount that bullet shrinks or grows.
      int i;									// Incase of For Loop
      int maxbul;								// Temp variable for case 2
   	switch(bulTyp)							// Case it initialize bullet according to
   	{												// type.
   		case 2:                       // If Bullet was shot by the User
         	maxbul=0;

				for(i = 1;i<=BulTotal;i++) // To check how many bullets are User's
            	if (Bul[i].bulTyp == 2) maxbul++; // and allow no more than Max.
            if (maxbul>UserMaxBullets) Bul[curbul].bulTyp = 0;
   			Bul[curbul].y+=9;          // Add a little height so bullet comes
				Bul[curbul].x+=vx*1.5;       	       // out the Tank's cannon
   			Bul[curbul].y+=vy*1.5;     // Add a little velocity to the bullet.
   			Bul[curbul].dmg=11+random(3)-DifLevel;// Damage bullet inflicts.
     		break;
   		case 3:								// The Bomber's Bomb
   			Bul[curbul].dmg=3+DifLevel;	// Damage that bullet inflicts.
     		break;
			case 4:                       // The Helicopter's Back Propellor
      		Bul[curbul].dmg=3;					// This bullet is shot when
   			Bul[curbul].angle=random(360);		// Helicopter dies.
   			Bul[curbul].scale=.7;
      	break;
      	case 5:                       // The Helicopter's Machine Gun.
      		Bul[curbul].dmg=1;         // Not very strong.
   			Bul[curbul].grav=0;        // No gravity for this bullet.
      	break;
      	case 6:                       // The Helicopter's Main Propellor.
      		Bul[curbul].dmg=5;         	// You don't want to get hit by this!
   			Bul[curbul].grav=.2;          // Falls slower.
   			Bul[curbul].angle=random(360);	// Random starting angle.
   			Bul[curbul].scale=5;
      	break;
      	case 7:
         	Bul[curbul].dmg=4+DifLevel*2; // Interceptor's Missiles.
   			Bul[curbul].grav=0;        	// Doesn't fall.
   			Bul[curbul].scale=.4;      	// Starts small.
      	break;
      	case 8:                       // User's Gun Flying off when Dead
         	Bul[curbul].dmg=7;				// Could hurt!
   			Bul[curbul].grav=.2;          // Falls slowly
      	break;
      	case 9:
         	Bul[curbul].dmg=12;        // Hurts!
   			Bul[curbul].y+=9;          // Add a little height so missile comes
				Bul[curbul].x+=vx*1.5;       	// out the Tank's cannon
   			Bul[curbul].y+=vy*1.5;     // Add a little velocity to the bullet.
   			Bul[curbul].grav=.1;       // Barely falls.

            if ((En[curEn].objTyp == 2) || (En[curEn].objTyp == 3))
               Bul[curbul].EnTarget = curEn;
            				// If current enemy is a plane or helicopter, target it!
            UserMissiles--;            // User wasted a Missile.
            DoUserBar(true,true);  		// Refresh Info to show loss of missile.
      	break;
      	case 10:                      // A NUKE!!!
         	Bul[curbul].dmg=30;        // Hurts !!
   			Bul[curbul].y+=9;          // Add a little height.
   			Bul[curbul].grav=0;        // No Gravity.
            UserNukes--;               // User lost a Nuke.
            DoUserBar(true,true);		// Refresh Info to show loss of a Nuke.
      	break;
         default:                      // Default Case is not in use.

   		break;
   	}											// End of Switch
   }  									 	// End of If
}

////////////////////////////////////////////////////////////////////////////////
void DrawAllObjs()
// This function is called in the main loop.
// All Object and the terrain are drawn.
{
	//if (random(20)>20) 			// DrawLevel is drawn in 1 out of every 19 loops
   //DrawLevel(true,false,0,65); 	// to make the game run faster.
	DrawAllGFXObjs(); // Draw all the objects

}
////////////////////////////////////////////////////////////////////////////////
void DoUserBar(bool ShowHP, bool ShowScore)
// The User Health Bar is drawn here.
// First the space is cleared with a black Rect() command.
// Then a bar is drawn with a size and color that reflects User's current HP.
// Then the HP amount is displayed in a similar color.
// Also being drawn, Ammo and Score.
// HP = Hit Points.
// if full is true then everything is refreshed.
{
   if (User.dead == true){                   // If User is dead,
		SetFillColorRGB(BGCol);                // Set Fill color to black in order
		Rect(0,40,640,60,BGCol);  						// to clear area.
   }

   if (User.hp<0) User.hp = 0;               // Let's not go negitive now!

  	char str[10];                        // temp var holds # converted to string.
  	if ((User.lhp != User.hp) || (User.lsp != User.sp) || (ShowHP)) {
 			// Draw if User HP is > 0 or UserScore is not correct;

		SetFillColorRGB(BGCol);                // Set Fill color to black in order
		Rect(40,40,640,60,BGCol);  					// to clear area.

   	if (User.lhp < User.hp) User.lhp+=.5;	// If the displayed User HP is too
   	if (User.lhp > User.hp) User.lhp-=.5;		// too high or too low...

  		if (User.lsp < User.sp) User.lsp+=.25;	// If the displayed User SP is too
   	if (User.lsp > User.sp) User.lsp-=.25;		// too high or too low...

      SetFillColorRGB(BGCol);                // Set Fill color to black in order
		Rect(40,40,290,60,WHITE);  					// to clear area and display HP.
		Rect(350,40,475,60,WHITE);  					// to clear area and display SP.

      Text(15,60,"HP",RGB(256-User.lhp*5,0,User.lhp*5));			  // Display "HP"
   	SetFillColor(256-User.lhp*5,256-abs(10*User.lhp-256),User.lhp*5);
      // This command changes the Rectangle color according to User HP.

		Rect(41,41,41+User.lhp*5,59,WHITE);	 // Size of this Rect Shows HP.

   	itoa(User.lhp, str, 10);             // HP is converted here.
   	Text(160,60,str,RGB(255,abs(10*User.lhp-255),255));
      // This last command displays the text with a color that reflects User HP.

      Text(320,60,"SP",RGB(0,256-User.lsp*5,User.lsp*5));			  // Display "SP"
   	SetFillColor(0,0,255);
      // This command changes the Rectangle color according to User SP.

		Rect(351,41,351+User.lsp*5,59,WHITE);	 // Size of this Rect Shows SP.

   	itoa(User.lsp, str, 10);             // SP is converted here.
   	Text(410,60,str,RGB(255,abs(20*User.lsp-255),255));
      // This last command displays the text with a color that reflects User SP.

      // Weapons
      SetFillColorRGB(BGCol);             // Set color to Black
      Rect(160,90,450,70,BGCol);  	  		// to clear area and display Weapons.

      if (UserMissiles > 0){
   		itoa(UserMissiles, str, 10);     // Missile # is converted here.
      	Text(180,90,"Missiles:",RGB(255-UserMissiles*25,UserMissiles*25,UserMissiles*25));
      	Text(250,90,str,RGB(255-UserMissiles*25,UserMissiles*25,UserMissiles*25));
      	// This displays "Missiles:" and the number of missiles left.
         // Color changes according to the number of missiles left.
		}

      if (UserNukes > 0){
   		itoa(UserNukes, str, 10);     	// Nuke # is converted here.
      	Text(350,90,"Nukes:",RGB(255-UserNukes*85,UserNukes*85,UserNukes*85));
      	Text(410,90,str,RGB(255-UserNukes*85,UserNukes*85,UserNukes*85));
      	// This displays "Nukes:" and the number of Nukes left.
         // Color changes according to the number of Nukes left.
		}
   }
   if ((lUserScore != UserScore) || (ShowScore)){	// If UserScore is inacurate,

      if (lUserScore < UserScore) lUserScore+=25;  // Raise or Lower Score by 25
      if (lUserScore > UserScore) lUserScore-=25;  // in order to correct.

      SetFillColorRGB(BGCol);             // Set color to Black
      Rect(40,90,150,70,BGCol);  	  		// to clear area and display Score.
   	itoa(lUserScore, str, 10);      		// Score is converted here.
      Text(40,90,"Score:",WHITE);
      Text(100,90,str,WHITE);
      	// This displays "Score:" and the current Score.

   }
}
////////////////////////////////////////////////////////////////////////////////
void DoUserTank()
// This Function Controls all aspects of the User Tank.
{
   if (abs(User.vx) >5) User.vx = User.vx/1.3; 	// if velocity is to high,
																	// lower it.
   User.lx=User.x;                         	// Remember Last User X Position.
   User.ly=User.y;                           // Remember Last User Y Position.
   User.langle=User.angle;                   // Remember Last User Angle.
   User.lscale=User.scale;                   // Remember Last User Scale.
   if (User.x<12) {           					// If User is too far left.
   	User.x=12;              						// Go back
   	User.vx=0;              						// Velocity stops
   }
   if (User.x>624){           					// If User is too far Right.
   	User.x=624;              						// Go back
   	User.vx=0;              						// Velocity stops
   }
  	User.x+=User.vx;                          // X Velocity is added to User's
   															// X Position to create movement
   for(int i=1;i<4;i++){                     // Loop
   	if (User.y<LvlHgt(User.x)+8) User.y++; 	// If User is too
   	if (User.y>LvlHgt(User.x)+8) User.y--;    // low or too high
   }                                         // This loop makes height accurate.

   if (User.y==LvlHgt(User.x)+8) {   // Is User touching ground??

      int Hgt = LvlHgt(User.x)-LvlHgt(User.x+10);
      	// Lvlhgt is the the height difference of the terrain.

   	for(int i=1;i<5;i++){         			// Loop if User is on Ground.
   		if (User.angle > atan(Hgt/10.)/DEG) User.angle-=2;	// Compares slope
   		if (User.angle < atan(Hgt/10.)/DEG) User.angle+=2; // and Tank angle
      	// The inverse tangent of Lvlhgt is taken to find the angle of the
         // terrain at the current location and compare it to the User's angle.
         // This makes the tank rotate according the the terrain slope.
   	}
   }

   // Gun stuff
   if (User.Gwait>0)User.Gwait--; // decrease the wait until user can fire again

   if (User.Gangle>360) User.Gangle=360;	// This makes sure the gun's angle
   if (User.Gangle<180) User.Gangle=180;  // isn't < 180 degrees or > 360.

	DrawLevel(true,false,User.x/10-2,User.x/10+4);	// Redraw part of the terrain
															      // Under the tank.
   // Enemy Bullets
   for(int ii=1;ii<BulTotal;ii++) 	// Loop that covers all Bullets
   {
   	if ((Bul[ii].bulTyp > 2) && (Bul[ii].bulTyp < 9))
       	// If bulTyp is not debree or User's gun.
   	{
   		int x,y,d;               	// Temp variables to make things clearer.
   		x = User.x-Bul[ii].x;    	// X Distance between bullet and User.
   		y = User.y-Bul[ii].y;    	// Y Distance between bullet and User.
   		d = sqrt(x*x + y*y/2);   	// Uses (A^2 + B^2 = C^2) to find distance
         										// between bullet and User.
         if (Bul[ii].bulTyp == 7 && Bul[ii].scale<2.4) d=3000;
         									// To make sure that a Missile collision is
                                    	// close to the tank.
   		if (d<=19*User.scale)    	// If the distance is less than the size of
      	{                        		// the Tank then there was a collision!
         	int dmg = Bul[ii].dmg;  // temp var to simplify things.
            if (User.sp>0){            // If User Shields are still working,
         		User.sp -= dmg; 			// User SP is dropped by the Bullets' dmg.
         		Explode(User.x,User.y+5,0,0,30+dmg*2,25+dmg,4);
               if (Bul[ii].bulTyp == 5){
               	Bul[ii].vx*=-random(10)/4-2;
                  Bul[ii].vy*=-random(10)/8-1;
                  Bul[ii].grav =.3;
						Explode(Bul[ii].x,Bul[ii].y,0,0,6,6,1);
               }
               else{
               	Bul[ii].bulTyp=0;   		// bulTyp = 0 means the bullet is dead.
         			Explode(Bul[ii].x,Bul[ii].y,Bul[ii].vx/1.5,-1,4+dmg*2,4+dmg,1);
               }
               if (User.sp < 0) {      // If Shields dropped,
               	User.hp += User.sp;  	// User HP takes the damage
                  User.sp = 0;            // Make Sure Shields are gone.
         			Explode(Bul[ii].x,Bul[ii].y,Bul[ii].vx/1.5,-1,4+dmg*2+random(dmg),4+dmg+random(dmg),1);
               }
            }
            else                       // If Shields are down,
            {
         		User.hp -= dmg; 			// User HP is dropped by the Bullets' dmg.
               Bul[ii].bulTyp=0;       // bulTyp = 0 means the bullet is dead.
         		Explode(Bul[ii].x,Bul[ii].y,Bul[ii].vx/1.5,-1,4+dmg*5+random(dmg*2),4+dmg*3+random(dmg),1);
            	// This function makes an explosion at the Bullet's coordinates
            	// Explosion size reflects the dmg of the bullet.
            }
         	if ((User.hp <= 0) && (User.dead == false)) {  //If User is dead,
            	User.dead = true; 	// Set User to dead.
               User.vx=0;           // Stop movement
   				User.smoke = 100;    // Start User Smoke and final death.
             }
      	}         				  	// End If Collision
   	}                      	// End If bulTyp
   }								// End For Loop

   if (random(225) > User.hp+200) Explode(User.x,User.y,random(5)-2,random(30)/10+5,1,1,2);
                          	// Make Tank Smoke if HP is too low.

   if ((User.dead == true) && (User.smoke >= 0)){
   // User's Final Death
   // User.smoke decreases and Explosions occur until User.smoke is 0.
   // Then, one final explosion ends the game.
   	User.smoke--;	// decrement smoke value

   	if (random(11) > 9) Explode(User.x,User.y,random(5)-2,random(30)/10+3,1,1,2);
			// randomly smoke around User.

      if (User.smoke == 99) // This occurs at the beginning of the death.
      {		// If User is dead, make a really big explosion.
      	Explode(User.x,User.y,0,0,40+random(10),25+random(7),1);
				// Make Gun Fly off also
      	Fire(8,User.x,User.y+30,(random(5)-2.5)*2,random(5)+4);
      }

      if (random(User.smoke)<10) // This cause the chance of Debree to greaten as User.smoke decreases.
      	Debris(User.x-15+random(30),User.y-15+random(30),(random(200)/40.)-2.5,((random(40)+70)/20.),0);
      		// Make some debree around the tank.

      if (User.smoke == 1) // This occurs right before User.smoke is 0.
      {  // Final Explosion and death
      	User.objTyp = 0;	// User is not in use anymore.
         cKeyPressed = 0;
      	Explode(User.x,User.y,0,0,120+random(25),105+random(15),1);
         	// Big explostion
         for(int i=1;i<60;i++)
         	Debris(User.x-15+random(30),User.y-15+random(30),(random(1600)/40.)-20.,((random(2200)+700)/200.),0);
         	// Create a lot of Debree to fly out of Tank.
      }
      if (random(4) > 2) Explode(User.x + random(40) - 20,User.y + random(40) - 20,0,0,16,16,1);
   		// Explode around the tank
   }// End Final Death If
   if (User.objTyp == 0){   	// If User is dead,
   	Text(280,150,"Press Any Key",RGB(random(50)+100,random(50)+100,random(50)+100));
      if(cKeyPressed != 0) NextLevel=true;
      // wait for user to press a key.
   }

}// End function
////////////////////////////////////////////////////////////////////////////////
void DoEnemy()
// This Function Controls all aspects of the enemies.
// First, this Function checks for any bullet-object collsions.
// Second, this Function deals with Object Movement depending on type of objTyp.
{
   for(int i=1;i<EnTotal;i++)  		// This loop covers all available En[]s.
   {
      if (En[i].objTyp>0){          // if objTyp is not 0 (dead or not in use).
      	En[i].lx=En[i].x;          // Remember Last X Position.
      	En[i].ly=En[i].y;          // Remember Last Y Position.
      	En[i].langle=En[i].angle;  // Remember Last Angle.
      	En[i].lscale=En[i].scale;  // Remember Last Scale.
         En[i].x+=En[i].vx;         // Adds X and Y velocity to the X and Y
         En[i].y+=En[i].vy;         	// positions respectively.
         int d,x,y;                 // Temp vars to make things clearer.

         // for loop to see if Enemy was hit by a bullet.
         for(int ii=1;ii<BulTotal;ii++) // This loop covers all the bullets.
         {
            if ((Bul[ii].bulTyp == 2) || (Bul[ii].bulTyp == 4) || (Bul[ii].bulTyp == 6) || (Bul[ii].bulTyp == 9))
            // Are the bullets of the right type? (Bullets that can hurt)
            {
            	x = En[i].x-Bul[ii].x;	// X Distance Apart
            	y = En[i].y-Bul[ii].y;  // Y Distance Apart
         		d = sqrt(x*x + y*y/2);  // Total dist apart (Pythagorean Thm.)

               if (En[i].objTyp == 4) {	// If object type is 4 (Interceptor)
               	if ((En[i].scale<1) || (En[i].scale>2.4)) d = 9000;
                  // This ensures the Interceptor can only be hit at a certain
                  	// distance.
               }
            	if (d<=9*En[i].scale)// If the distance is less than the size of
      			{                    	// the Object then there was a collision!

                  if ((En[i].dead==true) || (Bul[ii].bulTyp == 9)) {
                  			// if the Object is dead, or Bullet is a missile,

                  	if (En[i].objTyp != 3) En[i].objTyp=0;
                     			// if Object is not a helicopter, Make objTyp = 0

                  	if (Bul[ii].bulTyp == 2) {
                     	UserScore+=100;
                     	Message(En[i].x,En[i].y,"100",2);
                     }        // 100 if Plane is shot after dead.


                  	Explode(En[i].x,En[i].y,En[i].vx/4,0,25+random(10),25,1);
                     			// Make an explosion at Enemy coordinants.
                  }	// End If

                  // Now Score goes up accouding to type of plane and bullet.

                  En[i].hp -= Bul[ii].dmg;   // Enemy HP drops by Damage value.

                  if ((Bul[ii].bulTyp == 2) && (!En[i].dead)) { //Bullet Shot.
                     if ((En[i].objTyp == 3) && (En[i].hp>0)) {
                     	UserScore+=100;      // 100 points if Shot didnt kill
                  		Message(En[i].x,En[i].y,"100",2);
                     }
                     else
                     {
                        if (En[i].objTyp == 4){
                  			UserScore+=400;      // 200 More if it is an Interceptor (Harder to hit)
                  			Message(En[i].x,En[i].y,"400",2);
                        }
                        else
                        {
                  			UserScore+=200;      // 200 points if Shot did kill
                  			Message(En[i].x,En[i].y,"200",2);
                     	}
                  	}
                  }



                  if ((Bul[ii].bulTyp == 9) && (!En[i].dead)) {
                  	UserScore+=150;      // 150 points for Missile Shot.
                  	Message(En[i].x,En[i].y,"150",2);
                  }

                  if (En[i].hp <= 0) En[i].dead=true;	// Check if En is dead.
                  else En[i].angle-=18;               // If not, bump him!

                  if (random(2)) En[i].angle-=18;		// Bump him anyway.

                  // (When angle is lessened object appears to be bumped)

                  Explode(Bul[ii].x,Bul[ii].y,Bul[ii].vx,0,Bul[ii].dmg,Bul[ii].dmg,1);
                  	// Explode at bullet coordinants.

                  Explode(En[i].x,En[i].y,En[i].vx,3,1,1,2);
                  	// Make a cloud (on last value, 1 = explosion, 2 = cloud)

                  Explode(En[i].x,En[i].y,En[i].vx,En[i].vy,45+random(10),35+random(7),1);
                  	// Explode at Enemy coordinants.

                  int gr = 0;                // Debris Growth set to zero.

                  if (En[i].objTyp == 4) gr = 1;
                  	// If object is an interceptor, Growth is set to 1.
                     // Growing Debree gives the effect of Debree coming closer.

                  if ((En[i].dead == true) && (random(8)>6) && (gr == 0)) En[i].objTyp = 0;
                  	// Random chance that enemy is killed on collision.

                  for(int iii =1;iii<8;iii++){	// For loop for Debris.
                     Debris(En[i].x-4+random(9),En[i].y-4+random(9),En[i].vx*(random(30)/20.)+random(30)/20.,((random(80)-40)/20.),gr);
 																// Make lots o Debris.
                  	if (En[i].dead==true) Debris(En[i].x-4+random(9),En[i].y-4+random(9),En[i].vx*(random(30)/20.),((random(80)-40)/20.),gr);
                  }                            	// If Enemy is dead make more!

                  Bul[ii].bulTyp=0;             // Bullet is set to inactive.

            	}	// End If Collision.
            }	// End If Bullet Type.
         }  // End For Loop for all bullets.

         // This is still inside the En[i] (Enemy) Loop

         int dir = abs(En[i].vx)/En[i].vx;      // Find the enemy's direction.
            												// 1 or -1.

       	switch(En[i].objTyp)
         // Switch statement controls object action depending on it's type.
      	{
            case 2:	// If object is a Bomber
               if (int(En[i].vy)==1) {   	// If vert velocity is greater than 1,

                  Explode(En[i].x-En[i].vx*3,En[i].y-En[i].vy*3,-En[i].vx/2,-En[i].vy/2,18,16,1);
               	En[i].vx+=abs(En[i].vx)/En[i].vx;
                  // Make engine ignite and horizontal velocity increase.
               }

               if (En[i].x<-60) En[i].objTyp=0; 	// If Plane goes off screen.
            	if (En[i].x>700) En[i].objTyp=0;

               if (En[i].dead) En[i].vy-=.4; else En[i].vy+=.1;
               	// If Plane is dead, fall. Otherwise, rise.

               if (En[i].y < LvlHgt(En[i].x)){
               // If Plane is lower than the ground level,
               	En[i].objTyp=0; 						// Plane set to inactive

               	Explode(En[i].x,En[i].y,En[i].vx,3,1,1,2);	// Smoke

                  Explode(En[i].x,En[i].y,En[i].vx/4,0,35+random(10),35,1);
                  														// Explosions

                  Explode(En[i].x-En[i].vx*2,En[i].y-En[i].vy*2,En[i].vx/4,0,25+random(10),25,1);
                  														// More Explosions

                  for(int iii =1;iii<10;iii++){		// Debree Loop
                  	Debris(En[i].x-4+random(9),LvlHgt(En[i].x)+3,En[i].vx*(random(60)/20.),(double(random(140)+40)/20.),0);
                     DropGround(En[i].x/10+random(4)-2,1);
                     	// Lower Ground level and create flying debree.
                  }
               } // End If Hit Ground

               if (En[i].vy>5) En[i].vy=5; // Don't go faster than 5.

               if (En[i].angle < atan(-En[i].vy/En[i].vx)/DEG) En[i].angle+=2;
               if (En[i].angle > atan(-En[i].vy/En[i].vx)/DEG) En[i].angle-=2;
            		// Inverse tangent is used to set En[i].angle to the
                  // apropriate angle according to velocity.

               if (En[i].smoke <1){		// If it is time to smoke,
               	En[i].smoke=20;   		// Reset the Smoke Timer
               	if (En[i].dead) Explode(En[i].x,En[i].y,-En[i].vx,-En[i].vy,1,1,2);
               	else Explode(En[i].x-En[i].vx*3,En[i].y-En[i].vy*3,-En[i].vx/2,-En[i].vy/2,10,10,1);
               	// If Plane is dead Smoke. Otherwise, make engine fire.
               }

               if (En[i].dead){			// If Plane is dead.
               	En[i].smoke-=10;     	// Make Smoke Timer run faster.
                  if (En[i].PlaneSpin == true){		// If PlaneSpin is on,
                  	En[i].lGfx = En[i].Gfx;       	// Switch Graphics over to
               		En[i].Gfx++;                     // the Plane's second GFX
                     if (En[i].Gfx>2) En[i].Gfx=1;    // and back to show spin.
               	}
               }
               else En[i].smoke-=3;		// Otherwise, smoke timer counts down.

               if (int(En[i].vy)==1) En[i].smoke+=5; // Stop smoke while Plane
																			// is boosting.
               // When to Fire
               if (!En[i].dead && En[i].Gwait<1 && int(En[i].vy)<1){
               // If Plane isn't dead, Gun wait Timer is reset, and Plane is
               // Diving,
               	Fire(3,En[i].x,En[i].y,En[i].vx,En[i].vy);
                  	// Fire a Bomb.
                  En[i].Gwait=random(24)+6-DifLevel*2;
               		// Wait for a random while until a second dropping.
               }
               En[i].Gwait--;	// Gun wait Timer is counting down.
            break;

            case 3:	// If Object is a Helicopter

               if (En[i].x<-40) En[i].objTyp=0; 	// If Heli goes off screen.
            	if (En[i].x>680) En[i].objTyp=0;

               En[i].lGfx = En[i].Gfx;             // switch Gfx to second GFX
               En[i].Gfx++;								// and back to show rotating
               if (En[i].Gfx>2) En[i].Gfx=1;       // propellors.

               if (En[i].dead==true) {             // If Heli is dead,
                  En[i].objTyp=0;                  	// Set to inactive

               	Explode(En[i].x,En[i].y,En[i].vx+2,3,1.2,1,2);	// Smoke
                  Explode(En[i].x-En[i].vx,En[i].y-En[i].vy,En[i].vx/4,0,35+random(10),35,1);
                                                                  // Explosion

                  if (random(2) == 1) Fire(4,En[i].x,En[i].y,En[i].vx*.7,2);
                  if (random(2) == 1) Fire(6,En[i].x,En[i].y,En[i].vx*1.2,2);
                  	// Randomly fires off a main and tail propellor.
                  }

               if (En[i].angle < atan(-En[i].vy/En[i].vx)/DEG+En[i].vx) En[i].angle+=2;
               if (En[i].angle > atan(-En[i].vy/En[i].vx)/DEG+En[i].vx) En[i].angle-=2;
               	// Inverse tangent is used to set En[i].angle to the
                  // apropriate angle according to velocity.

               // Movement
               if (random(8)>5){	// Randomly,
               	if ((En[i].x>80) && (En[i].x<120) && (dir == 1)) En[i].vx=3;
                  	// Slow down if X Position is >80 and <120 and going right.
               	if ((En[i].x>480) && (En[i].x<520) && (dir == -1)) En[i].vx=-3;
                  	// Slow down if X Position is >480 and <520 and going left.

                  if ((En[i].x>180) && (En[i].x<220) && (dir == 1)) En[i].vx=5+random(3);
                  	// Speed up if X Position is >180 and <220 and going right.
               	if ((En[i].x>380) && (En[i].x<420) && (dir == -1)) En[i].vx=-5-random(3);
                  	// Speed up if X Position is >380 and <420 and going left.
               	}
               // When to Fire
               if (!En[i].dead && En[i].Gwait<1){
               	// Fire if Heli isn't dead and Gun Wait Timer is reset

                  int d = sqrt((En[i].x-User.x)*(En[i].x-User.x)+(En[i].y-User.y)*(En[i].y-User.y))/10;
                  	// d is distance found using the Pythagorean theroem.

                  int UX = User.x;	// To simplify calculations.
                  if (EnemyAim) UX += User.vx*d;	// If Aim is on, Heli aims
                  											// ahead of Tank.
                  if (UX>630) UX = 630;            // If Aim is offscreen,
                  if (UX<10) UX = 10;              // Aim is adjusted.

                  int UY = LvlHgt(UX); // UY is Height at location.

                  if ((En[i].x<UX-30) && (dir>0)) Fire(5,En[i].x,En[i].y,(En[i].x-UX)/(-d),(En[i].y-UY)/(-d));
                  if ((En[i].x>UX+30) && (dir<0)) Fire(5,En[i].x,En[i].y,(En[i].x-UX)/(-d),(En[i].y-UY)/(-d));
                  	// This checks if Heli is facing tank. If so, it fires.

                  En[i].Gwait=7-DifLevel+random(2)*(4-DifLevel)*5;
                  	// Gun Wait Timer is reset.
               }
               En[i].Gwait--;              	// Gun Wait Timer is decremented.

            break;

				case 4:  // If Object is an Interceptor.
            	if (En[i].x <= -200)  En[i].objTyp = 0; // If Offscreen.

               if (En[i].scale>=.6) {              // If Scale is .6
               	if (En[i].Gfx == 2) En[i].lGfx=2;	// Set Last Gfx var
               	En[i].Gfx=2;                    	// GFX var is 2.
               }

               if (En[i].smoke <1){              	// If Smoke Timer is 0
               	En[i].smoke=4;                   	// reset timer
                  Explode(En[i].x,En[i].y,-En[i].vx/2,-En[i].vy/2,En[i].scale*2,En[i].scale*2,1);
                  												// Make Engine Fire.
               }

               En[i].smoke--;                      // Decrement Smoke Timer

            	if (En[i].scale<1) En[i].scale*=1.05; // If Scale is <1, Grow.
               else {            		// Otherwise,

               	En[i].scale*=1.15;   	// Grow, but faster.
            		En[i].vy+=.4;           // vertical velocity increases.

                  if (En[i].vx == 0) En[i].vx=1; // if horizontal velocity is 0
                  											// Make it 1. (Error Checkin)
            		En[i].vx+=abs(En[i].vx)/En[i].vx;	// horizontal velocity++.

                  En[i].angle=En[i].vx*3;					// Angle matches velocity.
               }

               if (En[i].dead == true) En[i].angle+=En[i].vx*10+En[i].vy*3;
               	// If dead, spin by adding to angle.

					if	(En[i].scale>=24) En[i].x = -2000;
                  // If Interceptor is too big, make it go off screen, inactive.

            	// When to Fire
               if ((En[i].Gwait<1) && (En[i].scale>.7) && (En[i].scale<2)) {
               // If Gun Timer is 0, and scale is >.7 and <2,

                  int dir = abs(En[i].vx)/(En[i].vx);	// Find direction.

               	if (random(3) >= 1) Fire(7,En[i].x+10*dir,En[i].y,dir,0);
               	if (random(3) >= 1) Fire(7,En[i].x-10*dir,En[i].y,-dir,0);
                  	// This randomly Fires an Intercepting Missile from sides.
                  En[i].Gwait=2500;	// Gun wait Timer set so high that
               } 							// Interceptor will not fire any more.

               En[i].Gwait--;       // Decrement Gun wait Timer (Error checking)
            break;

       	   default:
            	// Default case not in use. (I Hope:)
            break;
         }	// End Switch()
      }  // End If Object is active.
   }  // End En[i] loop (Big Loop!!!)
}  // End Function
////////////////////////////////////////////////////////////////////////////////
void KeyCheck()
// This Function checks if User has pressed a key and deals with it accordingly.
{
   //Gun stuff before KeyCheck
   User.lGangle=User.Gangle;						// Remember Last Gun Angle.
   if(NukeLeft > 0) User.Gwait=3;           	// If Nuke is still going, wait.
	if (cKeyPressed)                          // If a key has been pressed,
   {
      switch (cKeyPressed)                   // switch for the key pressed.
      {
      	case 'q':                           // if keypressed is q,
         	if (User.dead == false) User.vx-=2;	// Increase negative velocity.
         break;
     		case 'w':
         	if (User.dead == false) User.vx=0;  // Stop velocity.(breaks)
         break;
      	case 'e':
         	if (User.dead == false) User.vx+=2; // Increase positive velocity.
         break;
       	case 'j':
         	UsingMouse = false;                 // Mouse is turned off.
				if (User.dead == false) User.Gangle-=10;	// Gun angle decreases.
         break;
     		case 'k':
            if ((User.Gwait==0) && (User.dead == false)) // If GunWait is reset.
            {
            	int vx=17.*cos(double(User.Gangle+User.angle)*DEG)+User.vx*.5;
               	// cosine of angle gives horizontal velocity.
               int vy=-17.*sin(double(User.Gangle+User.angle)*DEG);
               	// sine of angle gives vertical velocity.
               Fire(2,User.x,User.y,vx,vy); 	// Fire a User bullet using vx,vy.
            	User.Gwait=8;					  	// Set GunWait to 8 revolutions.
            }
         break;
         case 'm':
            if ((User.Gwait==0) && (User.dead == false)  && (UserMissiles >0))
            {  // If GunWait is reset ang User has some missiles,
            	int vx=10.*cos(double(User.Gangle+User.angle)*DEG)+User.vx;
               	// cosine of angle gives horizontal velocity.
               int vy=-10.*sin(double(User.Gangle+User.angle)*DEG);
               	// sine of angle gives vertical velocity.
         		Fire(9,User.x,User.y,vx,vy); 	// Fire a Missile using vx,vy.
            	User.Gwait=8;                	// Set GunWait to 8 revolutions.
            }
         break;
         case 'n':
            if ((User.Gwait==0) && (User.dead == false)  && (UserNukes >0))
            {  // If GunWait is reset ang User has some Nukes,
            	int vx=8.*cos(double(User.Gangle+User.angle)*DEG)+User.vx;
               	// cosine of angle gives horizontal velocity.
               int vy=-8.*sin(double(User.Gangle+User.angle)*DEG);
               	// sine of angle gives vertical velocity.
         		Fire(10,User.x,User.y,vx,vy);	// Fire a Nuke using vx,vy.
            	User.Gwait=40;                // Set GunWait to 40 revolutions.
            }
         break;
      	case 'l':
            UsingMouse = false;               	// Mouse is turned off.
            if (User.dead == false) User.Gangle+=10;	// Gun angle increases.
         break;
         case 32:
         	if (User.dead == false) Pause = true;     // Pause the game.
         break;
         default:                                     // Error checking.
         break;
      }
      if (User.dead == false) cKeyPressed=0;                                  // Set key pressed to 0.

   }
}
////////////////////////////////////////////////////////////////////////////////
void MouseCheck()
// This function checks for mouse movement and clicks.
{
   if (Mouse.mousemove != 0) UsingMouse = true; 	// If mouse moved, use mouse.
	if (Mouse.xpos > 10){                      	// If MouseX is greater than 10,
   	LMousex = Mouse.xpos;
   	LMousey = 480-Mouse.ypos;                 // Last Mouse pos = current pos.
   }

   if (Mouse.lbutton == 1){                     // if left-click,
      UsingMouse = true;                        // If mouse moved, use mouse.
   	if (User.Gwait<=0)                        	// if Gunwait is reset,
      {
      	int vx=17.*cos(double(User.Gangle+User.angle)*DEG)+User.vx*.5;
         	// cosine of angle gives horizontal velocity.
         int vy=-17.*sin(double(User.Gangle+User.angle)*DEG);
         	// sine of angle gives vertical velocity.
         Fire(2,User.x,User.y,vx,vy);   	// Fire a User bullet using vx,vy.
         User.Gwait=8;           			// Set Gunwait to 8 revolutions.
      }
   }
   if (Mouse.rbutton == 1){                     // if right-click,
      UsingMouse = true;                        // If mouse moved, use mouse.
   	if ((User.Gwait<=0) && (UserMissiles >0)) // if Gunwait is reset and User
      {                                         // has some missiles,
      	int vx=10.*cos(double(User.Gangle+User.angle)*DEG)+User.vx;
         	// cosine of angle gives horizontal velocity.
         int vy=-10.*sin(double(User.Gangle+User.angle)*DEG);
         	// sine of angle gives vertical velocity.
         Fire(9,User.x,User.y,vx,vy);     // Fire a Missile using vx,vy.
         User.Gwait=8;                    // Set Gunwait to 8 revolutions.
      }
   }
   if ((UsingMouse == true) && (LMousey > User.y)){ // If Mouse is active,
      for(int i=0;i<12;i++){                        // 12 loop
      	if	(User.Gangle < -User.angle + 270 + (atan((LMousex-User.x)/(LMousey-User.y))/DEG)) User.Gangle+=1;
      	if	(User.Gangle > -User.angle + 270 + (atan((LMousex-User.x)/(LMousey-User.y))/DEG)) User.Gangle-=1;
         // Taking the inverse tangent of the slope connecting the mouse
         // coordinants and the User tank coordinants results in the Angle.
         // If Angle is less then the current gun angle then it is increased,
         // otherwise it's decreased.
		}
   }
}
////////////////////////////////////////////////////////////////////////////////
void CalcAllObjs()
// Calculates all object positions and activity.
// Later DrawAllObjs draws the objects in their current positions.
{
 	KeyCheck();										// Calls KeyCheck function.
   if (User.dead == false) MouseCheck();	// Calls MouseCheck function if User
   													// is active.
   DoUserTank();                          // Calls DoUserTank function.
   DoUserBar(false,false);                // Redraws UserBar if necissary.
   DoEnemy();                             // Calls DoEnemy function.
   DoMessage();                           // Updates Messages.

   if (NukeLeft > 0){                     // If the Nuke is active,

   	for(int i = 1;i<EnTotal;i++){       	// Loop encompassing all Enemies
			if((En[i].objTyp != 0) && (En[i].dead == false)) {
         	// If object is active and alive,
         	Explode(En[i].x,En[i].y,En[i].vx,En[i].vy,40,30,1);
            												// Make an explosion.
            UserScore+=100;	// 100 Points for each Enemy killed by a Nuke.
            Message(En[i].x,En[i].y,"100",2);   // Show Points Scored.
         }
         	// If object is an interceptor, make it dead,
   		if ((En[i].objTyp == 4) && (En[i].scale > 2)) En[i].dead = true;
         else                         // or else make enemy inactive.
         	if(En[i].dead == false)	En[i].objTyp = 0;

   	}
      for(int i = 1;i<BulTotal;i++){         // Loop encompassing all Bullets.
         if(Bul[i].bulTyp > 1){              	// If bullet is not debree,
          	Explode(Bul[i].x,Bul[i].y,Bul[i].vx,Bul[i].vy,Bul[i].dmg*4,Bul[i].dmg*3,1);
 					// Make an explosion that reflects the bullet's damage points.
         	Bul[i].bulTyp = 0;                  // Make bullet inactive.
         }
      }
   	int vx,vy,x,y;                            // Temp variables.
   	for(int i = 1;i<NukeLeft/8;i++){          // Loop for explostions.
   		x = random(640);                       	// Random X position.
   		y = random(240)+240;								// Random Y position.
   		vx = (x-320)/12;                          // Velocity reflects the
   		vy = (y-460)/13;                          // random positions.
   		Explode(x,y,vx,vy,20,20,1);               // Explode with temp vars.

   	}
   if ((random(NukeLeft+20)>40) && (!User.dead) && (User.sp>0)) {
   	// Randomly hurt User's shields if user is active.
   	Explode(User.x,User.y,0,0,40,25,4);   	// Make a blue shield explosion.
      User.sp--;										// Subtract from remaining shields.
   }
   NukeLeft--;                               // Decrement Nuke's activity.
   if(NukeLeft == 3) DoUserBar(true,true);   // Refresh Userbar when Nuke is
   }                                         // close to being done.


}

////////////////////////////////////////////////////////////////////////////////
void DoLevel(int Lvl)
// DoLevel runs the "script" of the activities during gameplay according the the
// Current Level (int Lvl).
// "rev" is short for revolution.
{
	if (Rev == 40) Message(300,300,"READY",1);	// at 40th rev, display "READY".

   if (Rev == 20) {                             // at 20th rev,
      UserMissiles +=5;                         	// give User more missiles.
      if (UserMissiles > 10) UserMissiles = 10;    // make sure missiles max out
      else Message(180,120,"+5 Missiles!",1);      // display "+5 Missiles".
      UserNukes++;                                 // give User 1 more Nuke.
      if (UserNukes >3) UserNukes = 3;             // make sure Nukes max out.
      else Message(350,120,"+1 Nuke!",1);          // display "+1 Nukes".
      DoUserBar(true,true);                        // Refresh Userbar.
   }


   if (User.dead) {                                // If User is inactive,
   	Rev--;                                       	// Decriment revolution #.
   	DoUserBar(false,true);                          // Refresh Userbar
   }
   else                                            // if User is not inactive,
   {
   	if (Rev/(30+10*DifLevel)*(30+10*DifLevel) == Rev) User.sp++;
      // At Every 50th, 70th, or 90th rev, add 1 SP.
   	if (User.sp >25) User.sp = 25;               // Max out SPs.
   }
  	EnemyAim = false;                               // Set helicopter aim false.
	switch (Lvl) 	// Switch runs the "script" for each level
   {
   	case 1:	// if Lvl is 1, then planes fly out randomly.
      	if ((random(200)>194-int(Rev/500))&&(Rev > 80)&&(Rev < 900)) CreateUnit(2);
      	if ((random(600)>600-DifLevel)&&(Rev > 80)&&(Rev < 900)) CreateUnit(3);
         if (Rev > 1000) NextLevel=true;	// after 1000 revs, go to next level.
      break;
   	case 2:	// if Lvl is 2, then helicopters fly out randomly.
      	if ((random(200)>195-int(Rev/400))&&(Rev > 80)&&(Rev < 1400)) CreateUnit(3);
         if (Rev > 1550) NextLevel=true;  // after 1550 revs, go to next level.
      break;
      case 3:  // if Lvl is 3, then Interceptors come in from the back.
      	if ((random(200)>195-int(Rev/200))&&(Rev > 80)&&(Rev < 900)) CreateUnit(4);
         if (Rev > 1050) NextLevel=true;   // after 850 revs, go to next level.
      break;
   	case 4:  // if Lvl is 4, then planes and helicopters fly out randomly.
      	if ((random(200)>197-int(Rev/700))&&(Rev > 80)&&(Rev < 1100)) CreateUnit(2);
      	if ((random(200)>196-int(Rev/500))&&(Rev > 580)&&(Rev < 1400)) CreateUnit(3);
         if (Rev > 1500) NextLevel=true;  // after 1500 revs, go to next level.
      break;
   	case 5:  // if Lvl is 5, same as Lvl 4 except helicopter aim is turned on.
      	if ((random(200)>197-int(Rev/500))&&(Rev > 80)&&(Rev < 1700)) CreateUnit(2);
      	if ((random(200)>197-int(Rev/400))&&(Rev > 80)&&(Rev < 1600)) CreateUnit(3);
         if (Rev > 1800) NextLevel=true;  // after 2000 revs, go to next level.
         EnemyAim = true;                 // turn on helicopter aim.
      break;
   	case 6:  // if Lvl is 6, same as Lvl 5 except Interceptors are present.
      	if ((random(200)>197-int(Rev/600))&&(Rev > 80)&&(Rev < 1900)) CreateUnit(2);
      	if ((random(200)>198-int(Rev/700))&&(Rev > 80)&&(Rev < 1800)) CreateUnit(4);
      	if ((random(200)>197-int(Rev/500))&&(Rev > 580)&&(Rev < 1900)) CreateUnit(3);
         if (Rev > 2000) NextLevel=true;  // after 3000 revs, go to next level.
         EnemyAim = true;                 // turn on helicopter aim.
      break;
      default:                            // Error checking.

      break;
   }
}
////////////////////////////////////////////////////////////////////////////////
void DoMain(int Lvl)
// Main function of the tank fight. This function begins a level, displays the
// level number, calls main functions (CalcAllObjs,DrawAllObjs,DoLevel), and
// waits for the bios timer to reset.
{
	if (Lvl == 1) DrawLevel(true,true,0,65); 	// start the game with a full draw.

   BGCol = RGB(Lvl*10,random(Lvl*3),60-Lvl*10);
   SetFillColorRGB(BGCol);
   Rect(0,0,640,480,BGCol);
   DrawLevel(true,false,0,65);
   DoUserBar(true,true);
   char str[10];										// temp variable
   itoa(Lvl, str, 10);								// converts Lvl to string.

	Message(300,300,"Level",1);               // Displays "Level X" with X being
	Message(350,300,str,1);							// the current Level #.

   bool Continue = true;                     // Continue is set to true.
   Pause = false;                            // Pause is not active.
   Rev = 0;                                  // Revolutions is set to 0.
   while (Continue == true){                 // While Continue is true,
      if (Pause == false){							// If Pause is inactive,
   		Rev++;                              	// Increment Revolutions.
   		CurTime = clock();							// Get current time.
         DoLevel(Lvl);                          // Do the Level "Script".
         if (NextLevel == true) Continue = false;	// If DoLevel returned false,
         														// Continue is set to false.
      	CalcAllObjs();                         // Calculate all Objects.
      	DrawAllObjs();                         // Draw all Objects.
         while(clock()<CurTime+SleepTime);
         // This waits for the bios time (clock()) to catch up with Current time
         // plus SleepTime. This acts as a real-time timer.
      }
      else{                                  // If Pause is active,
         Text(260,260,"GAME PAUSED...",RGB(Rev+150,Rev*2+250,Rev*3+50));
         Text(200,240,"PRESS ANY KEY TO CONTINUE",WHITE);
         												// Display Game Paused msg.
         int x,y;                            // Temp vars
         for(int i=0;i<300;i++){             // 300 loop
         	x=random(641);                   // Randomly picks 2 coordinants
         	y=random(481);                   // from the screen.

        	 	if (GetPix(x,y) == WHITE){
            // If the pixel at x,y is not BackGround or yellow,
         		Pixel(x+1,y+1,WHITE);         		// This draws 5 pixels in a
         		Pixel(x+2,y+2,WHITE);     				// line in different shades
         		Pixel(x+3,y+3,RGB(165,165,165));    // of gray. This loop acts
         		Pixel(x+4,y+4,RGB(145,145,145));    // as a type of screen saver
         		Pixel(x+5,y+5,RGB(125,125,125));    // while pause is active.
               Pixel(x+6,y+6,RGB(105,105,105));
               Pixel(x+7,y+7,RGB(85,85,85));
         	}
         }

      	if (cKeyPressed != 0) {                  	// If key is pressed,
         	Pause = false;                          	// pause is inactive.
   			SetFillColorRGB(BGCol);
            Rect(0,0,640,480,BGCol);                  // Screen is cleared.
				DrawLevel(true,true,0,65);                // Level is redrawn.
            DoUserBar(true,true);                     // User bar is redrawn.
            cKeyPressed=0;                            // cKeyPressed is reset.
         }                                         // End if key is pressed.
      }                                        	// End if pause is active.
   } 														// End if Continue is true,
}                                       	// End DoMain function.



////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
DWORD WINAPI DrawThread( LPVOID )
// The starting function of the program which is called by EZGDI.
// This function sets Title, initiates Graphics and Units, runs the Intro, sets
// critical game variables, and creates a new random terrain.
{
	randomize();  							// Initialize the random number generator

	SetTitle("T a n k F i g h t   1 . 0");		// Set the window title


   InitializeGFXOBJs();             // Initialize all the Graphical Objects.
   while(100>=random(3)){					// Forever Loop
   	InitializeUnits();               // Initialize all the Units.
		SetGameVars();                   // Set Critical Game variables.
   	DoIntro(SleepTime,DifLevel,ShowSmoke,ShowDebris);
   										   // Run Intro and Main Screen.
   	CreateLevel(CurLvl);             // Create a new level.


   	for(int i = 1;i<=LvlTotal;i++)   // Main level loop of game.
   	{
      	NextLevel = false;            	// Variable set to false.
   		DoMain(i);                       // DoMain until the "script" calls next
                                       // Level.
   		if(User.objTyp == 0) i =100;
   	}
   	DoHighScore(UserScore);
   }
	return 0;                        // Return Nothing.
}


