/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;

import java.util.Hashtable;
import java.util.Vector;

import stec.pos.ByteArray;
import stec.pos.Blob;

import stec.pos.ByteArray;
import stec.pos.ObjectStoreEnumeration;
import stec.pos.ObjectStoreUtils;
import stec.pos.ObjectStore;
import stec.pos.ObjectStoreReference;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;

import stec.lang.DString;
import stec.lang.QuickSort;

import stec.iws.Utils;
import stec.iws.iws;

public class PosEmployeesServlet extends HttpServlet
{
	private static final String STORE = "/employees/employees";

	String select_template;
	String list_template;
	String list_entry_template;
	String add_template;
	String edit_template;
	String remove_template;

	String path;

	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);

		try
		{
			select_template = Utils.getItem("./employees/select.tf");
			list_template = Utils.getItem("./employees/list.tf");
			list_entry_template = Utils.getItem("./employees/list_entry.tf");
			add_template = Utils.getItem("./employees/add.tf");
			edit_template = Utils.getItem("./employees/edit.tf");
			remove_template = Utils.getItem("./employees/remove.tf");

			path = Utils.concatPaths(iws.getBaseDirectory(), STORE);

			if(!ObjectStore.exists(path))
			{
				ObjectStore.create(path, 256, ObjectStoreUtils.prime(100), -1, -1, false);
			}
		}
		catch(Exception ex)
		{
			throw new ServletException(ex);
		}
	}

	public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		_response.setContentType("text/html");

		ServletOutputStream out = _response.getOutputStream();

		try
		{
			String formname = _request.getParameter("formname");
			if(formname == null)
			{
				select("", out, _request, _response);
			}
			else if(formname.length() == 0)
			{
				select("", out, _request, _response);
			}
			else if(formname.equalsIgnoreCase("select"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					select("", out, _request, _response);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						select("", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("add"))
					{
						add(new Employee(), "", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("edit"))
					{
						String key = _request.getParameter("key");

						if(key == null)
						{
							select("Employee was not selected.", out, _request, _response);
						}
						else if(key.length() == 0)
						{
							select("Employee was not selected.", out, _request, _response);
						}
						else
						{
							ObjectStoreReference reference = ObjectStore.open(path, false);

							try
							{
								Object obj = reference.get(key);

								if(obj == null)
								{
									select("Employee was not found: " + key, out, _request, _response);
								}
								else if(!(obj instanceof Employee))
								{
									select("Employee was not found: " + key, out, _request, _response);
								}
								else
								{
									Employee employee = (Employee)obj;

									edit(employee, "", out, _request, _response);
								}
							}
							finally
							{
								reference.close();
							}
						}
					}
					else if(action.equalsIgnoreCase("remove"))
					{
						String key = _request.getParameter("key");

						if(key == null)
						{
							select("Employee was not selected.", out, _request, _response);
						}
						else if(key.length() == 0)
						{
							select("Employee was not selected.", out, _request, _response);
						}
						else
						{
							ObjectStoreReference reference = ObjectStore.open(path, false);

							try
							{
								Object obj = reference.get(key);

								if(obj == null)
								{
									select("Employee was not found: " + key, out, _request, _response);
								}
								else if(!(obj instanceof Employee))
								{
									select("Employee was not found: " + key, out, _request, _response);
								}
								else
								{
									Employee employee = (Employee)obj;

									remove(employee, "", out, _request, _response);
								}
							}
							finally
							{
								reference.close();
							}
						}
					}
					else if(action.equalsIgnoreCase("list"))
					{
						list("", out, _request, _response);
					}
					else
					{
						select("Invalid action: " + action, out, _request, _response);
					}
				}
			}
			else if(formname.equalsIgnoreCase("add"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					Employee employee = getEmployee(_request);

					add(employee, "", out, _request, _response);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						Employee employee = getEmployee(_request);

						add(employee, "", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						Employee employee = getEmployee(_request);

						ObjectStoreReference reference = ObjectStore.open(path, false);

						try
						{
							if(reference.containsKey(employee.email_address))
							{
								add(employee, "Employee already exists: " + employee.email_address, out, _request, _response);
							}
							else
							{
								String error_message = check(employee);
								if(error_message.length() == 0)
								{
									reference.put(employee.email_address, employee);

									select("", out, _request, _response);
								}
								else
								{
									add(employee, error_message, out, _request, _response);
								}
							}
						}
						finally
						{
							reference.close();
						}
					}
					else if(action.equalsIgnoreCase("cancel"))
					{
						select("", out, _request, _response);
					}
					else
					{
						Employee employee = getEmployee(_request);

						add(employee, "Invalid action: " + action, out, _request, _response);
					}
				}
			}
			else if(formname.equalsIgnoreCase("edit"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					Employee employee = getEmployee(_request);

					edit(employee, "", out, _request, _response);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						Employee employee = getEmployee(_request);

						edit(employee, "", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						Employee employee = getEmployee(_request);

						ObjectStoreReference reference = ObjectStore.open(path, false);

						try
						{
							String error_message = check(employee);
							if(error_message.length() == 0)
							{
								reference.put(employee.email_address, employee);

								select("", out, _request, _response);
							}
							else
							{
								edit(employee, error_message, out, _request, _response);
							}
						}
						finally
						{
							reference.close();
						}
					}
					else if(action.equalsIgnoreCase("cancel"))
					{
						select("", out, _request, _response);
					}
					else
					{
						Employee employee = getEmployee(_request);

						edit(employee, "Invalid action: " + action, out, _request, _response);
					}
				}
			}
			else if(formname.equalsIgnoreCase("remove"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					Employee employee = getEmployee(_request);

					remove(employee, "", out, _request, _response);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						Employee employee = getEmployee(_request);

						remove(employee, "", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						Employee employee = getEmployee(_request);

						ObjectStoreReference reference = ObjectStore.open(path, false);

						try
						{
							StringBuffer sb = new StringBuffer();

							check(sb, "E-Mail Address", employee.email_address);

							String error_message = sb.toString();

							if(error_message.length() == 0)
							{
								reference.remove(employee.email_address);

								select("", out, _request, _response);
							}
							else
							{
								remove(employee, error_message, out, _request, _response);
							}
						}
						finally
						{
							reference.close();
						}
					}
					else if(action.equalsIgnoreCase("cancel"))
					{
						select("", out, _request, _response);
					}
					else
					{
						Employee employee = getEmployee(_request);

						remove(employee, "Invalid action: " + action, out, _request, _response);
					}
				}
			}
			else if(formname.equalsIgnoreCase("list"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					select("", out, _request, _response);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						select("", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						select("", out, _request, _response);
					}
					else
					{
						list("Invalid action: " + action, out, _request, _response);
					}
				}
			}
			else
			{
				select("", out, _request, _response);
			}
		}
		catch(Exception ex)
		{
			throw new ServletException(ex.getMessage());
		}
	}

	private void check(StringBuffer sb, String field, String value)
	{
		if(value == null)
		{
			sb.append(field);
			sb.append(" is required.<br>");
		}
		else if(value.length() == 0)
		{
			sb.append(field);
			sb.append(" is required.<br>");
		}
	}

	private String check(Employee employee)
	{
		StringBuffer sb = new StringBuffer();

		check(sb, "E-Mail Address", employee.email_address);
		check(sb, "First Name", employee.first_name);

		if(employee.middle_initial != null)
		{
			if(employee.middle_initial.length() > 1)
			{
				sb.append("Middle Initial is too long: " + employee.middle_initial + "<br>");
			}
		}

		check(sb, "Last Name", employee.last_name);
		check(sb, "Title", employee.title);
		check(sb, "Telephone Number", employee.telephone_number);

		return sb.toString();
	}

	private Employee getEmployee(HttpServletRequest request)
	{
		String email_address = (String)request.getParameter("email_address");
		String first_name = (String)request.getParameter("first_name");
		String middle_initial = (String)request.getParameter("middle_initial");
		String last_name = (String)request.getParameter("last_name");
		String title = (String)request.getParameter("title");
		String telephone_number = (String)request.getParameter("telephone_number");

		return new Employee(email_address, first_name, middle_initial, last_name, title, telephone_number);
	}

	private void select(String error_message, ServletOutputStream out, HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		String template = new String(select_template);
		template = DString.replace(template, "%error_message%", error_message);

		String key;
		Employee employee;

		Vector employees = new Vector();

		ObjectStoreReference reference = ObjectStore.open(path, false);

		try
		{
			ObjectStoreEnumeration e = reference.keys();

			while(e.hasMoreElements())
			{
				key = (String)e.nextElement();
				employee = (Employee)reference.get(key);
				employees.addElement(employee);
			}

			QuickSortEmployees sorter = new QuickSortEmployees();
			sorter.sort(employees);

			StringBuffer sb = new StringBuffer();

			int count = employees.size();

			for(int i = 0; i < count; i++)
			{
				employee = (Employee)employees.elementAt(i);

				if(employee.middle_initial.length() > 0)
				{
					sb.append("<option value = \"" + employee.email_address + "\">" + employee.last_name + ", " + employee.first_name + " " + employee.middle_initial + "." + "\n");
				}
				else
				{
					sb.append("<option value = \"" + employee.email_address + "\">" + employee.last_name + ", " + employee.first_name + "\n");
				}
			}

			template = DString.replace(template, "%list%", sb.toString());

			out.print(template);
		}
		finally
		{
			reference.close();
		}
	}

	private String replace(String template, String field, String value)
	{
		return DString.replace(template, field, (value == null) ? "" : value);
	}

	private void add(Employee employee, String error_message, ServletOutputStream out, HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		String template = new String(add_template);
		template = DString.replace(template, "%error_message%", error_message);

		template = replace(template, "%email_address%", employee.email_address);
		template = replace(template, "%first_name%", employee.first_name);
		template = replace(template, "%last_name%", employee.last_name);
		template = replace(template, "%middle_initial%", employee.middle_initial);
		template = replace(template, "%title%", employee.title);
		template = replace(template, "%telephone_number%", employee.telephone_number);

		out.print(template);
	}

	private void edit(Employee employee, String error_message, ServletOutputStream out, HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		String template = new String(edit_template);
		template = DString.replace(template, "%error_message%", error_message);

		template = replace(template, "%email_address%", employee.email_address);
		template = replace(template, "%first_name%", employee.first_name);
		template = replace(template, "%last_name%", employee.last_name);
		template = replace(template, "%middle_initial%", employee.middle_initial);
		template = replace(template, "%title%", employee.title);
		template = replace(template, "%telephone_number%", employee.telephone_number);

		out.print(template);
	}

	private void remove(Employee employee, String error_message, ServletOutputStream out, HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		String template = new String(remove_template);
		template = DString.replace(template, "%error_message%", error_message);

		template = replace(template, "%email_address%", employee.email_address);
		template = replace(template, "%first_name%", employee.first_name);
		template = replace(template, "%last_name%", employee.last_name);
		template = replace(template, "%middle_initial%", employee.middle_initial);
		template = replace(template, "%title%", employee.title);
		template = replace(template, "%telephone_number%", employee.telephone_number);

		out.print(template);
	}

	private void list(String error_message, ServletOutputStream out, HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		String template = new String(list_template);
		template = DString.replace(template, "%error_message%", error_message);

		String key;
		Employee employee;

		Vector employees = new Vector();

		ObjectStoreReference reference = ObjectStore.open(path, false);

		try
		{
			ObjectStoreEnumeration e = reference.keys();

			while(e.hasMoreElements())
			{
				key = (String)e.nextElement();
				employee = (Employee)reference.get(key);
				employees.addElement(employee);
			}

			QuickSortEmployees sorter = new QuickSortEmployees();
			sorter.sort(employees);

			StringBuffer sb = new StringBuffer();

			String entry_template;

			int count = employees.size();

			for(int i = 0; i < count; i++)
			{

				entry_template = new String(list_entry_template);

				employee = (Employee)employees.elementAt(i);

				entry_template = DString.replace(entry_template, "%email_address%", employee.email_address);
				entry_template = DString.replace(entry_template, "%first_name%", employee.first_name);
				entry_template = DString.replace(entry_template, "%last_name%", employee.last_name);
				entry_template = DString.replace(entry_template, "%middle_initial%", employee.middle_initial);
				entry_template = DString.replace(entry_template, "%title%", employee.title);
				entry_template = DString.replace(entry_template, "%telephone_number%", employee.telephone_number);

				sb.append(entry_template + "\n");
			}

			template = DString.replace(template, "%list%", sb.toString());

			out.print(template);
		}
		finally
		{
			reference.close();
		}
	}

	public String getServletInfo()
	{
		return "PosEmployeesServlet";
	}

	class QuickSortEmployees extends QuickSort
	{
		public Vector sort(Vector list)
		{
			return (Vector)super.sort(list);
		}

		public int compare(Object object1, Object object2)
		{
			Employee employee1 = (Employee)object1;
			Employee employee2 = (Employee)object2;

			String name1 = employee1.last_name + ", " + employee1.first_name + " " + employee1.middle_initial;
			String name2 = employee2.last_name + ", " + employee2.first_name + " " + employee2.middle_initial;

			return name1.compareTo(name2);
		}

		public int count(Object objects)
		{
			return ((Vector)objects).size();
		}

		public Object extract(Object objects, int index)
		{
			return ((Vector)objects).elementAt(index);
		}

		public void replace(Object objects, int index, Object object)
		{
			((Vector)objects).setElementAt(object, index);
		}
	}
}
