// MainDlg.h : header file
//

#if !defined(AFX_MAINDLG_H__6F25FADE_3D19_4371_A550_B74561E7B764__INCLUDED_)
#define AFX_MAINDLG_H__6F25FADE_3D19_4371_A550_B74561E7B764__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <ExtButton.h>
#include <ExtBtnOnFlat.h>
#include <ExtEdit.h>
#include <ExtComboBox.h>
#include <ExtResizableDialog.h>

/////////////////////////////////////////////////////////////////////////////
// CMainDlg dialog

class CMainDlg : public CExtResizableDialog
{
	bool m_bDialogInitComplete;
	bool m_bShowIconInTray,m_bDialogWithCtxMenu;
	void ShowCtxMenu(CPoint ptScreen);
	CMenu m_menu;
// Construction
public:
	CMainDlg(CWnd* pParent = NULL);	// standard constructor

	class CMainTabCtrl : public CTabCtrl
	{
	public:
		LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
		{
			if( message == WM_ERASEBKGND )
				return TRUE;
			return CTabCtrl::WindowProc(message,wParam,lParam);
		}
	}; // class CMainTabCtrl

	CExtComboBox	m_ComboAskQuestion;

// Dialog Data
	//{{AFX_DATA(CMainDlg)
#if (!defined __EXT_MFC_NO_TAB_CTRL)
	enum { IDD = IDD_PROFUIS_CONTROLS_DIALOG };
#else
	enum { IDD = IDD_PROFUIS_CONTROLS_DIALOG_NO_TAB };
#endif // else from (!defined __EXT_MFC_NO_TAB_CTRL)
	CExtButton	m_BtnTabDemo;
	CExtBtnOnFlat	m_CheckShowTab;
	CMainTabCtrl	m_MainTab;
	CExtBtnOnFlat	m_CheckMenuWithShadows;
	CExtComboBox	m_ComboMenuEffect;
	CExtBtnOnFlat	m_CheckAnimateMenuWhenExpanding;
	CExtColorButton	m_btnColor2;
	CExtColorButton	m_btnColor1;
	CExtButton	m_btn2;
	CExtEdit	m_EditSample;
	CExtComboBox	m_ComboEditable;
	CExtComboBox	m_ComboUiLook;
	CExtBtnOnFlat	m_CheckEnableContextMenu;
	CExtBtnOnFlat	m_CheckShowIconInTray;
	CExtButton	m_BtnCancel;
	CExtButton	m_BtnOK;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainDlg)
	public:
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

#if (!defined __EXT_MFC_NO_TAB_CTRL)
	class CDemoExtTabWnd : public CExtTabWnd
	{
	public:
		virtual bool OnTabWndSelectionChange(
			LONG nOldItemIndex,
			LONG nNewItemIndex,
			bool bPreSelectionTest
			)
		{
			bool bRetVal =
				CExtTabWnd::OnTabWndSelectionChange(
					nOldItemIndex,
					nNewItemIndex,
					bPreSelectionTest
					);
			if( !bPreSelectionTest )
			{
				CMainDlg * pDlg = (CMainDlg *)GetParent();
				ASSERT_VALID( pDlg );
				if( pDlg->m_MainTab.GetCurSel() != nNewItemIndex )
				{
					pDlg->m_MainTab.SetCurSel( nNewItemIndex );
					pDlg->RedrawWindow();
				}
			}
			return bRetVal;
		}
	};

	CDemoExtTabWnd m_wndExtTabCtrl;

#endif // (!defined __EXT_MFC_NO_TAB_CTRL)

	CExtMenuControlBar m_wndMenuBar;
	CExtToolControlBar m_wndToolBarTop;
	CExtToolControlBar m_wndToolBarLeft;
	CExtStatusControlBar m_wndStatusBar;

	INT m_nThinColorBtnHeight;
	CExtPopupMenuTipWnd m_wndLeftBarTip;

	class CBitmapLabelInMenuBar : public CExtBarButton
	{
		CBitmap m_bmp;
		CSize m_sizeBmp;
		bool m_bTransparentBitmap:1;
	public:
		CBitmapLabelInMenuBar(
			CExtToolControlBar * pBar,
			UINT nCmdID,
			UINT nBitmapResourceID
			)
			: CExtBarButton( pBar, nCmdID, 0 )
			, m_bTransparentBitmap( false )
		{
			VERIFY( m_bmp.LoadBitmap(nBitmapResourceID) );
			BITMAP _bitmap;
			VERIFY( m_bmp.GetBitmap( &_bitmap ) );
			m_sizeBmp.cx = _bitmap.bmWidth;
			m_sizeBmp.cy = _bitmap.bmHeight;
		}
	
		int OnToolHitTest(
			CPoint point,
			TOOLINFO * pTI
			)
		{
			ASSERT_VALID( this );
			
			point;
			pTI;
	
			return -1;
		}

		virtual CSize CalculateLayout(
			CDC & dc,
			CSize sizePreCalc,
			BOOL bHorz
			)
		{
			ASSERT_VALID( this );
			dc;
			sizePreCalc;
			bHorz;
			return m_sizeBmp;
		}

		virtual void Paint(
			CDC & dc,
			bool bHorz
			)
		{
			ASSERT_VALID( this );
			ASSERT(
				m_bmp.GetSafeHandle() != NULL
				&& m_sizeBmp.cx > 0
				&& m_sizeBmp.cy > 0
				);
			bHorz;
			
			CDC dcBmp;
			VERIFY( dcBmp.CreateCompatibleDC( &dc ) );
			CBitmap * pOldBmp = dcBmp.SelectObject( &m_bmp );

			CRect rcArea( Rect() );
			if( m_bTransparentBitmap )
				CExtPaintManager::stat_TransparentBlt(
					dc.GetSafeHdc(),
					rcArea.left, rcArea.top,
					m_sizeBmp.cx, m_sizeBmp.cy,
					dcBmp.GetSafeHdc(),
					0, 0,
					m_sizeBmp.cx, m_sizeBmp.cy,
					RGB( 255, 255, 255 )
					);
			else
				dc.BitBlt(
					rcArea.left, rcArea.top,
					m_sizeBmp.cx, m_sizeBmp.cy,
					&dcBmp, 0, 0, SRCCOPY
					);
			if( IsPressed() || IsHover() )
			{
				COLORREF clrTL = g_PaintManager->GetColor(
					COLOR_3DHIGHLIGHT
					);
				COLORREF clrBR = g_PaintManager->GetColor(
					IsPressed() ? COLOR_3DDKSHADOW : COLOR_3DSHADOW
					);
				dc.Draw3dRect( rcArea, clrBR, clrBR );
				rcArea.DeflateRect( 1, 1 );
				dc.Draw3dRect( rcArea, clrTL, clrTL );
				rcArea.DeflateRect( 1, 1 );
				dc.Draw3dRect( rcArea, clrBR, clrBR );
			}
			
			dcBmp.SelectObject( pOldBmp );
		}

		virtual void OnClick(
			CPoint point,
			bool bDown
			)
		{
			ASSERT_VALID( this );

			if( !bDown )
			{
				m_bTransparentBitmap = !m_bTransparentBitmap;

				CExtToolControlBar * pBar = GetBar();
				ASSERT_VALID( pBar );

				pBar->RedrawWindow();
			}

			CExtBarButton::OnClick(
				point,
				bDown
				);

		}
	}; // class CBitmapLabelInMenuBar

	class CThinColorButtonInToolBar : public CExtBarButton
	{
		COLORREF m_clr;
	public:
		CThinColorButtonInToolBar(
			COLORREF clr,
			CExtToolControlBar * pBar
			)
			: CExtBarButton(
				pBar,
				g_CmdManager->CmdAllocPtr(
					g_CmdManager->ProfileNameFromWnd(
						pBar->GetSafeHwnd()
						)
					)->m_nCmdID
				),
			m_clr( clr )
		{
			CExtCmdManager::cmd_t * p_cmd =
				g_CmdManager->CmdGetPtr(
					g_CmdManager->ProfileNameFromWnd(
						pBar->GetSafeHwnd()
						),
					GetCmdID()
					);
			ASSERT( p_cmd != NULL );
			p_cmd->StateSetBasic();

			p_cmd->m_sMenuText.Format(
				_T( "RGB color is 0x%02X%02X%02X" ),
				INT( GetRValue(clr) ),
				INT( GetGValue(clr) ),
				INT( GetBValue(clr) )
				);
			p_cmd->m_sTipStatus.Format(
				_T( "Color in the left toolbar\nRGB color is 0x%02X%02X%02X" ),
				INT( GetRValue(clr) ),
				INT( GetGValue(clr) ),
				INT( GetBValue(clr) )
				);
			p_cmd->m_sTipTool = p_cmd->m_sTipStatus;

			HICON hIcon = CExtColorButton::GenerateColorIcon( clr );
			ASSERT( hIcon != NULL );
			VERIFY(
				g_CmdManager->CmdSetIcon(
					g_CmdManager->ProfileNameFromWnd(
						pBar->GetSafeHwnd()
						),
					p_cmd->m_nCmdID,
					hIcon,
					false
					)
				);

		};
	
		virtual CSize CalculateLayout(
			CDC & dc,
			CSize sizePreCalc,
			BOOL bHorz
			)
		{
			ASSERT_VALID( this );

			CSize _size =
				CExtBarButton::CalculateLayout(
					dc,
					sizePreCalc,
					bHorz
					);
			CExtToolControlBar * pBar = GetBar();
			ASSERT_VALID( pBar );
			CMainDlg * pDlg = (CMainDlg *)pBar->GetParent();
			ASSERT_VALID( pDlg );
			if( bHorz )
				_size.cx = pDlg->m_nThinColorBtnHeight;
			else
				_size.cy = pDlg->m_nThinColorBtnHeight;
			return _size;
		}

		virtual void Paint(
			CDC & dc,
			bool bHorz
			)
		{
			ASSERT_VALID( this );

			bHorz;
			CRect rcArea( Rect() );
			rcArea.DeflateRect(
				__TB_BUTTON_MARGINE__,
				__TB_BUTTON_MARGINE__
				);
			dc.FillSolidRect(
				&rcArea,
				m_clr
				);
			bool bEnabled = IsDisabled() ? false : true;
			bool bPushed =
					IsPressed() ? true : false;
			bool bHover =
					(	bEnabled
						&& IsHover()
						&& !CExtToolControlBar::g_bMenuTracking
						&& !CExtPopupMenuWnd::IsMenuTracking()
					) ? true : false;
			if( bPushed || bHover )
			{
				COLORREF clrTL = g_PaintManager->GetColor( COLOR_3DHIGHLIGHT );
				COLORREF clrBR = g_PaintManager->GetColor( COLOR_3DDKSHADOW );
				if( bPushed )
				{
					dc.Draw3dRect( rcArea, clrBR, clrTL );
				}
				else
				{
					//dc.Draw3dRect( rcArea, clrTL, clrBR );
					dc.Draw3dRect( rcArea, clrBR, clrBR );
					rcArea.DeflateRect( 1, 1 );
					if( rcArea.Height() > 3 )
					{
						dc.Draw3dRect( rcArea, clrTL, clrTL );
						rcArea.DeflateRect( 1, 1 );
						if( rcArea.Height() > 3 )
							dc.Draw3dRect( rcArea, clrBR, clrBR );
					}
				}
			}
		}

		virtual void OnHover(
			CPoint point,
			bool bOn
			)
		{
			ASSERT_VALID( this );

			CExtBarButton::OnHover(
				point,
				bOn
				);

			CExtToolControlBar * pBar = GetBar();
			ASSERT_VALID( pBar );
			CMainDlg * pDlg = (CMainDlg *)pBar->GetParent();
			ASSERT_VALID( pDlg );

			if( bOn )
			{
				CExtCmdManager::cmd_t * p_cmd =
				g_CmdManager->CmdGetPtr(
					g_CmdManager->ProfileNameFromWnd(
						pBar->GetSafeHwnd()
						),
					GetCmdID()
					);
				ASSERT( p_cmd != NULL );
				pDlg->m_wndLeftBarTip.SetText( p_cmd->m_sTipStatus );
				CRect rcAreaScreen = Rect();
				pBar->ClientToScreen( &rcAreaScreen );
				pDlg->m_wndLeftBarTip.Show( pBar, rcAreaScreen );
			}
			else
			{
				pDlg->m_wndLeftBarTip.Hide();
			}
		}
		
		virtual void OnClick(
			CPoint point,
			bool bDown
			)
		{
			ASSERT_VALID( this );

			CExtToolControlBar * pBar = GetBar();
			ASSERT_VALID( pBar );
			CMainDlg * pDlg = (CMainDlg *)pBar->GetParent();
			ASSERT_VALID( pDlg );

			pDlg->m_wndLeftBarTip.Hide();

			CExtBarButton::OnClick(
				point,
				bDown
				);
		}

		int OnToolHitTest(
			CPoint point,
			TOOLINFO * pTI
			)
		{
			ASSERT_VALID( this );
			
			point;
			pTI;
	
			return -1;
		}

	}; // class CThinColorButtonInToolBar

	friend class CThinColorButtonInToolBar;

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CMainDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnAppAbout();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSelendokComboUiLook();
	afx_msg void OnCheckShowInTray();
	afx_msg void OnEnableDialogContextMenu();
	afx_msg void OnLook2k();
	afx_msg void OnUpdateLook2k(CCmdUI* pCmdUI);
	afx_msg void OnLookXp();
	afx_msg void OnUpdateLookXp(CCmdUI* pCmdUI);
	afx_msg void OnCheckMenuAnimExpanding();
	afx_msg void OnSelendokComboMenuOpenEffect();
	afx_msg void OnCheckMenuWithShadows();
	afx_msg void OnDestroy();
	afx_msg void OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnShowTab();
	afx_msg void OnButtonTabDemo();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	afx_msg void OnUpdateCheckShowInTray(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonTabDemo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEnableDialogContextMenu(CCmdUI* pCmdUI);
	afx_msg LRESULT OnInconNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDrawPopupMenuItem(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDrawPopupLeftArea(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnColorChangedFinally(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnColorSelectCustom(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINDLG_H__6F25FADE_3D19_4371_A550_B74561E7B764__INCLUDED_)
