unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, ComCtrls, StdCtrls, ExtCtrls, Grids, DBGrids, FuzzySearch;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    UpDown1: TUpDown;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Addr1: TStringField;
    Table1Addr2: TStringField;
    Table1City: TStringField;
    Table1State: TStringField;
    Table1Zip: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1FAX: TStringField;
    Table1TaxRate: TFloatField;
    Table1Contact: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    Label3: TLabel;
    procedure Table1FilterRecord(DataSet: TDataSet; var Accept: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
  private
    { Private declarations }
  public
    FuzzySearch: TFuzzySearch;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Table1FilterRecord(DataSet: TDataSet;
  var Accept: Boolean);
begin
  try
    Accept :=
      FuzzySearch.Match(PChar(DataSet.FieldByName('Company').AsString)) or
      FuzzySearch.Match(PChar(DataSet.FieldByName('Addr1').AsString)) or
      FuzzySearch.Match(PChar(DataSet.FieldByName('Addr2').AsString)) or
      FuzzySearch.Match(PChar(DataSet.FieldByName('Country').AsString)) or
      FuzzySearch.Match(PChar(DataSet.FieldByName('Phone').AsString)) or
      FuzzySearch.Match(PChar(DataSet.FieldByName('FAX').AsString)) or
      FuzzySearch.Match(PChar(DataSet.FieldByName('Contact').AsString));
  except
    Accept := False;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FuzzySearch:=TFuzzySearch.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FuzzySearch.Free;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  if Edit1.Text <> '' then begin
    FuzzySearch.Pattern:=Edit1.Text;
    FuzzySearch.Degree:=UpDown1.Position;
  end;
  Table1.Filtered:=Edit1.Text <> '';
end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
  FuzzySearch.Degree:=UpDown1.Position;
  Table1.Refresh;
end;

end.
