/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#if TARGET_API_Win32 || TARGET_API_Win32_Console
#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

ColorRGB::ColorRGB(uint8 r, uint8 g, uint8 b)
{
	2[(uint8*)&rgba] = r;
	1[(uint8*)&rgba] = g;
	0[(uint8*)&rgba] = b;
	3[(uint8*)&rgba] = 0xFFU;
}
ColorRGB::ColorRGB(uint8 r, uint8 g, uint8 b, uint8 a)
{
	uint64 n = 0;
	4[(uint8*)&n] = r;
	2[(uint8*)&n] = g;
	0[(uint8*)&n] = b;
	n *= 1U+a;
	0[(uint8*)&rgba] = 1[(uint8*)&n];
	1[(uint8*)&rgba] = 3[(uint8*)&n];
	2[(uint8*)&rgba] = 5[(uint8*)&n];
	3[(uint8*)&rgba] = a;
}
void ColorRGB::FromCOLORREF(COLORREF c) 
{ 
	0[(uint8*)&rgba] = 2[(uint8*)&c];
	1[(uint8*)&rgba] = 1[(uint8*)&c];
	2[(uint8*)&rgba] = 0[(uint8*)&c];
	3[(uint8*)&rgba] = 0xFFU;
}
const COLORREF ColorRGB::ToCOLORREF() const 
{ 
	COLORREF c;
	0[(uint8*)&c] = 2[(uint8*)&rgba];
	1[(uint8*)&c] = 1[(uint8*)&rgba];
	2[(uint8*)&c] = 0[(uint8*)&rgba];
	3[(uint8*)&c] = 0x00U;
	return c;
}	  
bool ColorRGB::From_uint32(uint32 c)
{
	if (uint8(255U) == (3[(uint8*)&rgba] = 3[(uint8*)&c])) // alpha
	{ // if alpha is identity ... then we can simply assign
		rgba = c;
		return false;
	}
	else
	{ // need to premultiply
		uint64 n = 0;
		4[(uint8*)&n] = 2[(uint8*)&c]; // b
		2[(uint8*)&n] = 1[(uint8*)&c]; // g
		0[(uint8*)&n] = 0[(uint8*)&c]; // r
		n *= 1U + 3[(uint8*)&c];  // rgb *= 1+a
		0[(uint8*)&rgba] = 1[(uint8*)&n]; // r/=256
		1[(uint8*)&rgba] = 3[(uint8*)&n]; // g/=256
		2[(uint8*)&rgba] = 5[(uint8*)&n]; // b/=256
		return true;
	}
}

uint8 ColorRGB::Red() const
{
	return 0[(uint8*)&rgba];
}
uint8 ColorRGB::Green() const
{
	return 1[(uint8*)&rgba];
}
uint8 ColorRGB::Blue() const
{
	return 2[(uint8*)&rgba];
}
uint8 ColorRGB::Alpha() const
{
	return 3[(uint8*)&rgba];
}


#if 0
#pragma mark -
#endif

//ToDo make this better
//?? the static global set of string names for each known charset
FontName::Charsets FontName::_charsets;

FontName::FontName()
: fontSize(10)
, boldFont(false)
, italicFont(false)
, underlineFont(false)
, charset(DEFAULT_CHARSET)
{
}

struct _EnumFontData
{
	FontName::Container* container;
	int ypixelsPerPoint;
};

static int CALLBACK _EnumFontFunc(
	ENUMLOGFONTEX *lf,    // logical-font data
	NEWTEXTMETRICEX *pf,  // physical-font data
	DWORD /*ft*/,             // type of font
	LPARAM lParam         // application-defined data
	)
{
	if (pf == 0 || lf == 0)
		return 0;
	// add the charset name to the pool of known charsets
	String& charsetName = FontName::_charsets[lf->elfLogFont.lfCharSet];
	if (charsetName.isEmpty())
		charsetName = String::From_c_str((char*)lf->elfScript);

	_EnumFontData* efdata = (_EnumFontData*)(void*)lParam;
    if (efdata->container->size() >= efdata->container->capacity())
    	efdata->container->reserve(16+ 2*efdata->container->size());

    FontName fnm;
	if (!efdata->container->empty())
		fnm.faceName = efdata->container->back().faceName; // link to previous
	String faceName(String::From_c_str(lf->elfLogFont.lfFaceName));
    if (fnm.faceName != faceName)
    	fnm.faceName = faceName; // only if facename is different
    	
    fnm.charset = lf->elfLogFont.lfCharSet;

	int pixels =  lf->elfLogFont.lfHeight;
	if (pixels < 0) pixels = -pixels;
    fnm.fontSize = (pixels*72 + efdata->ypixelsPerPoint-1)/ efdata->ypixelsPerPoint;

	fnm.boldFont = (lf->elfLogFont.lfWeight >= FW_BOLD);
	fnm.italicFont = (lf->elfLogFont.lfItalic != FALSE);
	fnm.underlineFont = (lf->elfLogFont.lfUnderline != FALSE);
    
    efdata->container->push_back(fnm);
	return 1;
}

void FontName::EnumerateAllInto(FontName::Container& container)
{
	Graphics g;
	LOGFONT lf; 
	lf.lfFaceName[0] = '\0'; // show all facenames, one charset/facename
	lf.lfCharSet = DEFAULT_CHARSET; // show all charsets
	_EnumFontData efdata = 
	{
		&container,
		::GetDeviceCaps(g.GetDC(), LOGPIXELSY)
	};
	::EnumFontFamiliesEx(g.GetDC(), &lf, (FONTENUMPROC)_EnumFontFunc, (LPARAM)(void*)&efdata, 0);
	container.resize(container.size());
}


const String& FontName::GetCharset()
{
	String& charsetName = FontName::_charsets[charset];
	if (charsetName.isEmpty() && (charset != DEFAULT_CHARSET)) 
	{
		// use the enumerator to get the charset name from the os
		FontName::Container container;
		Graphics g;
		LOGFONT lf; 
		std::copy(faceName.c_str(),(const char*)(faceName.end()+1), lf.lfFaceName); 
		lf.lfCharSet = charset;
		_EnumFontData efdata = 
		{
			&container,
			::GetDeviceCaps(g.GetDC(), LOGPIXELSY)
		};
		::EnumFontFamiliesEx(g.GetDC(), &lf, (FONTENUMPROC)_EnumFontFunc, (LPARAM)(void*)&efdata, 0);
		// and search again for the name ... it better be there :-)
		// it it's not return empty string
		charsetName = FontName::_charsets[charset];
	}
	return charsetName;
	
}


TextFont::_Data::_Data()
: refcount(0)
, handle(NULL)
{
	
}

TextFont::_Data::~_Data()
{
	if (handle != NULL)
		::DeleteObject(handle);
	handle = NULL;
}

TextFont::TextFont()
: data(new _Data())
{
	data->handle = static_cast<HFONT>(::GetStockObject(DEFAULT_GUI_FONT));
	VERIFY(data->handle != NULL);

	Graphics g;
	g.SetFont(*this);
	VERIFY(0 != ::GetTextMetrics(g.GetDC(), &data->metric));
	{
		char nm[256];
		nm[0] = 0;
		::GetTextFace(g.GetDC(), sizeof(nm), nm);
		data->faceName = String::From_c_str(nm);
	}
}

TextFont::TextFont(const FontName& fontname)
: data(new _Data())
{
	Graphics g;
	int pixels = ::MulDiv( fontname.fontSize, 
							::GetDeviceCaps(g.GetDC(), LOGPIXELSY), 
							72 );
	data->handle = ::CreateFont(
					  -pixels
					, 0, 0, 0
					, fontname.boldFont ? FW_BOLD : FW_NORMAL
					, fontname.italicFont ? TRUE : FALSE
					, fontname.underlineFont ? TRUE : FALSE
					, FALSE
					, fontname.charset 
					, OUT_DEFAULT_PRECIS
					, CLIP_DEFAULT_PRECIS
					, DEFAULT_QUALITY
					, DEFAULT_PITCH | FF_DONTCARE
					, fontname.faceName.c_str());
	if (data->handle == NULL)
		Exception(XSPMSG(0,"Font '$1;' cannot be loaded"))
			.Param(fontname.ToString())
			.Raise();

	g.SetFont(*this);
	VERIFY(0 != ::GetTextMetrics(g.GetDC(), &data->metric));
	{
		char nm[256];
		nm[0] = 0;
		::GetTextFace(g.GetDC(), sizeof(nm), nm);
		data->faceName = String::From_c_str(nm);
	}
}

const String& TextFont::GetFaceName() const
{
    return data->faceName;
}


sint32 TextFont::GetAscent() const
{
	return data->metric.tmAscent;
}

sint32 TextFont::GetDescent() const
{
	return data->metric.tmDescent;
}

sint32 TextFont::GetHeight() const
{
	return data->metric.tmAscent+data->metric.tmDescent;
}

sint32 TextFont::GetLeading() const
{
	return data->metric.tmExternalLeading;
}

sint32 TextFont::GetMaxCharWidth() const
{
	return data->metric.tmMaxCharWidth;
}

bool   TextFont::IsItalic() const
{
	return data->metric.tmItalic != 0;
}

bool   TextFont::IsUnderline() const
{
	return data->metric.tmUnderlined != 0;
}

bool   TextFont::IsBold() const
{
	return data->metric.tmWeight >= 700;
}

#if 0
#pragma mark -
#endif

OffscreenImage::_Data::_Data()
: refcount(0)
, handle(NULL)
, dc(NULL)
, hasAlpha(false)
{}

OffscreenImage::_Data::~_Data()
{
	if (handle != NULL)
		::DeleteObject(handle);
	handle = NULL;
}

OffscreenImage::OffscreenImage(sint32 u, sint32 v, PixelStyle style)
: data(new _Data())
{
	if (u<0) u=-u;
	if (v<0) v=-v;
	data->z.w = u;
	data->z.h = v;
	data->style = style;
	BITMAPINFOHEADER info;
	info.biSize		    = sizeof(BITMAPINFOHEADER);
	info.biWidth	 	= u;
	info.biHeight	 	= -v;	// win32 BMP is upside down	
	info.biPlanes		= 1;
	switch(style)
	{
	case RGB24:			info.biBitCount = 24; break;
	case RGBA32:		info.biBitCount = 32; break;
	case TrueColor565:  info.biBitCount = 16; break;
	case TrueColor555:  info.biBitCount = 16; break;
	case Index8:		info.biBitCount = 8; break;
	default:
		VERIFY(false);
	};
	info.biCompression	= BI_RGB; // or BI_BITFIELDS
	info.biSizeImage	 = 0; 	  // as long as BI_RGB
	info.biXPelsPerMeter = 0;
	info.biYPelsPerMeter = 0;
	info.biClrUsed		 = 0;
	info.biClrImportant  = 0;
    uint8* memory = 0;
    { 
    	Graphics g; // compatible DC
		data->handle = ::CreateDIBSection( g.GetDC()
							, (BITMAPINFO*) &info
							, (style==Index8) ? DIB_PAL_COLORS : DIB_RGB_COLORS
							, (void**)&memory
							, NULL, 0);
		VERIFY(data->handle != NULL);
    }
    #if DEBUG
		DIBSECTION dbSect; // now get the DIB section's information
		::GetObject(data->handle,sizeof(dbSect),&dbSect);
		ASSERT(memory == (uint8*) dbSect.dsBm.bmBits);
		ASSERT(info.biBitCount == dbSect.dsBmih.biBitCount);
	//  Can't assert height on 'reversed' DIBs
	//	ASSERT(info.biHeight == dbSect.dsBmih.biHeight);
		ASSERT(info.biWidth == dbSect.dsBmih.biWidth);
    #endif
}

Size2D OffscreenImage::GetSize() const
{
	if (data == 0)
		return Size2D(0,0);
	return data->z;
}
bool OffscreenImage::HasAlpha() const
{
	if (data == 0)
		return false;
	return data->hasAlpha;		
}

LockOffscreenImage::LockOffscreenImage(const OffscreenImage& img)
{
	Init(img.data->handle);
}
LockOffscreenImage::LockOffscreenImage(Graphics& g)
{
	Init(g.origimg.data->handle);
}
void LockOffscreenImage::Init(HANDLE handle)
{
	DIBSECTION dbSect; // now get the DIB section's information
	::GetObject(handle,sizeof(dbSect),&dbSect);
	memory = (uint8*) dbSect.dsBm.bmBits;
	rowBytes = dbSect.dsBm.bmWidthBytes;
	bpp = dbSect.dsBm.bmBitsPixel;
	bounds.x = bounds.y = 0;
	bounds.w = dbSect.dsBm.bmWidth;
	bounds.h = dbSect.dsBm.bmHeight;
	if (bounds.h < 0)  // ? negative size in bitmaps
		bounds.h = - bounds.h;
}
LockOffscreenImage::~LockOffscreenImage()
{
	// nothing needs to be unlocked
}

#if 0
#pragma mark -
#endif

Graphics::Graphics()
: hwnd(NULL)
, mode(4)
, savedDC(0)
{
	ps.hdc = ::CreateCompatibleDC(NULL);
	VERIFY(ps.hdc != NULL);
	savedDC = ::SaveDC(ps.hdc);
	_GetOrigin();
}

Graphics::Graphics(HDC dc)
: hwnd(NULL)
, mode(0)
, savedDC(0)
{
	VERIFY(dc != NULL);
	ps.hdc = dc;
	savedDC = ::SaveDC(ps.hdc);
	_GetOrigin();
}

Graphics::Graphics(HWND wnd)
: hwnd(wnd)
, mode(1)
, savedDC(0)
{
	ASSERT(wnd != NULL);
	ps.hdc = ::GetDC(hwnd);
	VERIFY(ps.hdc != NULL);
	savedDC = ::SaveDC(ps.hdc);
	_GetOrigin();
}

Graphics::Graphics(HWND wnd, PAINTSTRUCT*)
: hwnd(wnd)
, mode(2)
, savedDC(0)
{
	ASSERT(wnd != NULL);
	::BeginPaint(hwnd, &ps);
	VERIFY(ps.hdc != NULL);
	savedDC = ::SaveDC(ps.hdc);
	_GetOrigin();

/*	Rect2D updateRect(Point2D(ps.rcPaint.left, ps.rcPaint.top)
					 ,Point2D(ps.rcPaint.right,ps.rcPaint.bottom));
	SetClipRect(GetClipRect().Intersect(updateRect));
*/
}

Graphics::Graphics(const OffscreenImage& img)
: hwnd(NULL)
, mode(3)
, savedDC(0)
, origimg(img)
{
	VERIFY(img.data != 0);
	ps.hdc = img.data->dc;
	if (ps.hdc != NULL)
	{	// this is a secondary Graphics opened on the same image, 
		// act accordingly
		mode = 0;
		savedDC = ::SaveDC(ps.hdc);
		return;
	}
	
	ps.hdc = ::CreateCompatibleDC(NULL);
    VERIFY (ps.hdc != NULL);
	savedDC = ::SaveDC(ps.hdc);

    HBITMAP oldHandle = (HBITMAP)::SelectObject(ps.hdc, img.data->handle);
    VERIFY(oldHandle != NULL);
	// just in case we play with the image while a graphics is open on it
	// we must make sure we use the same graphics for all operations
    img.data->dc = ps.hdc; 
}

Graphics::~Graphics()
{
	if (savedDC != 0)
		::RestoreDC(ps.hdc, savedDC);
//    if (oldHandle != NULL)
  //  	::SelectObject(ps.hdc, oldHandle);
//    oldHandle = NULL;
    		  
    switch (mode)
    {
    case 0:
    	break;
    case 1:
		if (ps.hdc != NULL)
    		::ReleaseDC(hwnd, ps.hdc);
    	break;
    case 2:
 		::EndPaint(hwnd, &ps);
 		break;

    case 3: origimg.data->dc = NULL; // also delete the DC as below
    case 4:	if (ps.hdc != NULL)
				::DeleteDC(ps.hdc);
		break;
	}
	ps.hdc = NULL;
	mode = 0;
}

bool Graphics::IsOffScreen() const
{   
	return  mode == 3; 
}

Rect2D Graphics::GetClipRect() const
{
	RECT r;
	::GetClipBox(ps.hdc, &r);
	return Rect2D(Point2D(r.left, r.top), Point2D(r.right, r.bottom));
}

void Graphics::SetClipRect(const Rect2D& r)
{
	HRGN clipRgn = ::CreateRectRgn(
		origin.x+r.GetWest(), 
		origin.y+r.GetNorth(), 
		origin.x+r.GetEast(), 
		origin.y+r.GetSouth());
	VERIFY(clipRgn != NULL);
	::SelectClipRgn(ps.hdc, clipRgn);
	VERIFY(0 != ::DeleteObject(clipRgn));
}

void Graphics::_GetOrigin()
{
	POINT p;
	::GetViewportOrgEx(ps.hdc, &p);
	origin.x = p.x;
	origin.y = p.y;
}

const Point2D& Graphics::GetOrigin() const
{
	return origin;
}

void Graphics::SetOrigin(const Point2D& p)
{
	origin = p;
	::SetViewportOrgEx(ps.hdc, p.x, p.y, NULL);
}

/*
LockFont::LockFont(Graphics& g, const TextFont& f)
{
	dc = g.GetDC();
	oldFont = ::SelectObject(dc, f.data->handle);
	//::SetBkMode(dc, TRANSPARENT);
}
	
LockFont::~LockFont()
{
   ::SelectObject(dc, oldFont);
}	

*/
void Graphics::SetFont(const TextFont& f)
{
   ::SelectObject(ps.hdc, f.data->handle);
}

uint32 Graphics::MeasureTextWidth(const String& s, const TextFont& f) const
{
	SIZE z;
    ::SelectObject(ps.hdc, f.data->handle);
	::GetTextExtentPoint32(ps.hdc, s.c_str(), s.length(), &z);
	return z.cx;
}

uint32 Graphics::MeasureTextWidth(const char* b, const char* e, const TextFont& f) const
{
	if (b == e)
		return 0;
	SIZE z;
    ::SelectObject(ps.hdc, f.data->handle);
	::GetTextExtentPoint32(ps.hdc, b, e-b, &z);
	return z.cx;
}

void Graphics::MeasureEachCharWidth(const char* b, const char* e, const TextFont& f
								   ,std::vector<uint32> & results ) const
{
	// we add 1 char at the end for the pos of the cursor when at the end of line
	// nothing bad "should" happen since in a C string there is a 0 after the last 
	// char anyway ...
	sint32 len = e-b+1;
	results.resize(len);
	if (b==e)
		return;
	uint32& rr = *results.begin();
    ::SelectObject(ps.hdc, f.data->handle);

    GCP_RESULTS gcp;
    gcp.lStructSize = sizeof(gcp);
    gcp.lpOutString = NULL;
    gcp.lpOrder = NULL;
    gcp.lpDx = NULL;
    gcp.lpCaretPos = (int*)&rr;
    gcp.lpClass = NULL;
    gcp.lpGlyphs = NULL;
    gcp.nGlyphs = len;
    gcp.nMaxFit = 32000;
	DWORD wh = ::GetCharacterPlacement(ps.hdc, b, len, 32000, &gcp, 0);
	VERIFY (wh != 0);
}


void Graphics::DrawText(const String& s, 
						const ColorRGB& c, 
						const TextFont& f, 
						const Point2D& p)
{
	::SetBkMode(ps.hdc, TRANSPARENT);
    ::SelectObject(ps.hdc, f.data->handle);
    ::SetTextColor(ps.hdc, c.ToCOLORREF());
    ::TextOut(ps.hdc, p.x, p.y, s.c_str(), s.length());
}

void Graphics::DrawImage(const OffscreenImage& img, const Rect2D& src, const Rect2D& dst)
{
   Graphics g(img);
   BOOL worked = TRUE;
   if (img.data->hasAlpha) // (img.data->style == OffscreenImage::RGBA32) 
   {
	   BLENDFUNCTION blendParam = {AC_SRC_OVER, 0, 255, 0x01}; //0x01=AC_SRC_ALPHA
   		worked = ::AlphaBlend(ps.hdc, dst.x,dst.y,dst.w,dst.h,
   						   g.ps.hdc, src.x,src.y,dst.w,dst.h, blendParam);
   		if (worked)
   			return;
   }
   if ((src.w == dst.w) && (src.h == dst.h))
   {
   		worked = ::BitBlt( ps.hdc, dst.x,dst.y,dst.w,dst.h, 
   						g.ps.hdc, src.x, src.y, SRCCOPY);
   }
   else
   {
   		::SetStretchBltMode(ps.hdc, COLORONCOLOR);
   		worked = ::StretchBlt( ps.hdc, dst.x,dst.y,dst.w,dst.h,
   							g.ps.hdc, src.x,src.y,src.w,src.h, SRCCOPY);
   		if (worked == FALSE)  // win95 98 patch for large stretch factors (200 or so)
   		{   // (MSFT BUG 111865) must create intermediate image
   			sint32 tolerableFactor = std::min( sint32(65536/4/std::max(1L,dst.w)),
				  							   sint32(dst.h/std::max(1L,src.h)/8) );
			Size2D tmpSize(src.w,src.h*tolerableFactor);
			OffscreenImage tmpBuf(tmpSize.w,tmpSize.h, img.data->style);
			Graphics tg(tmpBuf);
			::SetStretchBltMode(tg.ps.hdc, COLORONCOLOR);
			worked = ::StretchBlt( tg.ps.hdc, 0,0,tmpSize.w,tmpSize.h
							  , g.ps.hdc, src.x,src.y,src.w,src.h, SRCCOPY );
			if (worked != FALSE) // all ok, copy tmp to dst
				worked = ::StretchBlt( ps.hdc, dst.x,dst.y,dst.w,dst.h
								   ,tg.ps.hdc, 0,0, tmpSize.w,tmpSize.h, SRCCOPY);
   		}
   }
   ASSERT(worked != FALSE);
}


void Graphics::FillRect(const ColorRGB& colr, const Rect2D& dst)
{
	RECT r; dst.ConvertToRect(r);
	HBRUSH br = ::CreateSolidBrush(colr.ToCOLORREF()); //(COLORREF) RGB
//	HBRUSH old= ::SelectObject(ps.hdc, br);
   	::FillRect(ps.hdc, &r, br);
   	::DeleteObject(br);
}
void Graphics::DrawLine(const ColorRGB& colr, const Point2D& a, const Point2D& b, uint32 thick)
{
	HPEN pn = ::CreatePen(PS_SOLID, thick, colr.ToCOLORREF()); //(COLORREF)
	HPEN old = (HPEN)::SelectObject(ps.hdc, pn);
   	::MoveToEx(ps.hdc, a.x, a.y, NULL);
   	::LineTo(ps.hdc, b.x, b.y);
    ::SelectObject(ps.hdc, old);
   	::DeleteObject(pn);
}

} // namespace XSP
#endif
