/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{
#if 0
#pragma mark ComboComponentListener
#endif

class ComboComponentListener : public ButtonView::ActionListener
{
	ComboListView* combo;
public:
	ComboComponentListener(ComboListView* v): combo(v) {}
	~ComboComponentListener()	      	   	{ CancelListener(); }
	void CancelListener() {	combo = 0;	super::CancelListener(); }
protected:
	virtual void ActionPerform(ButtonView* button)
	{
		if (combo == 0)
			return;
		combo->ComponentAction(button);
	}
}; // ComboComponentListener

#if 0
#pragma mark ComboSelectionListener
#endif

class ComboSelectionListener : public ListView::SelectionListener
{
	ComboListView* combo;
public:
	ComboSelectionListener(ComboListView* v): combo(v) {}
	~ComboSelectionListener()	      	   	{ CancelListener(); }
	void CancelListener() {	combo = 0;	super::CancelListener(); }
protected:
	virtual void SelectionChanged(const String& text, bool on, ListView* /*lbox*/)
	{
		if (combo == 0)
			return;
		combo->SelectText(on ? text : String::kEmpty);
		combo->ShowDropDown(false);
	}
}; // ComboSelectionListener

#if 0
#pragma mark ComboWindowListener
#endif
class ComboWindowListener : public Window::WindowListener
{
	ComboListView* combo;
public:
	ComboWindowListener(ComboListView* v): combo(v) {}
	~ComboWindowListener()	      	   	{ CancelListener(); }
	void CancelListener() {	combo = 0;	super::CancelListener(); }
protected:
	virtual void Closed(Window&)
	{}
	virtual void BoundsChanged(Window&)
	{}
	virtual void Activated(Window&, bool on)
	{
		if (on)
			return;
		if (combo == 0)
			return;
		// window deactivated ... we must close it
		combo->ShowDropDown(false);
	}
}; // ComboWindowListener



ComboListView::ComboListView()
{
	content = new TextView();
	AddView(content);
	content->SetSingleLineMode();

    activateDrop = new ButtonView();
	AddView(activateDrop);
	activateDrop->StateSetReset(0,StateFocusable);
	ComboComponentListener* ccl = new ComboComponentListener(this);
	activateDrop->AddActionListener(ccl);

    theList = new ListView();
    theList->AddSelectionListener(new ComboSelectionListener(this));
    // theList is not added to this view , instead 
    // it will be dropped into a window of it's own
}

ComboListView::~ComboListView()
{
}

void ComboListView::DemoPopulate()
{
	theList->DemoPopulate();
	SelectText(String::From_c_str("Select something"));
}

void ComboListView::SetSkin(const ViewSkin::owner& skin)
{
	View::SetSkin(skin);
	content->SetSkin(GetSkinPartOrDefault(String::From_c_str("Content")));
	activateDrop->SetSkin(GetSkinPartOrDefault(String::From_c_str("Activate")));
	theList->SetSkin(GetSkinPartOrDefault(String::From_c_str("List")));
	PositionComponents(); // because of content rectangle change
}

void ComboListView::SetFont(const TextFont& f)
{	
	View::SetFont(f);
	content->SetFont(f);
	theList->SetFont(f);
	PositionComponents(); 
}

void ComboListView::SetBounds(const Rect2D& bounds)
{
	Rect2D oldBounds(GetBounds());
	if (bounds == oldBounds)
		return;
	View::SetBounds(bounds);
	PositionComponents();
}

void ComboListView::PositionComponents()
{
	Rect2D ctB(GetSkinContentBounds());
	Rect2D adB(ctB); 
	adB.x += adB.w;
	adB.w  =  (adB.h>12) ? adB.h-4 : adB.h;
	adB.x -= adB.w;
	if (adB.x < ctB.x)
		adB.x = ctB.x;
	ctB.w = std::max(0L, adB.x-ctB.x);
	
	activateDrop->SetBounds(adB);
	content->SetBounds(ctB);
}

bool ComboListView::HasText(const String& text)
{
	return theList->HasText(text);
}

void ComboListView::AddText(const String& text)
{
	theList->AddText(text);
}

void ComboListView::RemoveText(const String& text)
{
	theList->RemoveText(text);
}

void ComboListView::SelectText(const String& text)
{
	content->SetText(text);
	content->Action_LineBegin();
	theList->SelectText(text,true);
	content->Refresh();
}

String ComboListView::GetSelectedText()
{
	return content->GetText();
}

bool ComboListView::IsShowingDropDown()
{
	return (dropDown != 0) && !dropDown.IsClosed();
}

void ComboListView::ShowDropDown(bool on)
{
	bool showing = IsShowingDropDown();
	if (on == showing)
		return;
	if (!on)
	{   //??
		Window tmp = dropDown;
		dropDown = 0;
		//?? remove from the parent so the deletion of 
		// the window won't kill the list
		theList->GetParent()->RemoveView(theList.operator->());
		//??
		theList->CancelListenToScrollNotifications();
		tmp.Close();
		return;
	}
	// the window with the drop down needs to be created
	Window w = GetParentWindow();
	if (w == 0)
		return;

	WinMgr& wmgr = w.GetWinMgr();
	Rect2D ddBounds(theList->GetPreferredSize());  // desired bounds for drop down
	bool useScroll = false;
	{
		Rect2D scB(wmgr.GetScreenBounds());	 	   // total screen bounds
		Rect2D thB(GetVisibleBoundsOnScreen());    // our bounds on screen
		
		if (ddBounds.w < thB.w)
			ddBounds.w = thB.w;
		if (ddBounds.w > scB.w/3)
		{
			ddBounds.w = scB.w/3;
			useScroll = true;
		}
		if (ddBounds.h > scB.h/3)
		{
			ddBounds.h = scB.h/3;
			useScroll = true;
		}

		// try place it under the this
		ddBounds.y = thB.y+thB.h;
		if (ddBounds.y+ddBounds.h > scB.y+scB.h)
		{
			ddBounds.y = thB.y-ddBounds.h;
			if (ddBounds.y < scB.y) // will not fit above either
				ddBounds.y = scB.y+scB.h -ddBounds.h; // partial overlap at the bottom of this
			if (ddBounds.y < scB.y) 
				ddBounds.y = scB.y;
		}

		ddBounds.x = std::max(thB.x, scB.x);
		if (ddBounds.x+ddBounds.w > scB.x+scB.w)
		{
			ddBounds.x = scB.x+scB.w - ddBounds.w;
			if (ddBounds.x < scB.x) 
				ddBounds.x = scB.x;
		}
    }
	dropDown = w.DropDownChild();
	dropDown.SetBounds(ddBounds);
	if (useScroll)// at the list directly or within a scrollpage?
	{
		ScrollPage* page = new ScrollPage();
		dropDown.AddView(page);
		page->SetSkin(GetSkinPartOrDefault(String::From_c_str("ScrollPage"))); // for the scrollbars
		page->SetContent(theList.operator->());
		page->SetBounds(Rect2D(ddBounds.GetSize())); //w.GetContentBounds
	}
	else
	{  
		dropDown.AddView(theList.operator->());
		theList->SetBounds(Rect2D(ddBounds.GetSize()));
	}
	theList->ShowSelection();
	dropDown.GetContent()->SetFocusable(true);
	dropDown.AddListener(new ComboWindowListener(this));
	dropDown.Show(true);
	dropDown.GetContent()->ActionFocusFirstChild();
}

void ComboListView::ComponentAction(ButtonView* component)
{
	if (component == activateDrop)
	{
		bool showing = IsShowingDropDown();
		if (! showing) // focus me and then show the dropdown
			SetFocused();
		ComboListView::ShowDropDown(!showing);
	}
}

bool ComboListView::HandleKeyEvent( const UIEvent& ev )
{
	if ((ev.origin == UIEvent::KeyDown) && 
		(ev.code == VK_F4) && 
		(0 == (ev.modifiers & UIEvent::KModifMask)))
	{   // we react to enter, the button by default reacts only to space
		bool showing = IsShowingDropDown();
		ComboListView::ShowDropDown(!showing);
		return true;
	}
	return View::HandleKeyEvent(ev);
}

} // namespace XSP
