/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

#if 0
#pragma mark WinMgr
#endif

class WinMgr
{
public:
	class _Data;
	refc<_Data> data;
	class EventProcessor;
	
	void ProcessEvents();
	void RequestEvents(bool imediate);
	void CheckMouseStatus();
public:
	WinMgr();
	~WinMgr();
	WinMgr(const WinMgr& t);
	WinMgr& operator = (const WinMgr& t);
	WinMgr(_Data* data);

    bool operator == (const WinMgr& t) const;
    bool operator != (const WinMgr& t) const;
    bool operator == (_Data* const t) const;
    bool operator != (_Data* const t) const;

	uint32 GetWindowCount() const;
	const ViewSkin::owner& GetSysSkin();
	Window GetActiveWindow();
    Rect2D GetScreenBounds();
    
private:
	class _Listener
	{
	public:
		virtual void SettingsChanged() {}
		virtual void ShutdownRequested() {}
	};
public:	
	typedef ListenerOf<_Listener> Listener;
	typedef Listener::Container Listeners;
	void AddListener(const Listener::owner& l);

public:
	#if TARGET_API_Win32 || TARGET_API_Win32_Console
		static LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, 
										WPARAM wp, LPARAM lp);
		void ThreadProc(const MSG& msg);
    #endif
public:
	static void RunUnitTest();

}; // class WinMgr


// event that when run processes GUI events for this winMgr
class WinMgr::EventProcessor : public Event_Abstract
{
private:
	// no ownership of the winMgr,
	// we are managed by the winMgr
	WinMgr::_Data* winMgrData;
public:
	EventProcessor(WinMgr::_Data* winMgrData);
	void Run();		
	void Cancel();		
}; // class EventProcessor

#if 0
#pragma mark Window
#endif

class Window
{
public:
	class _Data;
	refc<_Data> data;
public:	
	Window();
	~Window();
	Window(const Window& t);
	Window(_Data* t);
	Window& operator = (const Window& t);
	Window& operator = (const Window* t);

    bool operator == (const Window& t) const;
    bool operator != (const Window& t) const;
    bool operator == (const Window* t) const;
    bool operator != (const Window* t) const;

public:
	Window(const WinMgr& winMgr);
	Window PopupChild() const;
	Window DropDownChild() const;
	Window PopupDialog() const;

	void Close();
	bool IsClosed() const;

public:
	WinMgr& GetWinMgr();
	void Show(bool on);
	bool IsVisible() const;
	bool IsMinimized() const;
	bool IsMaximized() const;
	enum MaximizeMode { MaximizeStandard, MaximizeFullScreen, MaximizeFullMultiScreen };
	void SetMaximizeMode(MaximizeMode mode);
    void Maximize();
    void Minimize();
    void RestoreSize();
//	void ShowFullScreen(bool on);
	void BringToFront();
	bool IsActive() const;
	void SetParent(const Window& p);
	void SetTitle(const String& title);
	String GetTitle() const;
	void SetBounds(const Rect2D& bounds);  // bounds on screen
	void SetContentBoundsOnScreen(const Rect2D& bounds); // client area inside screen
	Rect2D GetBounds() const;			   // bounds on screen
	Size2D GetContentSize() const;		   // size of the client area
	Rect2D GetContentBounds() const;	   // client area inside frame
	Rect2D GetContentBoundsOnScreen() const;	   // client area inside screen
	void Refresh();
	void Refresh(const Rect2D& r);

	void SetMouseCursor(MouseCursor& curs);
	
	void SetBgStyle(BackgroundView::Style s);
	void AddView(const View::owner& view);
	View::owner GetContent();
public:
	#if TARGET_API_Win32 || TARGET_API_Win32_Console
		// turn window into frameless (unmanaged X window)
		void ShowFrame(bool on); 
    #endif

public:
	bool PasteFromClipboard(DragDropType::TypeSet& availableTypes, 
							bool 				   onlySimulate,
							DragDropType::FatData& theFatData );
	bool CopyToClipboard(DragDropType::TypeSet& availableTypes, 
						   DragDropType::FatData& theFatData );
	
private:
	class _WindowChange
	{
	public:
		virtual void Closed(Window& w);
		virtual void BoundsChanged(Window& w);
		virtual void Activated(Window& w, bool on);
	};
public:	
	typedef ListenerOf<_WindowChange> WindowListener;
	typedef WindowListener::Container WindowListeners;
	void AddListener(const WindowListener::owner& l);
	void SetWindowClosesApp();
	
}; // class Window

#if 0
#pragma mark WinMgr::_Data
#endif

class WinMgr::_Data
{
private:
	uint32 refcount;
public:
#if TARGET_API_Win32 || TARGET_API_Win32_Console
	ATOM wndClassAtom; // used to create new windows
	HINSTANCE moduleInstance;
    // the collection of windows managed by this winMgr
	typedef std::map<HWND, Window> WindowPool;
	WindowPool windowPool;
	bool usedLastChar;
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
	// ToDo
#elif TARGET_API_Darwin || TARGET_API_Linux
	// ToDo
#endif

public:
	// holds the event that collects GUI events when run
	refc<XSP::Event_Abstract> processEvents;
	// holds the listeners to the winMgr events
	Listeners winMgrListeners;
	// cache the system default skins here
	ViewSkin::owner sysSkin;
	// who captured the mouse
	View::owner mouseCaptureView;
	Size2D	    mouseCaptureOriginDelta;
	// for multimonitor configuration 
	Size2D 		fullVirtualSize; 

	// who was most recently hovered
	View::owner oldHoveredView;
	// who is focused
	View::owner keyFocusView;
	
	MouseCursor arrowCursor;
	MouseCursor textCursor;
	MouseCursor grabCursor;
	
public:
	_Data();
	~_Data();
	void addref() { ++refcount; }
	void release() { if (--refcount == 0) delete this; }
}; // class WinMgr::Data

#if 0
#pragma mark Window::_Data
#endif

class DropTargetWin32;
class Window::_Data : public BackgroundView
{
public:
	_Data(const WinMgr& winMgr);
protected:
	~_Data();
public:
	void Close();

public:
	WinMgr winMgr;
	WindowListeners listeners;
	Rect2D caretRect;
	MaximizeMode maxMode;
	
#if TARGET_API_Win32 || TARGET_API_Win32_Console
	HWND hwnd;
//	MINMAXINFO* minmaxInfo; // used during fullscreen mode
	DropTargetWin32* dropTarget; // used for OLE drag & drop interfacing

	void Init(HWND parent, DWORD af, DWORD ef);
	void ProcPAINT(UINT msg, WPARAM wp, LPARAM lp);
	void ProcGETMINMAXINFO(UINT msg, WPARAM wp, LPARAM lp);
	void ProcDESTROY(UINT msg, WPARAM wp, LPARAM lp);
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0

#elif TARGET_API_Darwin || TARGET_API_Linux

#endif

public: // from OS
	void WindowPaint(Graphics& g, const Rect2D& area);
	void WindowClosed();
	void WindowBoundsChanged();
	void WindowActivated( bool on );
	void WindowFocused( bool on );
	void WindowMouseEvent(UIEvent& ev);
	bool WindowKeyEvent(UIEvent& ev);
	void WindowCaptureMouseBreak();
	void WindowDropEvent( DragDropType::TypeSet& availableTypes, 
						  DragDropType::Effect&  effect,
						  POINTL* 			     screenPoint,
						  bool 					 onlySimulate,
						  DragDropType::FatData& theFatData );

public: // View overrides
	virtual Window GetParentWindow();
	virtual Rect2D GetVisibleBoundsOnScreen();
	virtual void Refresh(const Rect2D& r);
	virtual void StartMouseCapture(const View::owner& view, const Point2D& origin);
	virtual void EndMouseCapture(const View::owner& view);
	virtual void SetCaret(const Rect2D& r); 

}; // class Window::_Data

#if 0
#pragma mark DropTargetWin32
#endif

#if TARGET_API_Win32 || TARGET_API_Win32_Console
class DropTargetWin32 : public IDropTarget
{
	uint32 refcount;      // ole refcount 
	Window::_Data* wData; // we are owned by wData, we do not own it
	DragDropType::TypeSet whatSourceCanDrop;
protected:
	virtual ~DropTargetWin32();

public:
	DropTargetWin32(Window::_Data* wd);

public: // IUnknown
    virtual HRESULT STDMETHODCALLTYPE QueryInterface( 
        REFIID riid,
        void __RPC_FAR *__RPC_FAR *ppvObject);
    virtual ULONG STDMETHODCALLTYPE AddRef();
    virtual ULONG STDMETHODCALLTYPE Release();

protected: // IDropTarget
    virtual HRESULT STDMETHODCALLTYPE DragEnter( 
        /* [unique][in] */ IDataObject __RPC_FAR *pDataObj,
        /* [in] */ DWORD grfKeyState,
        /* [in] */ POINTL screenPoint,
        /* [out][in] */ DWORD __RPC_FAR *pdwEffect);
    virtual HRESULT STDMETHODCALLTYPE DragOver( 
        /* [in] */ DWORD grfKeyState,
        /* [in] */ POINTL screenPoint,
        /* [out][in] */ DWORD __RPC_FAR *pdwEffect);
    virtual HRESULT STDMETHODCALLTYPE DragLeave( );
    virtual HRESULT STDMETHODCALLTYPE Drop( 
        /* [unique][in] */ IDataObject __RPC_FAR *pDataObj,
        /* [in] */ DWORD grfKeyState,
        /* [in] */ POINTL screenPoint,
        /* [out][in] */ DWORD __RPC_FAR *pdwEffect);

private:
   	static void DetermineWhatSourceCanDrop(IDataObject &cargo, 
   										   DragDropType::TypeSet& whatDrop);
	void DoTheDrop( IDataObject 			*cargo,
					DragDropType::TypeSet& availableTypes, 
				    DragDropType::Effect&  effect,
				    POINTL*		 		   screenPoint);
	bool FillFatData( DragDropType::TypeID tid, 
					  DragDropType::FatData& fatData,
					  IDataObject& cargo );
	bool FillFatData_Text_Plain(IDataObject& cargo,
					  DragDropType::FatData& fatData );
	bool FillFatData_FileName(IDataObject& cargo,
			  	      DragDropType::FatData& fatData );
	bool FillFatData_Image_Native(IDataObject& cargo,
					  DragDropType::FatData& fatData );
    #if DEBUG
		static void ScanData_Test(IDataObject& cargo);
		static void FillData_Test(CLIPFORMAT f, IDataObject& cargo);
	#endif
}; // class DropTargetWin32
#endif

#if 0
#pragma mark DropTargetWin32
#endif

#if TARGET_API_Win32 || TARGET_API_Win32_Console
class DragSourceWin32;
#endif

class DragSource
{
	#if TARGET_API_Win32 || TARGET_API_Win32_Console
		DragSourceWin32* _data;
	#endif

public:
	DragSource();	
	~DragSource();	
	void Set( DragDropType::FatData&  fatData, DragDropType::TypeSet& typeset);
	void DoDND(DragDropType::Effect& effect);
};


} // namespace XSP
