/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

/* This is a  dialog actually with 3 basic components,
a text view , a button to launch the dropdown, 
a list in a drop down window for the quick selection
1) read only, just select one of the listbox fields
2) editable, can type in a new line, return selects and automatically appends to list
3) editable but list stays read only
*/
class ComboListView : public View
{
    TextView* 	 content;
    ButtonView*  activateDrop;
    Window		 dropDown;
    refc<ListView>	 theList; // we keep it even while the window is closed
public:
    ComboListView();
public:
	bool HasText(const String& text);
	void AddText(const String& text);
	void RemoveText(const String& text);

	void SelectText(const String& text);
	String GetSelectedText();

	bool IsShowingDropDown();
	void ShowDropDown(bool on);
	const refc<ListView>& GetDropDown() { return theList; }

    void AddSelectionListener(const ListView::SelectionListener::owner& l)
    { theList->AddSelectionListener(l); }
    
	void DemoPopulate();
public:
	virtual void SetSkin(const ViewSkin::owner& skin);
	virtual void SetFont(const TextFont& f);
	virtual void SetBounds(const Rect2D& bounds);
	virtual bool HandleKeyEvent( const UIEvent& ev );

    void PositionComponents();
	void ComponentAction(ButtonView* component);

protected:
    virtual ~ComboListView();
}; // class ComboListView

} // namespace XSP
