/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

class ButtonView : public View
{
	AlignedText tData;
//	bool style3State;
	bool styleAutoRepeat;
	uint32 hotKeyCode;
public:
	enum { 
			StateDefaultButton = ViewStateMask+1 // for default button
		 ,	StateHas3RD = StateDefaultButton<<1 // make this a 3 state button
		 ,	State3RD = StateHas3RD<<1 // this makes it a checked 3 state
		 ,	StateDragged = State3RD<<1 
		 ,	StateDragable = StateDragged<<1 

		 ,  ButtonMask =  (StateDragable<<1)-1
		 };
public:
	ButtonView();
	~ButtonView();
	
	void SetText(const String& text);
	const String& GetText() const;
	void SetFont(const TextFont& t);
	void SetTextColor(const ColorRGB& t);
	void SetTextAlign( Rect2D::Alignment al
					 , Rect2D::Alignment ov );
	// make this button the default button 
	// it will look slightly different and also it will be
	// capable of absorbing the VK_RETURN HotKey
	void SetDefaultButton(bool on);
	inline bool IsDefaultButton() const { return (0 != (GetState() & StateDefaultButton)); }

	void Set3StateButton(bool on);
	inline bool Is3StateButton() const { return (0 != (GetState() & StateHas3RD)); }
    void SetChecked(bool on);
	inline bool IsChecked() const { return (0 != (GetState() & State3RD)); }

	inline bool IsDraggable() const { return (0 != (GetState() & StateDragable)); }
	inline bool IsDragged() const { return (0 != (GetState() & StateDragged)); }

	inline bool IsAutoRepeat() const { return styleAutoRepeat; }
	void SetAutoRepeatButton(bool on);

	virtual Size2D GetPreferredSize();

protected:
	virtual void Draw(Graphics& g, const Rect2D& area);
	virtual bool HandleMouseEvent( const UIEvent& ev );
	virtual bool HandleKeyEvent( const UIEvent& ev );

public:
	class _Action
	{
	public:
		virtual void ActionPerform(ButtonView* button)=0;
	}; // class _Action
	typedef ListenerOf<_Action> ActionListener;
	typedef ActionListener::Container ActionListeners;
	ActionListeners actionListeners;
    void AddActionListener(const ActionListener::owner& l);

	bool ActionFireButton();	
};

} // namespace XSP
