/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr14-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"

namespace XSP
{
#if TARGET_API_Win32 || TARGET_API_Win32_Console

static void _WinFS_Fail(const FileName& fn)
{
    int err = ::GetLastError();
	if (err == ERROR_SUCCESS)
		return;

	uint32 ern = 0;
	switch(err)
	{
	case ERROR_INVALID_FUNCTION: ern=XSPMSG(175,"Incorrect function."); break; 
	case ERROR_FILE_NOT_FOUND: ern=XSPMSG(176,"The system cannot find the file '$1;'."); break; 
	case ERROR_PATH_NOT_FOUND: ern=XSPMSG(177,"The system cannot find the path '$1;'."); break; 
	case ERROR_TOO_MANY_OPEN_FILES: ern=XSPMSG(178,"Too many opened files, the system cannot open the file '$1;'."); break; 
	case ERROR_ACCESS_DENIED: ern=XSPMSG(179,"Access is denied to file'$1;'."); break; 
	case ERROR_INVALID_HANDLE: ern=XSPMSG(180,"The handle is invalid."); break; 
	case ERROR_ARENA_TRASHED: ern=XSPMSG(181,"The storage control blocks were destroyed."); break; 
	case ERROR_NOT_ENOUGH_MEMORY: ern=XSPMSG(182,"Not enough storage is available to process this command."); break; 
	case ERROR_INVALID_BLOCK: ern=XSPMSG(183,"The storage control block address is invalid."); break; 
	case ERROR_BAD_ENVIRONMENT: ern=XSPMSG(184,"The environment is incorrect."); break; 
	case ERROR_BAD_FORMAT: ern=XSPMSG(185,"An attempt was made to load a program with an incorrect format."); break; 
	case ERROR_INVALID_ACCESS: ern=XSPMSG(186,"The access code is invalid."); break; 
	case ERROR_INVALID_DATA: ern=XSPMSG(187,"The data is invalid."); break; 
	case ERROR_OUTOFMEMORY: ern=XSPMSG(188,"Not enough storage is available to complete this operation."); break; 
	case ERROR_INVALID_DRIVE: ern=XSPMSG(189,"The system cannot find the drive specified."); break; 
	case ERROR_CURRENT_DIRECTORY: ern=XSPMSG(190,"The directory cannot be removed."); break; 
	case ERROR_NOT_SAME_DEVICE: ern=XSPMSG(191,"The system cannot move the file to a different disk drive."); break; 
	case ERROR_NO_MORE_FILES: ern=XSPMSG(192,"There are no more files."); break; 
	case ERROR_WRITE_PROTECT: ern=XSPMSG(193,"The media is write protected."); break; 
	case ERROR_BAD_UNIT: ern=XSPMSG(194,"The system cannot find the device specified."); break; 
	case ERROR_NOT_READY: ern=XSPMSG(195,"The device is not ready."); break; 
	case ERROR_BAD_COMMAND: ern=XSPMSG(196,"The device does not recognize the command."); break; 
	case ERROR_CRC: ern=XSPMSG(197,"Data error (cyclic redundancy check)."); break; 
	case ERROR_BAD_LENGTH: ern=XSPMSG(198,"The program issued a command but the command length is incorrect."); break; 
	case ERROR_SEEK: ern=XSPMSG(199,"The drive cannot locate a specific area or track on the disk."); break; 
	case ERROR_NOT_DOS_DISK: ern=XSPMSG(200,"The specified disk or diskette cannot be accessed."); break; 
	case ERROR_SECTOR_NOT_FOUND: ern=XSPMSG(201,"The drive cannot find the sector requested."); break; 
	case ERROR_OUT_OF_PAPER: ern=XSPMSG(202,"The printer is out of paper."); break; 
	case ERROR_WRITE_FAULT: ern=XSPMSG(203,"The system cannot write to the specified device."); break; 
	case ERROR_READ_FAULT: ern=XSPMSG(204,"The system cannot read from the specified device."); break; 
	case ERROR_GEN_FAILURE: ern=XSPMSG(205,"A device attached to the system is not functioning."); break; 
	case ERROR_SHARING_VIOLATION: ern=XSPMSG(206,"The process cannot access the file because it is being used by another process."); break; 
	case ERROR_LOCK_VIOLATION: ern=XSPMSG(207,"The process cannot access the file because another process has locked a portion of the file."); break; 
	case ERROR_WRONG_DISK: ern=XSPMSG(104,"The wrong diskette is in the drive."); break; 
	case ERROR_SHARING_BUFFER_EXCEEDED: ern=XSPMSG(208,"Too many files opened for sharing."); break; 
	case ERROR_HANDLE_EOF: ern=XSPMSG(209,"Reached the end of the file."); break; 
	case ERROR_HANDLE_DISK_FULL: ern=XSPMSG(210,"The disk is full."); break; 
	case ERROR_NOT_SUPPORTED: ern=XSPMSG(211,"The request is not supported."); break; 
	case ERROR_REM_NOT_LIST: ern=XSPMSG(212,"Windows cannot find the network path. Verify that the network path is correct and the destination computer is not busy or turned off. If Windows still cannot find the network path, contact your network administrator."); break; 
	case ERROR_DUP_NAME: ern=XSPMSG(213,"You were not connected because a duplicate name exists on the network. Go to System in the Control Panel to change the computer name and try again."); break; 
	case ERROR_BAD_NETPATH: ern=XSPMSG(214,"The network path was not found."); break; 
	case ERROR_NETWORK_BUSY: ern=XSPMSG(215,"The network is busy."); break; 
	case ERROR_DEV_NOT_EXIST: ern=XSPMSG(216,"The specified network resource or device is no longer available."); break; 
	case ERROR_TOO_MANY_CMDS: ern=XSPMSG(217,"The network BIOS command limit has been reached."); break; 
	case ERROR_ADAP_HDW_ERR: ern=XSPMSG(218,"A network adapter hardware error occurred."); break; 
	case ERROR_BAD_NET_RESP: ern=XSPMSG(219,"The specified server cannot perform the requested operation."); break; 
	case ERROR_UNEXP_NET_ERR: ern=XSPMSG(220,"An unexpected network error occurred."); break; 
	case ERROR_BAD_REM_ADAP: ern=XSPMSG(221,"The remote adapter is not compatible."); break; 
	case ERROR_PRINTQ_FULL: ern=XSPMSG(222,"The printer queue is full."); break; 
	case ERROR_NO_SPOOL_SPACE: ern=XSPMSG(223,"Space to store the file waiting to be printed is not available on the server."); break; 
	case ERROR_PRINT_CANCELLED: ern=XSPMSG(224,"Your file waiting to be printed was deleted."); break; 
	case ERROR_NETNAME_DELETED: ern=XSPMSG(225,"The specified network name is no longer available."); break; 
	case ERROR_NETWORK_ACCESS_DENIED: ern=XSPMSG(226,"Network access is denied."); break; 
	case ERROR_BAD_DEV_TYPE: ern=XSPMSG(227,"The network resource type is not correct."); break; 
	case ERROR_BAD_NET_NAME: ern=XSPMSG(228,"The network name cannot be found."); break; 
	case ERROR_TOO_MANY_NAMES: ern=XSPMSG(229,"The name limit for the local computer network adapter card was exceeded."); break; 
	case ERROR_TOO_MANY_SESS: ern=XSPMSG(230,"The network BIOS session limit was exceeded."); break; 
	case ERROR_SHARING_PAUSED: ern=XSPMSG(231,"The remote server has been paused or is in the process of being started."); break; 
	case ERROR_REQ_NOT_ACCEP: ern=XSPMSG(232,"No more connections can be made to this remote computer at this time because there are already as many connections as the computer can accept."); break; 
	case ERROR_REDIR_PAUSED: ern=XSPMSG(233,"The specified printer or disk device has been paused."); break; 
	case ERROR_FILE_EXISTS: ern=XSPMSG(234,"The file exists."); break; 
	case ERROR_CANNOT_MAKE: ern=XSPMSG(235,"The directory or file cannot be created."); break; 
	case ERROR_FAIL_I24: ern=XSPMSG(236,"Fail on INT 24."); break; 
	case ERROR_OUT_OF_STRUCTURES: ern=XSPMSG(237,"Storage to process this request is not available."); break; 
	case ERROR_ALREADY_ASSIGNED: ern=XSPMSG(238,"The local device name is already in use."); break; 
	case ERROR_INVALID_PASSWORD: ern=XSPMSG(239,"The specified network password is not correct."); break; 
	case ERROR_INVALID_PARAMETER: ern=XSPMSG(240,"The parameter is incorrect."); break; 
	case ERROR_NET_WRITE_FAULT: ern=XSPMSG(241,"A write fault occurred on the network."); break; 
	case ERROR_NO_PROC_SLOTS: ern=XSPMSG(242,"The system cannot start another process at this time."); break; 
	case ERROR_TOO_MANY_SEMAPHORES: ern=XSPMSG(243,"Cannot create another system semaphore."); break; 
	case ERROR_EXCL_SEM_ALREADY_OWNED: ern=XSPMSG(244,"The exclusive semaphore is owned by another process."); break; 
	case ERROR_SEM_IS_SET: ern=XSPMSG(245,"The semaphore is set and cannot be closed."); break; 
	case ERROR_TOO_MANY_SEM_REQUESTS: ern=XSPMSG(246,"The semaphore cannot be set again."); break; 
	case ERROR_INVALID_AT_INTERRUPT_TIME: ern=XSPMSG(247,"Cannot request exclusive semaphores at interrupt time."); break; 
	case ERROR_SEM_OWNER_DIED: ern=XSPMSG(248,"The previous ownership of this semaphore has ended."); break; 
	case ERROR_SEM_USER_LIMIT: ern=XSPMSG(249,"Insert the diskette for drive %1."); break; 
	case ERROR_DISK_CHANGE: ern=XSPMSG(250,"The program stopped because an alternate diskette was not inserted."); break; 
	case ERROR_DRIVE_LOCKED: ern=XSPMSG(251,"The disk is in use or locked by another process."); break; 
	case ERROR_BROKEN_PIPE: ern=XSPMSG(252,"The pipe has been ended."); break; 
	case ERROR_OPEN_FAILED: ern=XSPMSG(253,"The system cannot open the device or file specified."); break; 
	case ERROR_BUFFER_OVERFLOW: ern=XSPMSG(254,"The file name is too long."); break; 
	case ERROR_DISK_FULL: ern=XSPMSG(255,"There is not enough space on the disk."); break; 
	case ERROR_NO_MORE_SEARCH_HANDLES: ern=XSPMSG(256,"No more internal file identifiers available."); break; 
	case ERROR_INVALID_TARGET_HANDLE: ern=XSPMSG(257,"The target internal file identifier is incorrect."); break; 
	case ERROR_INVALID_CATEGORY: ern=XSPMSG(258,"The IOCTL call made by the application program is not correct."); break; 
	case ERROR_INVALID_VERIFY_SWITCH: ern=XSPMSG(259,"The verify-on-write switch parameter value is not correct."); break; 
	case ERROR_BAD_DRIVER_LEVEL: ern=XSPMSG(260,"The system does not support the command requested."); break; 
	case ERROR_CALL_NOT_IMPLEMENTED: ern=XSPMSG(261,"This function is not supported on this system."); break; 
	case ERROR_SEM_TIMEOUT: ern=XSPMSG(262,"The semaphore timeout period has expired."); break; 
	case ERROR_INSUFFICIENT_BUFFER: ern=XSPMSG(263,"The data area passed to a system call is too small."); break; 
	case ERROR_INVALID_NAME: ern=XSPMSG(264,"The filename, directory name, or volume label syntax is incorrect."); break; 
	case ERROR_INVALID_LEVEL: ern=XSPMSG(265,"The system call level is not correct."); break; 
	case ERROR_NO_VOLUME_LABEL: ern=XSPMSG(266,"The disk has no volume label."); break; 
	case ERROR_MOD_NOT_FOUND: ern=XSPMSG(267,"The specified module could not be found."); break; 
	case ERROR_PROC_NOT_FOUND: ern=XSPMSG(268,"The specified procedure could not be found."); break; 
	case ERROR_WAIT_NO_CHILDREN: ern=XSPMSG(269,"There are no child processes to wait for."); break; 
	case ERROR_CHILD_NOT_COMPLETE: ern=XSPMSG(270,"The %1 application cannot be run in Win32 mode."); break; 
	case ERROR_DIRECT_ACCESS_HANDLE: ern=XSPMSG(341,"Attempt to use a file handle to an open disk partition for an operation other than raw disk I/O."); break; 
	case ERROR_NEGATIVE_SEEK: ern=XSPMSG(344,"An attempt was made to move the file pointer before the beginning of the file."); break; 
	case ERROR_SEEK_ON_DEVICE: ern=XSPMSG(345,"The file pointer cannot be set on the specified device or file."); break; 
	case ERROR_IS_JOIN_TARGET: ern=XSPMSG(346,"A JOIN or SUBST command cannot be used for a drive that contains previously joined drives."); break; 
	case ERROR_IS_JOINED: ern=XSPMSG(347,"An attempt was made to use a JOIN or SUBST command on a drive that has already been joined."); break; 
	case ERROR_IS_SUBSTED: ern=XSPMSG(348,"An attempt was made to use a JOIN or SUBST command on a drive that has already been substituted."); break; 
	case ERROR_NOT_JOINED: ern=XSPMSG(349,"The system tried to delete the JOIN of a drive that is not joined."); break; 
	case ERROR_NOT_SUBSTED: ern=XSPMSG(350,"The system tried to delete the substitution of a drive that is not substituted."); break; 
	case ERROR_JOIN_TO_JOIN: ern=XSPMSG(351,"The system tried to join a drive to a directory on a joined drive."); break; 
	case ERROR_SUBST_TO_SUBST: ern=XSPMSG(352,"The system tried to substitute a drive to a directory on a substituted drive."); break; 
	case ERROR_JOIN_TO_SUBST: ern=XSPMSG(353,"The system tried to join a drive to a directory on a substituted drive."); break; 
	case ERROR_SUBST_TO_JOIN: ern=XSPMSG(354,"The system tried to SUBST a drive to a directory on a joined drive."); break; 
	case ERROR_BUSY_DRIVE: ern=XSPMSG(355,"The system cannot perform a JOIN or SUBST at this time."); break; 
	case ERROR_SAME_DRIVE: ern=XSPMSG(356,"The system cannot join or substitute a drive to or for a directory on the same drive."); break; 
	case ERROR_DIR_NOT_ROOT: ern=XSPMSG(357,"The directory is not a subdirectory of the root directory."); break; 
	case ERROR_DIR_NOT_EMPTY: ern=XSPMSG(358,"The directory is not empty."); break; 
	case ERROR_IS_SUBST_PATH: ern=XSPMSG(359,"The path specified is being used in a substitute."); break; 
	case ERROR_IS_JOIN_PATH: ern=XSPMSG(360,"Not enough resources are available to process this command."); break; 
	case ERROR_PATH_BUSY: ern=XSPMSG(361,"The path specified cannot be used at this time."); break; 
	case ERROR_IS_SUBST_TARGET: ern=XSPMSG(362,"An attempt was made to join or substitute a drive for which a directory on the drive is the target of a previous substitute."); break; 
	case ERROR_SYSTEM_TRACE: ern=XSPMSG(363,"System trace information was not specified in your CONFIG.SYS file, or tracing is disallowed."); break; 
	case ERROR_INVALID_EVENT_COUNT: ern=XSPMSG(364,"The number of specified semaphore events for DosMuxSemWait is not correct."); break; 
	case ERROR_TOO_MANY_MUXWAITERS: ern=XSPMSG(365,"DosMuxSemWait did not execute; too many semaphores are already set."); break; 
	case ERROR_INVALID_LIST_FORMAT: ern=XSPMSG(366,"The DosMuxSemWait list is not correct."); break; 
	case ERROR_LABEL_TOO_LONG: ern=XSPMSG(367,"The volume label you entered exceeds the label character limit of the target file system."); break; 
	case ERROR_TOO_MANY_TCBS: ern=XSPMSG(368,"Cannot create another thread."); break; 
	case ERROR_SIGNAL_REFUSED: ern=XSPMSG(369,"The recipient process has refused the signal."); break; 
	case ERROR_DISCARDED: ern=XSPMSG(370,"The segment is already discarded and cannot be locked."); break; 
	case ERROR_NOT_LOCKED: ern=XSPMSG(371,"The segment is already unlocked."); break; 
	case ERROR_BAD_THREADID_ADDR: ern=XSPMSG(372,"The address for the thread ID is not correct."); break; 
	case ERROR_BAD_ARGUMENTS: ern=XSPMSG(373,"The argument string passed to DosExecPgm is not correct."); break; 
	case ERROR_BAD_PATHNAME: ern=XSPMSG(374,"The specified path is invalid."); break; 
	case ERROR_SIGNAL_PENDING: ern=XSPMSG(375,"A signal is already pending."); break; 
	case ERROR_MAX_THRDS_REACHED: ern=XSPMSG(376,"No more threads can be created in the system."); break; 
	case ERROR_LOCK_FAILED: ern=XSPMSG(377,"Unable to lock a region of a file."); break; 
	case ERROR_BUSY: ern=XSPMSG(378,"The requested resource is in use."); break; 
	case ERROR_CANCEL_VIOLATION: ern=XSPMSG(379,"A lock request was not outstanding for the supplied cancel region."); break; 
	case ERROR_ATOMIC_LOCKS_NOT_SUPPORTED: ern=XSPMSG(380,"The file system does not support atomic changes to the lock type."); break; 
	case ERROR_INVALID_SEGMENT_NUMBER: ern=XSPMSG(381,"The system detected a segment number that was not correct."); break; 
	case ERROR_INVALID_ORDINAL: ern=XSPMSG(382,"The operating system cannot run %1."); break; 
	case ERROR_ALREADY_EXISTS: ern=XSPMSG(383,"Cannot create a file when that file already exists."); break; 
	case ERROR_INVALID_FLAG_NUMBER: ern=XSPMSG(384,"The flag passed is not correct."); break; 
	case ERROR_SEM_NOT_FOUND: ern=XSPMSG(385,"The specified system semaphore name was not found."); break; 
	case ERROR_INVALID_STARTING_CODESEG: ern=XSPMSG(386,"The operating system cannot run %1."); break; 
	case ERROR_INVALID_STACKSEG: ern=XSPMSG(387,"The operating system cannot run %1."); break; 
	case ERROR_INVALID_MODULETYPE: ern=XSPMSG(388,"The operating system cannot run %1."); break; 
	case ERROR_INVALID_EXE_SIGNATURE: ern=XSPMSG(389,"Cannot run %1 in Win32 mode."); break; 
	case ERROR_EXE_MARKED_INVALID: ern=XSPMSG(390,"The operating system cannot run %1."); break; 
	case ERROR_BAD_EXE_FORMAT: ern=XSPMSG(391,"%1 is not a valid Win32 application."); break; 
	case ERROR_ITERATED_DATA_EXCEEDS_64k: ern=XSPMSG(392,"The operating system cannot run %1."); break; 
	case ERROR_INVALID_MINALLOCSIZE: ern=XSPMSG(393,"The operating system cannot run %1."); break; 
	case ERROR_DYNLINK_FROM_INVALID_RING: ern=XSPMSG(394,"The operating system cannot run this application program."); break; 
	case ERROR_IOPL_NOT_ENABLED: ern=XSPMSG(395,"The operating system is not presently configured to run this application."); break; 
	case ERROR_INVALID_SEGDPL: ern=XSPMSG(396,"The operating system cannot run %1."); break; 
	case ERROR_AUTODATASEG_EXCEEDS_64k: ern=XSPMSG(397,"The operating system cannot run this application program."); break; 
	case ERROR_RING2SEG_MUST_BE_MOVABLE: ern=XSPMSG(398,"The code segment cannot be greater than or equal to 64K."); break; 
	case ERROR_RELOC_CHAIN_XEEDS_SEGLIM: ern=XSPMSG(399,"The operating system cannot run %1."); break; 
	case ERROR_INFLOOP_IN_RELOC_CHAIN: ern=XSPMSG(400,"The operating system cannot run %1."); break; 
	case ERROR_ENVVAR_NOT_FOUND: ern=XSPMSG(401,"The system could not find the environment option that was entered."); break; 
	case ERROR_NO_SIGNAL_SENT: ern=XSPMSG(402,"No process in the command subtree has a signal handler."); break; 
	case ERROR_FILENAME_EXCED_RANGE: ern=XSPMSG(403,"The filename or extension is too long."); break; 
	case ERROR_RING2_STACK_IN_USE: ern=XSPMSG(404,"The ring 2 stack is in use."); break; 
	case ERROR_META_EXPANSION_TOO_LONG: ern=XSPMSG(405,"The global filename characters, * or ?, are entered incorrectly or too many global filename characters are specified."); break; 
	case ERROR_INVALID_SIGNAL_NUMBER: ern=XSPMSG(406,"The signal being posted is not correct."); break; 
	case ERROR_THREAD_1_INACTIVE: ern=XSPMSG(407,"The signal handler cannot be set."); break; 
	case ERROR_LOCKED: ern=XSPMSG(408,"The segment is locked and cannot be reallocated."); break; 
	case ERROR_TOO_MANY_MODULES: ern=XSPMSG(409,"Too many dynamic-link modules are attached to this program or dynamic-link module."); break; 
	case ERROR_NESTING_NOT_ALLOWED: ern=XSPMSG(410,"Cannot nest calls to LoadModule."); break; 
	case ERROR_EXE_MACHINE_TYPE_MISMATCH: ern=XSPMSG(411,"The image file %1 is valid, but is for a machine type other than the current machine."); break; 
	case ERROR_BAD_PIPE: ern=XSPMSG(412,"The pipe state is invalid."); break; 
	case ERROR_PIPE_BUSY: ern=XSPMSG(413,"All pipe instances are busy."); break; 
	case ERROR_NO_DATA: ern=XSPMSG(414,"The pipe is being closed."); break; 
	case ERROR_PIPE_NOT_CONNECTED: ern=XSPMSG(415,"No process is on the other end of the pipe."); break; 
	case ERROR_MORE_DATA: ern=XSPMSG(416,"More data is available."); break; 
	case ERROR_VC_DISCONNECTED: ern=XSPMSG(417,"The session was canceled."); break; 
	case ERROR_INVALID_EA_NAME: ern=XSPMSG(418,"The specified extended attribute name was invalid."); break; 
	case ERROR_EA_LIST_INCONSISTENT: ern=XSPMSG(419,"The extended attributes are inconsistent."); break; 
	case WAIT_TIMEOUT: ern=XSPMSG(420,"The wait operation timed out."); break;  
	case ERROR_NO_MORE_ITEMS: ern=XSPMSG(421,"No more data is available."); break; 
	case ERROR_CANNOT_COPY: ern=XSPMSG(422,"The copy functions cannot be used."); break; 
	case ERROR_DIRECTORY: ern=XSPMSG(423,"The directory name is invalid."); break; 
	case ERROR_EAS_DIDNT_FIT: ern=XSPMSG(424,"The extended attributes did not fit in the buffer."); break; 
	case ERROR_EA_FILE_CORRUPT: ern=XSPMSG(425,"The extended attribute file on the mounted file system is corrupt."); break; 
	case ERROR_EA_TABLE_FULL: ern=XSPMSG(426,"The extended attribute table file is full."); break; 
	case ERROR_INVALID_EA_HANDLE: ern=XSPMSG(427,"The specified extended attribute handle is invalid."); break; 
	case ERROR_EAS_NOT_SUPPORTED: ern=XSPMSG(428,"The mounted file system does not support extended attributes."); break; 
	case ERROR_NOT_OWNER: ern=XSPMSG(429,"Attempt to release mutex not owned by caller."); break; 
	case ERROR_TOO_MANY_POSTS: ern=XSPMSG(430,"Too many posts were made to a semaphore."); break; 
	case ERROR_PARTIAL_COPY: ern=XSPMSG(431,"Only part of a ReadProcessMemory or WriteProcessMemory request was completed."); break; 
	case ERROR_OPLOCK_NOT_GRANTED: ern=XSPMSG(432,"The oplock request is denied."); break; 
	case ERROR_INVALID_OPLOCK_PROTOCOL: ern=XSPMSG(433,"An invalid oplock acknowledgment was received by the system."); break; 
	case ERROR_MR_MID_NOT_FOUND: ern=XSPMSG(434,"The system cannot find message text for message number 0x%1 in the message file for %2."); break; 
	case ERROR_INVALID_ADDRESS: ern=XSPMSG(435,"Attempt to access invalid address."); break; 
	case ERROR_ARITHMETIC_OVERFLOW: ern=XSPMSG(436,"Arithmetic result exceeded 32 bits."); break; 
	case ERROR_PIPE_CONNECTED: ern=XSPMSG(437,"There is a process on other end of the pipe."); break; 
	case ERROR_PIPE_LISTENING: ern=XSPMSG(438,"Waiting for a process to open the other end of the pipe."); break; 
	case ERROR_EA_ACCESS_DENIED: ern=XSPMSG(439,"Access to the extended attribute was denied."); break; 
	case ERROR_OPERATION_ABORTED: ern=XSPMSG(440,"The I/O operation has been aborted because of either a thread exit or an application request."); break; 
	case ERROR_IO_INCOMPLETE: ern=XSPMSG(441,"Overlapped I/O event is not in a signaled state."); break; 
	case ERROR_IO_PENDING: ern=XSPMSG(442,"Overlapped I/O operation is in progress."); break; 
	case ERROR_NOACCESS: ern=XSPMSG(443,"Invalid access to memory location."); break; 
	case ERROR_SWAPERROR: ern=XSPMSG(444,"Error performing inpage operation."); break; 
	default: ern=XSPMSG(445,"OS filesystem error ($2;) while accessing file '$1;'"); break;
    };

	Exception(ern)
		.Param(fn.GetFullPathNameWin32())
		.Param((sint32)err)
		.Raise();
    
}

static void  _GetSystemFolder(char* path_name, int csidl)
{
   path_name[0] = 0;
   LPMALLOC pMalloc = NULL;
   HRESULT res = ::SHGetMalloc(&pMalloc);
   if ((res == NOERROR) && (pMalloc != NULL))
   {
	   LPITEMIDLIST pidl;
	   // this is the "hard way" compared to SHGetSpecialFolderPath
	   // but it's available on any Win32 platform
	   res = ::SHGetSpecialFolderLocation(NULL, 
	                                      csidl|CSIDL_FLAG_CREATE, 
	                                      &pidl);
	   if (res == NOERROR)
	   {
			BOOL b = ::SHGetPathFromIDList(pidl,path_name);
			if (b == 0)
				path_name[0] = 0;
		    pMalloc->Free(pidl);
	   }
	   pMalloc->Release();
   }
}

SpecialFileNames::SpecialFileNames()
: ref(new _Data())
{
	char path_name[MAX_PATH];
	{ 
		DWORD path_size = ::GetTempPath( sizeof(path_name), path_name );
		VERIFY(path_size != 0);
		FileName fn(FileName::FromPathNameWin32(String(path_name, path_size)));
		SetFileName(TempDir, fn); 
	}
	{ 
		_GetSystemFolder(path_name, 0x25); //CSIDL_SYSTEM);
	    if (path_name[0] == 0)
		_GetSystemFolder(path_name, 0x24); //CSIDL_WINDOWS);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(SystemDir, fn);
			while (fn.HasParent())
				fn = fn.GetParent();
			SetFileName(MachineRoot, fn);
		}
	}
	{ 
		_GetSystemFolder(path_name, CSIDL_PERSONAL);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(UserHomeDir, fn);
		}
	}
	{ 		  
		_GetSystemFolder(path_name, CSIDL_DESKTOPDIRECTORY);
	    if (path_name[0] == 0)
			_GetSystemFolder(path_name, CSIDL_COMMON_DESKTOPDIRECTORY);
	    if (path_name[0] == 0)
			_GetSystemFolder(path_name, CSIDL_DESKTOP);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(UserDesktopDir, fn);
		}
	}						  
	{ 
		_GetSystemFolder(path_name, CSIDL_PERSONAL);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(UserPreferencesDir, fn);
		}
	}
	{ 
		_GetSystemFolder(path_name, CSIDL_LOCAL_APPDATA);
	    if (path_name[0] == 0)
			_GetSystemFolder(path_name, CSIDL_APPDATA);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(MachinePreferencesDir, fn); 
		}
	}

    {
        ::GetCurrentDirectory(sizeof(path_name), path_name);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(ProcessWorkingDir, fn); 
		}
    }

	{
		DWORD path_size = ::GetModuleFileName(NULL, path_name, sizeof(path_name));
		VERIFY(path_size != 0);
		
		FileName fn(FileName::FromPathNameWin32(String(path_name, path_size)));
		SetFileName(AppName, fn);
		if (fn.HasParent())
		{
			fn = fn.GetParent();
			SetFileName(AppDir, fn);
		}
	}	
	{ 
		_GetSystemFolder(path_name, CSIDL_STARTUP);
	    if (path_name[0] == 0)
			_GetSystemFolder(path_name, CSIDL_COMMON_STARTUP);
	    if (path_name[0] == 0)
			_GetSystemFolder(path_name, CSIDL_ALTSTARTUP);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(StartupDir, fn); 
		}
	}
	{ 
		_GetSystemFolder(path_name, CSIDL_STARTMENU);
	    if (path_name[0] == 0)
			_GetSystemFolder(path_name, CSIDL_COMMON_STARTMENU);
	    if (path_name[0] == 0)
			_GetSystemFolder(path_name, CSIDL_ALTSTARTUP);
	    if(path_name[0] != 0)
	    {
			FileName fn(FileName::FromPathNameWin32(String::From_c_str(path_name)));
			SetFileName(MenuDir, fn); 
		}
	}
//	{ SetFileName(RecycleBinDir, FileName::FromPathNameMac(_GetFolderName(kTrashFolderType))); }
//	{ SetFileName(ShutdownDir, FileName::FromPathNameMac(_GetFolderName(kShutdownFolderType))); }
}


FileForkList::FileForkList(const FileName& fname)
: ref(new _Data())
{
	ref->filename = fname;
	if (fname.Exists())
	{
		ref->items.push_back(String::kEmpty);   // ToDo NT forks
	}
}
   									

FileList::FileList(const FileName& fname)
: ref(new _Data())
{
    String fnOS(fname.GetFullPathNameWin32(true)
    		   +String::From_c_str("*.*"));
    WIN32_FIND_DATA fd;
    HANDLE fh = ::FindFirstFile( fnOS.c_str(), &fd );
    if ( INVALID_HANDLE_VALUE == fh )
		 _WinFS_Fail(fname);
    for(;;)
    {
		bool ignore = false;// ignore . and ..
		if (fd.cFileName[0] == '.')
		{
		    if (fd.cFileName[1] == 0)
		    	ignore = true;
		    else if ((fd.cFileName[1] == '.') && (fd.cFileName[2] == 0))
		    	ignore = true;
		}
		if (! ignore)
		{
			FileProperties props;
			props.SetFileName(FileName::From(fname, String::From_c_str(fd.cFileName)));	
			if (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	    		props.SetProperty(FileProperties::IsDir, String::kEmpty);
			if (fd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN)
				props.SetProperty(FileProperties::IsHidden, String::kEmpty);
			if (fd.dwFileAttributes & FILE_ATTRIBUTE_READONLY)
				props.SetProperty(FileProperties::IsReadOnly, String::kEmpty);
		    props.SetProperty(FileProperties::Size, 
		    	String::From_uint64( ((uint64)fd.nFileSizeHigh<<32)+fd.nFileSizeLow ));
		    props.SetProperty(FileProperties::ShortName, 
			    	String::From_c_str(fd.cAlternateFileName[0]?fd.cAlternateFileName:fd.cFileName) );

		    LocalTime dt(LocalTime::From100NanoSince_1601Jan1(*(uint64*)&fd.ftCreationTime));
		    props.SetProperty( FileProperties::CreationTime, dt.ToString());
		    dt = LocalTime::From100NanoSince_1601Jan1(*(uint64*)&fd.ftLastWriteTime);
		    props.SetProperty( FileProperties::ModifyTime, dt.ToString());
		    dt = LocalTime::From100NanoSince_1601Jan1(*(uint64*)&fd.ftLastAccessTime);
		    props.SetProperty( FileProperties::AccessTime, dt.ToString());

		    Add(props); //ref->items.push_back(props);
	    }
		if (0 == ::FindNextFile(fh, &fd))
			break;
    }
    ::FindClose(fh);
}


FileProperties::FileProperties(const FileName& fname)
: ref(new _Data())
{
    String fnOS(fname.GetFullPathNameWin32(false));

   	SetFileName(fname);
   	WIN32_FILE_ATTRIBUTE_DATA fd;
   	if (0 == ::GetFileAttributesEx(fnOS.c_str(), GetFileExInfoStandard, &fd))
	{
//		if (ERROR_INVALID_FUNCTION == ::GetLastError())
//			Win95 does not implement this func
	 	_WinFS_Fail(fname);
   	}
   	
	if (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		SetProperty(FileProperties::IsDir, String::kEmpty);
	if (fd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN)
		SetProperty(FileProperties::IsHidden, String::kEmpty);
	if (fd.dwFileAttributes & FILE_ATTRIBUTE_READONLY)
		SetProperty(FileProperties::IsReadOnly, String::kEmpty);
    SetProperty(FileProperties::Size, 
    	String::From_uint64( ((uint64)fd.nFileSizeHigh<<32)+fd.nFileSizeLow ));

    LocalTime dt(LocalTime::From100NanoSince_1601Jan1(*(uint64*)&fd.ftCreationTime));
    SetProperty( FileProperties::CreationTime, dt.ToString());
    dt = LocalTime::From100NanoSince_1601Jan1(*(uint64*)&fd.ftLastWriteTime);
    SetProperty( FileProperties::ModifyTime, dt.ToString());
    dt = LocalTime::From100NanoSince_1601Jan1(*(uint64*)&fd.ftLastAccessTime);
    SetProperty( FileProperties::AccessTime, dt.ToString());
	{
		char shBuf[14];
		DWORD n= ::GetShortPathName(fnOS.c_str(), shBuf, sizeof(shBuf));
		if (n == 0)
		 	_WinFS_Fail(fname);
	    SetProperty(FileProperties::ShortName, String::From_c_str(shBuf) );
	}
}
/*
    {	 
    	DWORD n= ::GetFileAttributes(fnOS.c_str());
		if (n & FILE_ATTRIBUTE_DIRECTORY)
    		props.SetProperty(FileProperties::IsDir, String::kEmpty);
		if (n & FILE_ATTRIBUTE_HIDDEN)
			props.SetProperty(FileProperties::IsHidden, String::kEmpty);
		if (n & FILE_ATTRIBUTE_READONLY)
			props.SetProperty(FileProperties::IsReadOnly, String::kEmpty);
    }
    {
		DWORD n = ::GetFileSize();
	    props.SetProperty(FileProperties::Size, 
	    	String::From_uint64( ((uint64)fd.nFileSizeHigh<<32)+fd.nFileSizeLow ));
    }
*/

#if 0
#pragma mark -
#endif

bool FileName::Exists() const
{
    String fnOS(GetFullPathNameWin32(false));
	DWORD n= ::GetFileAttributes(fnOS.c_str());
    return n != -1;
}

bool FileName::IsDir() const
{
    String fnOS(GetFullPathNameWin32(false));
	DWORD n= ::GetFileAttributes(fnOS.c_str());
	return ((n != -1) && (0 != (n & FILE_ATTRIBUTE_DIRECTORY)));
}

bool FileName::IsLink() const
{
	return false;
}

void FileName::Delete() const
{
    String fnOS(GetFullPathNameWin32(false));
	// remove read only attribute
	DWORD n= ::GetFileAttributes(fnOS.c_str());
	if (n == -1) // file does not exist
		return;
	if (0 == ::SetFileAttributes(fnOS.c_str(), n &~ FILE_ATTRIBUTE_READONLY))
	 	_WinFS_Fail(*this);
	if (n & FILE_ATTRIBUTE_DIRECTORY)
	{
	 	if (0 == ::RemoveDirectory(fnOS.c_str()))
			_WinFS_Fail(*this);
	}
	else
	{   
	    if (0 != ::DeleteFile(fnOS.c_str()))
			_WinFS_Fail(*this);
	}
}

void FileName::CreateDir(bool deep) const
{
    String fnOS(GetFullPathNameWin32(false));
    if (0 == ::CreateDirectory(fnOS.c_str(), 0))
    {
		if (deep && HasParent())
		{   // recursively deal with the parent
			GetParent().CreateDir(true); 
			CreateDir(false); // try again
		}
		else
			_WinFS_Fail(*this);
    }
}

void FileName::OpenWithOS()
{
    String fnOS(GetFullPathNameWin32(false));
	uint32 ret = (uint32)ShellExecute(NULL, 
									NULL/*"open"*/, 
									fnOS.c_str(), 
									NULL, NULL, SW_SHOWNORMAL);
	VERIFY(ret > 32);
}

#if 0
#pragma mark -
#endif

class OpenedFile::_Data : public ref_obj
{
public:
	 HANDLE handle;
	 FileName filename;
	 
	 ~_Data()
	 {
	    ::CloseHandle( handle );
	 }
};

OpenedFile::OpenedFile()
{
}

OpenedFile::OpenedFile(const OpenedFile& of)
: ref(of.ref)
{
}

OpenedFile& OpenedFile::operator= (const OpenedFile& of)
{
	ref = of.ref;
	return *this;
}

OpenedFile::~OpenedFile()
{
}
OpenedFile::OpenedFile( const FileName& fn, 
						const AccessType& acc, 
						const String& /*fork*/  )
{
	DWORD a=  (&acc==&ReadOnlyShared) ? (GENERIC_READ) 
    		: (&acc==&ReadWriteExclusive) ? (GENERIC_READ|GENERIC_WRITE)
    		: (&acc==&ReadWriteShared) ? (GENERIC_READ|GENERIC_WRITE)
    		: 0;
    DWORD s = (&acc==&ReadOnlyShared) ? (FILE_SHARE_READ) 
    		: (&acc==&ReadWriteExclusive) ? (0)
    		: (&acc==&ReadWriteShared) ? (FILE_SHARE_READ|FILE_SHARE_WRITE)
    		: 0;
    DWORD o = (&acc==&ReadOnlyShared) ? (OPEN_EXISTING) 
    		: (&acc==&ReadWriteExclusive) ? (OPEN_ALWAYS)
    		: (&acc==&ReadWriteShared) ? (OPEN_ALWAYS)
    		: 0;
    String fnOS(fn.GetFullPathNameWin32(false));
    HANDLE h = ::CreateFile(fnOS.c_str(), a, s, 0, o, FILE_ATTRIBUTE_NORMAL, 0);
    if (h == INVALID_HANDLE_VALUE)
		_WinFS_Fail(fn);

    ref = new _Data();
    ref->handle = h;
    ref->filename = fn;
}

OpenedFile::file_size OpenedFile::GetSize() const
{
	uint64 z = 0;
	0[(uint32*)&z] = ::GetFileSize(ref->handle, 1+(uint32*)&z);
	if (0[(uint32*)&z] == -1)
		_WinFS_Fail(ref->filename);
    return z;
}

void OpenedFile::SetSize(OpenedFile::file_size z) const
{
    if (-1 == ::SetFilePointer(ref->handle,0[(uint32*)&z],1+(sint32*)&z,FILE_BEGIN))
		_WinFS_Fail(ref->filename);
	if (0 == ::SetEndOfFile(ref->handle))
		_WinFS_Fail(ref->filename);
}

OpenedFile::block_size 
	OpenedFile::Read(OpenedFile::file_size pos, 
					  void* bf, 
					  OpenedFile::block_size z) const
{
    if (-1 == ::SetFilePointer(ref->handle,0[(uint32*)&pos],1+(sint32*)&pos,FILE_BEGIN))
		_WinFS_Fail(ref->filename);
	DWORD r = 0;	
    if (0 == ::ReadFile(ref->handle, bf, z, &r, 0))
		_WinFS_Fail(ref->filename);
    return r;
}

OpenedFile::block_size 
	OpenedFile::Write( OpenedFile::file_size pos, 
					   const void* bf, 
					   OpenedFile::block_size z) const
{
    if (-1 == ::SetFilePointer(ref->handle,0[(uint32*)&pos],1+(sint32*)&pos,FILE_BEGIN))
		_WinFS_Fail(ref->filename);
	DWORD r = 0;	
    if (0 == ::WriteFile(ref->handle, bf, z, &r, 0))
		_WinFS_Fail(ref->filename);
    return r;
}

#endif
} // namespace XSP
