#if 0
#pragma mark class SkinBuilder
#endif

class SkinBuilder : public ref_obj
{
public:
	refc<ImagePool> images;

	refc<ViewSkin>  appSkin;

    TextFont		comic10Font;
    TextFont		arial8Font;
    TextFont		times8boldFont;
    TextFont		tahoma8Font;
    
protected:
	~SkinBuilder();
public:
	SkinBuilder();
	void LoadImages();	
	void ImageFailed(const Exception& err);
	void ImagesLoaded();
private:
	void CreateOrangeSkin();
	void CreateGreySkin();
	void CreateButtonSkin();
	void CreateTabSkin();
	void CreateListSkin();
	void CreateComboSkin();
	void CreateDialogSkin();
	void CreateFilePickSkin();

	void CreateToolbarSkin();
	refc<ViewSkin> CreateToolSkin(uint32 imgNo);
	void CreateToolSkins();

	refc<ViewSkin> CreateScrollVSkin();
	refc<ViewSkin> CreateScrollHSkin();
	void CreateScrollPageSkin();

private:
	void CreateComic10Font();
	void CreateArial8Font();
	void CreateTimes8BoldFont();
	void CreateTahoma8Font();

private:
	class _Listener
	{
	public:
		virtual void SkinBuildComplete() =0;
		virtual void SkinBuildFailed(const Exception& err) =0;
	};
public:	
	typedef ListenerOf<_Listener> Listener;
	typedef Listener::Container Listeners;
private:
	Listeners listeners;
public:
	void AddListener(const Listener::owner& l) { listeners.Add(l); }
}; // class SkinBuilder
