/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

#if TARGET_API_Linux

RuntimeVersion::RuntimeVersion()
{
    {
    	int mib[2] = {CTL_KERN, KERN_VERSION};
    	size_t z = 1024;
    	String s;
    	s.resize(z);
    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
			   s.begin(), &z, NULL, 0))
    	{  
	    s.resize(std::string::traits_type::length(s.begin()));
	    productCategory = s;
	}
    }
    {
    	int mib[2] = {CTL_KERN, KERN_OSTYPE};
    	size_t z = 1024;
    	String s;
    	s.resize(z);
    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
			s.begin(), &z, NULL, 0))
    	{   
    	    s.resize(std::string::traits_type::length(s.begin()));
    	    productName = s;
	}
    }
    {
    	int mib[2] = {CTL_KERN, KERN_OSRELEASE};
    	size_t z = 1024;
    	String s;
    	s.resize(z);
    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
			s.begin(), &z, NULL, 0))
    	{   
    	    s.resize(std::string::traits_type::length(s.begin()));
    	    fullVersion = s;
    	    String::const_iterator p = std::find(s.begin(), s.end(), '.');
    	    majorVersion = String(s.begin(), p).To_uint32();
    	    if (p != s.end())
    		minorVersion = String(p+1, s.end()).To_uint32();
    	    else
    		minorVersion = 0;
	}
    }
    {
	buildNumber = 0;
    	int mib[2] = {CTL_KERN, KERN_OSREV};
    	size_t z = sizeof(buildNumber);
    	if (-1 != ::sysctl(mib, sizeof(mib)/sizeof(*mib), 
    			   &buildNumber, &z, NULL, 0))
    	{
        //	buildNumber = n;
    	}
    }
    
    fullName = productName 
	 + String::From_c_str(" kernel version ") + fullVersion
	 + String::From_c_str(" (build ")  
	 + String::From_uint32( buildNumber )
	 + String::From_c_str(", ") + productCategory
	 + String::From_c_str(")");
}


#endif

} // namespace XSP
