/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

namespace XSP
{
   class Exception
   {
   		refc<StringMessage> msg;
		ptr<Exception> because;
		
   public:
   		Exception();		
   		Exception(const refc<StringMessage>& sm);		
   		Exception(const Exception& ex);		
   		~Exception();

		Exception& Because(const Exception& e);

   		const refc<StringMessage>& GetMessage() const { return msg; }

   		String FormatMessageToString() const ;
   		
   public:
   		// nice and easy package 
   		Exception(uint32 msgID);		
		Exception& Param(const String& p);
		Exception& Param(uint32 p);
		Exception& Param(sint32 p);
		Exception& Param(uint64 p);
		Exception& Param(sint64 p);
   		void Raise() const;

   public:
   #if DEBUG
   		static void RaiseAssertError(const char* file, uint32 nline, const char* code,
   							  const VersionInfo& v); 
   #endif
   		static void RaiseVerifyError(const char* code, const VersionInfo& v); 
		static Exception ExternalError(const char* code, const VersionInfo& v); 
   };
   
   class ErrorSink : public ref_interface
   {
   public:
   		virtual void ProcessError(const Exception& err) = 0;
   };

   class ErrorsToConsole : public ErrorSink , private ref_obj
   {
   public:
   		ErrorsToConsole(); 
   		 
   public:
   		void addref();
   		void release();
   protected:
   		~ErrorsToConsole();  
   		void ProcessError(const Exception& err);
   };
   
      
} // namespace XSP


