////////////////////////////////////////////////////////////////
// GifChartServlet.java
////////////////////////////////////////////////////////////////

import com.objectplanet.chart.*;
import java.io.*;
import java.awt.*;
import javax.servlet.*;
import Acme.JPM.Encoders.*;


/**
 * This servlet outputs the generated charts as a gif image.
 * 
 * @author Bjorn J. Kvande.
 */
public class GifChartServlet extends ChartServlet {
	public void encodeChartImage(Image image, OutputStream out, ServletResponse res) throws IOException {
      // set the response type to a gif image
      res.setContentType("image/gif");
		// create a gif image and send it to the client
		GifEncoder encoder = new GifEncoder(image, out);
		encoder.encode();
		out.flush();
	}
}
