/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.examples;

import com.objectplanet.chart.BarChartApplet;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.gui.TabbedEvent;
import com.objectplanet.gui.TabbedListener;
import com.objectplanet.gui.TabbedPanel;
import com.objectplanet.gui.Table;
import com.objectplanet.gui.TableEvent;
import com.objectplanet.gui.TableListener;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class NetworkMonitor
extends Applet
implements TableListener,
ItemListener,
TabbedListener {
    private TabbedPanel trafficTabs;
    private Table[] trafficTables;
    private BarChartApplet[] chartApplets;
    private String[] tablePrefix = new String[]{"protocol_", "nlHost_", "nlMatrix_", "alHost_", "alMatrix_", "macHost_", "macMatrix_"};
    private String[] tabLabels = new String[]{"protocols", "hosts", "conversations", "protocols per host", "protocols per conversation", "network cards", "network card conversations"};
    private int[] selectedNumberColumn = new int[]{4, 3, 5, 4, 6, 2, 5};
    private int[][] tableSampleLabelColumns;

    private String[] createSampleLabels(Table table, int[] columns, String connector) {
        if (table == null || columns == null || columns.length == 0) {
            return new String[0];
        }
        String[][] table_data = new String[columns.length][];
        int i = 0;
        while (i < table_data.length) {
            table_data[i] = (String[])table.getColumn(columns[i], 0, -1);
            ++i;
        }
        String[] labels = new String[table_data[0].length];
        int row = 0;
        while (row < labels.length) {
            StringBuffer buffer = new StringBuffer(100);
            int col = 0;
            while (col < table_data.length) {
                if (table_data[col][row] != null) {
                    buffer.append(table_data[col][row]);
                    if (col < table_data.length - 1 && connector != null) {
                        buffer.append(connector);
                    }
                }
                ++col;
            }
            labels[row] = buffer.toString();
            ++row;
        }
        return labels;
    }

    public void tabEvent(TabbedEvent event) {
        switch (event.getType()) {
            case 0: {
                String tab = event.getTab();
                int i = 0;
                while (i < this.tabLabels.length) {
                    if (tab.equalsIgnoreCase(this.tabLabels[i])) {
                        this.trafficTables[i].requestFocus();
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            ItemSelectable source = event.getItemSelectable();
            Table table = null;
            int i = 0;
            while (i < this.chartApplets.length) {
                if (source == this.chartApplets[i].theChart) {
                    table = this.trafficTables[i];
                    break;
                }
                ++i;
            }
            if (table != null) {
                table.selectRow(table.getLastSelectedRow(), false);
                ChartSample item = (ChartSample)event.getItem();
                int position = item.getIndex();
                int row_index = table.getRowIndex(position);
                table.selectRow(row_index, true);
                if (row_index >= 0) {
                    table.gotoRow(row_index);
                }
                table.requestFocus();
            }
        }
    }

    public NetworkMonitor() {
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[1];
        nArrayArray[1] = new int[1];
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 2;
        nArray3[2] = 4;
        nArrayArray[4] = nArray3;
        nArrayArray[5] = new int[1];
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        nArrayArray[6] = nArray4;
        this.tableSampleLabelColumns = nArrayArray;
        this.trafficTables = new Table[7];
        this.chartApplets = new BarChartApplet[this.trafficTables.length];
        int i = 0;
        while (i < this.trafficTables.length) {
            this.trafficTables[i] = new Table();
            this.trafficTables[i].setLabelCacheOn(true);
            this.trafficTables[i].setAutomaticRepaintOn(false);
            this.trafficTables[i].setParentApplet(this);
            this.trafficTables[i].addTableListener(this);
            this.trafficTables[i].setParameterPrefix(this.tablePrefix[i]);
            this.trafficTables[i].setBackground(new Color(0xCFCFCE));
            this.chartApplets[i] = new BarChartApplet();
            this.chartApplets[i].setParentApplet(this);
            this.chartApplets[i].setParameterPrefix("bar_");
            this.chartApplets[i].theChart.setAutomaticRepaintOn(false);
            this.chartApplets[i].theChart.addItemListener(this);
            ++i;
        }
        this.trafficTabs = new TabbedPanel();
        this.trafficTabs.setBackground(Color.white);
        this.trafficTabs.setTabColor(new Color(0xCFCFCE));
        this.trafficTabs.addTabbedListener(this);
        i = 0;
        while (i < this.trafficTables.length) {
            Panel p = new Panel(new GridLayout(2, 1));
            p.add(this.trafficTables[i]);
            p.add(this.chartApplets[i]);
            this.trafficTabs.add(this.tabLabels[i], p);
            ++i;
        }
        this.setLayout(new BorderLayout());
        this.add("Center", this.trafficTabs);
    }

    private void setChartData(int table_index, int column) {
        Table table = this.trafficTables[table_index];
        BarChartApplet chart = this.chartApplets[table_index];
        if (column < table.getColumnCount()) {
            if (column < 0 || table.getColumnType(column) != 1) {
                column = this.selectedNumberColumn[table_index];
            }
            double upper_range = chart.theChart.getRange(0);
            double adjusted_range = chart.theChart.getCurrentRange(0);
            double[] values = table.getColumnValues(column, 0, -1);
            chart.theChart.setSampleCount(Math.max(10, values.length));
            chart.theChart.setSampleValues(0, values);
            chart.theChart.setVisibleSamples(table.getFirstRowPosition(), 10);
            String[] sampleLabels = this.createSampleLabels(table, this.tableSampleLabelColumns[table_index], " - ");
            chart.theChart.setSampleLabels(sampleLabels);
            chart.theChart.setLabel("rangeAxisLabel", table.getHeader(column));
            chart.theChart.setRelativeRange(1.0);
            if (upper_range == adjusted_range) {
                chart.theChart.setCurrentRange(0, chart.theChart.getRange());
            }
        }
    }

    public void init() {
        int i = 0;
        while (i < this.trafficTables.length) {
            this.chartApplets[i].init();
            this.chartApplets[i].theChart.setTitle(this.tabLabels[i]);
            this.chartApplets[i].theChart.setTitleOn(true);
            this.trafficTables[i].init();
            ++i;
        }
        this.trafficTables[0].requestFocus();
    }

    public void tableSelection(TableEvent event) {
        Table table = (Table)event.getSource();
        int column_index = event.getColumn();
        int row_position = event.getRowPos();
        int column_type = 0;
        if (column_index >= 0) {
            column_type = table.getColumnType(column_index);
        }
        int table_index = -1;
        int i = 0;
        while (i < this.trafficTables.length) {
            if (table == this.trafficTables[i]) {
                table_index = i;
                break;
            }
            ++i;
        }
        if (table_index >= 0) {
            BarChartApplet chart = this.chartApplets[table_index];
            chart.theChart.setAutomaticRepaintOn(false);
            table.setAutomaticRepaintOn(false);
            switch (event.getType()) {
                case 4: 
                case 5: 
                case 6: {
                    this.setChartData(table_index, column_index);
                    break;
                }
                case 7: {
                    chart.theChart.setVisibleSamples(table.getFirstRowPosition(), 10);
                    break;
                }
                case 0: 
                case 2: {
                    if (column_type == 1) {
                        this.setChartData(table_index, column_index);
                    }
                    chart.theChart.setSelection(0, -1, false, false);
                    chart.theChart.setSelection(0, row_position, true, false);
                    break;
                }
                case 8: {
                    chart.theChart.setSelection(0, -1, false, false);
                    chart.theChart.setSelection(0, row_position, true, false);
                    break;
                }
            }
            table.setAutomaticRepaintOn(true);
            chart.theChart.setAutomaticRepaintOn(true);
            table.repaint();
            chart.theChart.repaint();
        }
    }
}

