/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import java.awt.Color;
import java.io.Serializable;

public class ChartSample
implements Serializable {
    protected Double value;
    protected String label;
    Color labelColor;
    private static final Color DEFAULT_COLOR = Color.black;
    private int series;
    private int index;
    Object key;
    private boolean selected;

    public void set(double d, String string, Object object) {
        this.value = new Double(d);
        this.label = string;
        this.key = object;
    }

    public void setValue(double d) {
        this.value = new Double(d);
    }

    public long getValue() {
        if (this.value != null) {
            return this.value.longValue();
        }
        return 0L;
    }

    public String toString() {
        if (this.label != null && this.value != null) {
            return this.series + ":" + this.index + " " + this.label + " " + this.value;
        }
        if (this.value != null) {
            return this.series + ":" + this.index + " " + "null " + this.value;
        }
        if (this.label != null) {
            return this.series + ":" + this.index + " " + this.label;
        }
        return this.series + ":" + this.index + " " + "null 0";
    }

    public ChartSample(int n) {
        this.index = n;
    }

    public ChartSample(int n, double d) {
        this.index = n;
        this.value = new Double(d);
    }

    public ChartSample(int n, double d, String string, Object object) {
        this.index = n;
        this.value = new Double(d);
        this.label = string;
        this.key = object;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean hasValue() {
        return this.value != null && this.value != Double.NaN;
    }

    public double getFloatValue() {
        if (this.value != null) {
            return this.value;
        }
        return Double.NaN;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean setSelection(boolean bl) {
        this.selected = bl;
        return this.selected;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean toggleSelection() {
        this.selected = !this.selected;
        return this.selected;
    }

    void setSeries(int n) {
        this.series = n;
    }

    public int getSeries() {
        return this.series;
    }

    public void clearValue() {
        this.value = null;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }
}

