package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Sales Totals by Amount<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Sales_Totals_by_AmountBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected Double SaleAmount;
    protected int OrderID;
    protected String CompanyName;
    protected java.sql.Date ShippedDate;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Sales_Totals_by_AmountBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Sales_Totals_by_AmountBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Sales_Totals_by_AmountBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        SaleAmount = new Double(rs.getDouble("SaleAmount"));

        if (rs.wasNull()) {
            SaleAmount = null;
        }

        ;
        OrderID = rs.getInt("OrderID");
        CompanyName = rs.getString("CompanyName");
        ShippedDate = rs.getDate("ShippedDate");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for SaleAmount.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Double getSaleAmount() {
        return SaleAmount;
    }

    /**
     * Setter for SaleAmount.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setSaleAmount(Double value) {
        this.SaleAmount = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field SaleAmount
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfSaleAmount(
        int maxResults) throws SQLException {
        return getResultSetWithSaleAmountValueOf(cs, getSaleAmount(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field SaleAmount
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithSaleAmountValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Sales_Totals_by_AmountBase_SaleAmount");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(1, value.doubleValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field SaleAmount
     * for equality with the same SaleAmount as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfSaleAmount(int maxResults)
        throws SQLException {
        return getLinkedListWithSaleAmountValueOf(cs, getSaleAmount(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field SaleAmount
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithSaleAmountValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithSaleAmountValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Sales_Totals_by_AmountBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field SaleAmount
     * for equality with the same SaleAmount as this instance.
     */
    public Iterator getIteratorWithSameValueOfSaleAmount(int maxResults)
        throws SQLException {
        return getIteratorWithSaleAmountValueOf(cs, getSaleAmount(), maxResults);
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field SaleAmount
     * for equality with the "value".
     */
    public static Iterator getIteratorWithSaleAmountValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        return getLinkedListWithSaleAmountValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getOrderID() {
        return OrderID;
    }

    /**
     * Setter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setOrderID(int value) {
        this.OrderID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getResultSetWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithOrderIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Sales_Totals_by_AmountBase_OrderID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Sales_Totals_by_AmountBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getIteratorWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCompanyName() {
        return CompanyName;
    }

    /**
     * Setter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCompanyName(String value) {
        this.CompanyName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCompanyName(
        int maxResults) throws SQLException {
        return getResultSetWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Sales_Totals_by_AmountBase_CompanyName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCompanyNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Sales_Totals_by_AmountBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getIteratorWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ShippedDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public java.sql.Date getShippedDate() {
        return ShippedDate;
    }

    /**
     * Setter for ShippedDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setShippedDate(java.sql.Date value) {
        this.ShippedDate = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field ShippedDate
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShippedDate(
        int maxResults) throws SQLException {
        return getResultSetWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Sales_Totals_by_AmountBase's by querying table field ShippedDate
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Sales_Totals_by_AmountBase_ShippedDate");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.DATE);
            } else {
                cc.setDate(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field ShippedDate
     * for equality with the same ShippedDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShippedDate(int maxResults)
        throws SQLException {
        return getLinkedListWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Sales_Totals_by_AmountBase's by querying table field ShippedDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShippedDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Sales_Totals_by_AmountBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field ShippedDate
     * for equality with the same ShippedDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfShippedDate(int maxResults)
        throws SQLException {
        return getIteratorWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets an Iterator of Sales_Totals_by_AmountBase's by querying table field ShippedDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithShippedDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Sales_Totals_by_AmountBase");

            if (SaleAmount == null) {
                cc.setNull(1, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(1, getSaleAmount().doubleValue());
            }

            cc.setInt(2, getOrderID());

            cc.setString(3, getCompanyName());

            cc.setDate(4, getShippedDate());

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "SaleAmount:" + getSaleAmount());

        System.out.println(prefix + "OrderID:" + getOrderID());

        System.out.println(prefix + "CompanyName:" + getCompanyName());

        System.out.println(prefix + "ShippedDate:" + getShippedDate());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(SaleAmount);
        sb.append(",");
        sb.append(OrderID);
        sb.append(",");
        sb.append(CompanyName);
        sb.append(",");
        sb.append(ShippedDate);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
