package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Region <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class RegionCached extends RegionBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public RegionCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected RegionCached(CS cs, int RegionID) throws SQLException {
        super(cs, RegionID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public RegionCached(CS cs, ResultSet rs) throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Gets a LinkedList of RegionCached's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets a LinkedList of RegionCached's by querying table field RegionID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new RegionCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of RegionCached's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getIteratorWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets an Iterator of RegionCached's by querying table field RegionID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of RegionCached's by querying table field RegionDescription
     * for equality with the same RegionDescription as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegionDescription(
        int maxResults) throws SQLException {
        return getLinkedListWithRegionDescriptionValueOf(cs,
            getRegionDescription(), maxResults);
    }

    /**
     * Gets a LinkedList of RegionCached's by querying table field RegionDescription
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionDescriptionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionDescriptionValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new RegionCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of RegionCached's by querying table field RegionDescription
     * for equality with the same RegionDescription as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegionDescription(int maxResults)
        throws SQLException {
        return getIteratorWithRegionDescriptionValueOf(cs,
            getRegionDescription(), maxResults);
    }

    /**
     * Gets an Iterator of RegionCached's by querying table field RegionDescription
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionDescriptionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithRegionDescriptionValueOf(cs, value, maxResults)
                   .iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return RegionCached.delete(cs, RegionID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int RegionID) throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                RegionCached.class,
                
            new Integer(RegionID)
            });

        return RegionBase.delete(cs, RegionID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            Cache.getCache().removeSynchronized(new Object[] {
                    RegionCached.class,
                    
                new Integer(old_RegionID)
                });

            int res = super.updateAll();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { RegionCached.class, new Integer(RegionID) };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached RegionCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] { RegionCached.class });
    }

    /**
     * Flush a cached RegionCached item.
     */
    public static void flushCache(int RegionID) {
        Cache.getCache().removeSynchronized(new Object[] {
                RegionCached.class,
                
            new Integer(RegionID)
            });
    }

    private static RegionCached cacheLookup(int RegionID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (RegionCached.class) {
            RegionCached t = (RegionCached) c.get(new Object[] {
                        RegionCached.class,
                        
                    new Integer(RegionID)
                    });

            if (t != null) {
                return (RegionCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static RegionCached instance(CS cs, int RegionID)
        throws SQLException, CloneNotSupportedException {
        RegionCached t = cacheLookup(RegionID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new RegionCached(cs, RegionID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth) {
        Element root = new Element("RegionCached");

        root.setAttribute("RegionID", String.valueOf(getRegionID()));

        root.addContent(new Element("RegionDescription").setText(
                getRegionDescription()));

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
