package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Region<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class RegionBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int RegionID;
    protected int old_RegionID; // Old value of the key is kept too
    protected String RegionDescription;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected RegionBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public RegionBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public RegionBase(CS cs, int RegionID) throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_RegionBase");

            cc.setInt(1, RegionID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public RegionBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        RegionID = old_RegionID = rs.getInt("RegionID");
        RegionDescription = rs.getString("RegionDescription");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for RegionID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getRegionID() {
        return RegionID;
    }

    /**
     * Setter for RegionID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRegionID(int value) {
        this.RegionID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of RegionBase's by querying table field RegionID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getResultSetWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of RegionBase's by querying table field RegionID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRegionIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_RegionBase_RegionID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of RegionBase's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets a LinkedList of RegionBase's by querying table field RegionID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new RegionBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of RegionBase's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getIteratorWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets an Iterator of RegionBase's by querying table field RegionID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for RegionDescription.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getRegionDescription() {
        return RegionDescription;
    }

    /**
     * Setter for RegionDescription.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRegionDescription(String value) {
        this.RegionDescription = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of RegionBase's by querying table field RegionDescription
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRegionDescription(
        int maxResults) throws SQLException {
        return getResultSetWithRegionDescriptionValueOf(cs,
            getRegionDescription(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of RegionBase's by querying table field RegionDescription
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRegionDescriptionValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_RegionBase_RegionDescription");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of RegionBase's by querying table field RegionDescription
     * for equality with the same RegionDescription as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegionDescription(
        int maxResults) throws SQLException {
        return getLinkedListWithRegionDescriptionValueOf(cs,
            getRegionDescription(), maxResults);
    }

    /**
     * Gets a LinkedList of RegionBase's by querying table field RegionDescription
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionDescriptionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionDescriptionValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new RegionBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of RegionBase's by querying table field RegionDescription
     * for equality with the same RegionDescription as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegionDescription(int maxResults)
        throws SQLException {
        return getIteratorWithRegionDescriptionValueOf(cs,
            getRegionDescription(), maxResults);
    }

    /**
     * Gets an Iterator of RegionBase's by querying table field RegionDescription
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionDescriptionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithRegionDescriptionValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return RegionBase.delete(cs, RegionID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int RegionID) throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_RegionBase");

            cc.setInt(1, RegionID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_RegionBase");

                cc.setString(1, getRegionDescription());

                cc.setInt(2, getRegionID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_RegionID = RegionID;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATEALL_RegionBase");

                cc.setInt(1, getRegionID());

                cc.setString(2, getRegionDescription());

                cc.setInt(3, old_RegionID);

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            updateOldKeys();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_RegionBase");

            cc.setInt(1, getRegionID());

            cc.setString(2, getRegionDescription());

            cc.executeUpdate();

            updateOldKeys();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "RegionID:" + getRegionID());

        System.out.println(prefix + "RegionDescription:" +
            getRegionDescription());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(RegionID);
        sb.append(",");
        sb.append(RegionDescription);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
