package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Employees <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class EmployeesCached extends EmployeesBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public EmployeesCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected EmployeesCached(CS cs, int EmployeeID) throws SQLException {
        super(cs, EmployeeID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public EmployeesCached(CS cs, ResultSet rs) throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Sets this row of Employees to reference the ref row of Employees
     */
    public void setReportsToRef(EmployeesCached ref) {
        setReportsTo(new Integer(ref.getEmployeeID()));
    }

    /**
     * Gets this row of Employees from referenced row of Employees
     */
    public EmployeesCached getReportsToRef()
        throws SQLException, CloneNotSupportedException {
        return getReportsToRef(cs);
    }

    /**
     * Gets this row of Employees from referenced row of Employees
     */
    public EmployeesCached getReportsToRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        if (getReportsTo() == null) {
            return null;
        }

        return EmployeesCached.instance(cs, getReportsTo().intValue());
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, getEmployeeID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithEmployeeIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithEmployeeIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public Iterator getIteratorWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getIteratorWithEmployeeIDValueOf(cs, getEmployeeID(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithEmployeeIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field LastName
     * for equality with the same LastName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfLastName(int maxResults)
        throws SQLException {
        return getLinkedListWithLastNameValueOf(cs, getLastName(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field LastName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithLastNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithLastNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field LastName
     * for equality with the same LastName as this instance.
     */
    public Iterator getIteratorWithSameValueOfLastName(int maxResults)
        throws SQLException {
        return getIteratorWithLastNameValueOf(cs, getLastName(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field LastName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithLastNameValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithLastNameValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field FirstName
     * for equality with the same FirstName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfFirstName(int maxResults)
        throws SQLException {
        return getLinkedListWithFirstNameValueOf(cs, getFirstName(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field FirstName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithFirstNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithFirstNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field FirstName
     * for equality with the same FirstName as this instance.
     */
    public Iterator getIteratorWithSameValueOfFirstName(int maxResults)
        throws SQLException {
        return getIteratorWithFirstNameValueOf(cs, getFirstName(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field FirstName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithFirstNameValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithFirstNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Title
     * for equality with the same Title as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTitle(int maxResults)
        throws SQLException {
        return getLinkedListWithTitleValueOf(cs, getTitle(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Title
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTitleValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTitleValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Title
     * for equality with the same Title as this instance.
     */
    public Iterator getIteratorWithSameValueOfTitle(int maxResults)
        throws SQLException {
        return getIteratorWithTitleValueOf(cs, getTitle(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Title
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTitleValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithTitleValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field TitleOfCourtesy
     * for equality with the same TitleOfCourtesy as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTitleOfCourtesy(
        int maxResults) throws SQLException {
        return getLinkedListWithTitleOfCourtesyValueOf(cs,
            getTitleOfCourtesy(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field TitleOfCourtesy
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTitleOfCourtesyValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTitleOfCourtesyValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field TitleOfCourtesy
     * for equality with the same TitleOfCourtesy as this instance.
     */
    public Iterator getIteratorWithSameValueOfTitleOfCourtesy(int maxResults)
        throws SQLException {
        return getIteratorWithTitleOfCourtesyValueOf(cs, getTitleOfCourtesy(),
            maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field TitleOfCourtesy
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTitleOfCourtesyValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithTitleOfCourtesyValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field BirthDate
     * for equality with the same BirthDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfBirthDate(int maxResults)
        throws SQLException {
        return getLinkedListWithBirthDateValueOf(cs, getBirthDate(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field BirthDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithBirthDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithBirthDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field BirthDate
     * for equality with the same BirthDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfBirthDate(int maxResults)
        throws SQLException {
        return getIteratorWithBirthDateValueOf(cs, getBirthDate(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field BirthDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithBirthDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithBirthDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field HireDate
     * for equality with the same HireDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfHireDate(int maxResults)
        throws SQLException {
        return getLinkedListWithHireDateValueOf(cs, getHireDate(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field HireDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithHireDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithHireDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field HireDate
     * for equality with the same HireDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfHireDate(int maxResults)
        throws SQLException {
        return getIteratorWithHireDateValueOf(cs, getHireDate(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field HireDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithHireDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithHireDateValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getLinkedListWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Address
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithAddressValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public Iterator getIteratorWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getIteratorWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Address
     * for equality with the "value".
     */
    public static Iterator getIteratorWithAddressValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithAddressValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field City
     * for equality with the same City as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getLinkedListWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field City
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCityValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field City
     * for equality with the same City as this instance.
     */
    public Iterator getIteratorWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getIteratorWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field City
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Region
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getIteratorWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Region
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, getPostalCode(),
            maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field PostalCode
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPostalCodeValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public Iterator getIteratorWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getIteratorWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field PostalCode
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Country
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public Iterator getIteratorWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getIteratorWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Country
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCountryValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCountryValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field HomePhone
     * for equality with the same HomePhone as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfHomePhone(int maxResults)
        throws SQLException {
        return getLinkedListWithHomePhoneValueOf(cs, getHomePhone(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field HomePhone
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithHomePhoneValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithHomePhoneValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field HomePhone
     * for equality with the same HomePhone as this instance.
     */
    public Iterator getIteratorWithSameValueOfHomePhone(int maxResults)
        throws SQLException {
        return getIteratorWithHomePhoneValueOf(cs, getHomePhone(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field HomePhone
     * for equality with the "value".
     */
    public static Iterator getIteratorWithHomePhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithHomePhoneValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Extension
     * for equality with the same Extension as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfExtension(int maxResults)
        throws SQLException {
        return getLinkedListWithExtensionValueOf(cs, getExtension(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field Extension
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithExtensionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithExtensionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Extension
     * for equality with the same Extension as this instance.
     */
    public Iterator getIteratorWithSameValueOfExtension(int maxResults)
        throws SQLException {
        return getIteratorWithExtensionValueOf(cs, getExtension(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field Extension
     * for equality with the "value".
     */
    public static Iterator getIteratorWithExtensionValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithExtensionValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field ReportsTo
     * for equality with the same ReportsTo as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfReportsTo(int maxResults)
        throws SQLException {
        return getLinkedListWithReportsToValueOf(cs, getReportsTo(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field ReportsTo
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithReportsToValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithReportsToValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field ReportsTo
     * for equality with the same ReportsTo as this instance.
     */
    public Iterator getIteratorWithSameValueOfReportsTo(int maxResults)
        throws SQLException {
        return getIteratorWithReportsToValueOf(cs, getReportsTo(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field ReportsTo
     * for equality with the "value".
     */
    public static Iterator getIteratorWithReportsToValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithReportsToValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field PhotoPath
     * for equality with the same PhotoPath as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPhotoPath(int maxResults)
        throws SQLException {
        return getLinkedListWithPhotoPathValueOf(cs, getPhotoPath(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesCached's by querying table field PhotoPath
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPhotoPathValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPhotoPathValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field PhotoPath
     * for equality with the same PhotoPath as this instance.
     */
    public Iterator getIteratorWithSameValueOfPhotoPath(int maxResults)
        throws SQLException {
        return getIteratorWithPhotoPathValueOf(cs, getPhotoPath(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesCached's by querying table field PhotoPath
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPhotoPathValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithPhotoPathValueOf(cs, value, maxResults)
                   .iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return EmployeesCached.delete(cs, EmployeeID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int EmployeeID) throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                EmployeesCached.class,
                
            new Integer(EmployeeID)
            });

        return EmployeesBase.delete(cs, EmployeeID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { EmployeesCached.class, new Integer(EmployeeID) };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached EmployeesCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] { EmployeesCached.class });
    }

    /**
     * Flush a cached EmployeesCached item.
     */
    public static void flushCache(int EmployeeID) {
        Cache.getCache().removeSynchronized(new Object[] {
                EmployeesCached.class,
                
            new Integer(EmployeeID)
            });
    }

    private static EmployeesCached cacheLookup(int EmployeeID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (EmployeesCached.class) {
            EmployeesCached t = (EmployeesCached) c.get(new Object[] {
                        EmployeesCached.class,
                        
                    new Integer(EmployeeID)
                    });

            if (t != null) {
                return (EmployeesCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static EmployeesCached instance(CS cs, int EmployeeID)
        throws SQLException, CloneNotSupportedException {
        EmployeesCached t = cacheLookup(EmployeeID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new EmployeesCached(cs, EmployeeID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth)
        throws SQLException, CloneNotSupportedException {
        Element root = new Element("EmployeesCached");

        root.setAttribute("EmployeeID", String.valueOf(getEmployeeID()));

        root.addContent(new Element("LastName").setText(getLastName()));

        root.addContent(new Element("FirstName").setText(getFirstName()));

        root.addContent(new Element("Title").setText(getTitle()));

        root.addContent(new Element("TitleOfCourtesy").setText(
                getTitleOfCourtesy()));

        root.setAttribute("BirthDate", String.valueOf(getBirthDate()));

        root.setAttribute("HireDate", String.valueOf(getHireDate()));

        root.addContent(new Element("Address").setText(getAddress()));

        root.addContent(new Element("City").setText(getCity()));

        root.addContent(new Element("Region").setText(getRegion()));

        root.addContent(new Element("PostalCode").setText(getPostalCode()));

        root.addContent(new Element("Country").setText(getCountry()));

        root.addContent(new Element("HomePhone").setText(getHomePhone()));

        root.addContent(new Element("Extension").setText(getExtension()));

        root.addContent(new Element("Notes").setText(getNotes()));

        root.setAttribute("ReportsTo", String.valueOf(getReportsTo()));

        root.addContent(new Element("PhotoPath").setText(getPhotoPath()));

        if (depth > 0) {
            EmployeesCached temp1 = getReportsToRef(cs);

            if (temp1 != null) {
                root.addContent(temp1.toXML(depth - 1));
            }
        }

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() throws SQLException, CloneNotSupportedException {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
