#include <CNova.h>

//default way to set up engine
CNova::CNova()
{
	error=new CError();
	error->open();
	error->write("Nova Engine\n");
	error->write("Version: 0.3.0.0\n");
	error->write("Time compiled: ");
	error->write(__DATE__);
	error->write("  ");
	error->write(__TIME__);
	error->write("\n[HESH]\n");
	destroyed=0;
}

//can specify file to write errors to
CNova::CNova(const char *file)
{
	error->open(file);
	error->write("Nova Engine\n");
	error->write("Version: 0.3.0.0\n");
	error->write("Time compiled: ");
	error->write(__DATE__);
	error->write("  ");
	error->write(__TIME__);
	error->write("\n[HESH]\n");
	destroyed=0;
}

//gets the window handle
HWND CNova::Get_Hwnd()
{
	return window->Get_HWND();
}

//sees if a key is pressed
//returns true if down, false if up
bool CNova::Key_Down(int key)
{
	return input->keydown(key);
}

//Creates a movie and returns it
CMovie *CNova::Create_Movie(WCHAR *file)
{
	CMovie *temp=new CMovie(this->error);
	error->write("Loading Movie...");
	if(temp->Create(file,this->Get_Hwnd())==D_ERROR)
	{
		error->write("ERROR\n");
		return NULL;
	}
	error->write("OK\n");
	return temp;
}

int CNova::Destroy_Movie(CMovie *movie)
{
	error->write("Destroying Movie...");
	if(movie!=NULL)
	{
		if(movie->Destroy()==D_ERROR)
		{
			error->write("ERROR\n");
			return D_ERROR;
		}
	}
	if(movie==NULL)
	{
		error->write("ERROR\n");
		return D_ERROR;
	}
	error->write("OK\n");
	return D_FINE;
}


int CNova::Setup(HINSTANCE hinstance,char title[],int icon)
{
	CoInitialize(NULL);
	error->write("Opening Window...");
	window=new CWindow();
	if(D_ERROR==window->Create_Window(hinstance,title,icon,NO_CURSOR))
	{
		error->write("ERROR\n");
		return D_ERROR;
	}
	error->write("OK\n");

	error->write("Creating Input...");
	input=new CInput();
	if(D_ERROR==input->create(window->Get_HINSTANCE(),window->Get_HWND()))
	{
		error->write("ERROR\n");
		return D_ERROR;
	}
	error->write("OK\n");

	sound=new CSound(64,error);
	if(sound->erro==1)
		return D_ERROR;
	Graphic=new CGraph2D(window->Get_HWND(),this->error);
	if(Graphic->erro==1)
		return D_ERROR;
	num_frames=0;
	start_time=GetTickCount();
	return D_FINE;
}

int CNova::Get_XAxis()
{
	return input->xaxis();
}
int CNova::Get_YAxis()
{
	return input->yaxis();
}
int CNova::Get_ZAxis()
{
	return input->zaxis();
}

int CNova::Destroy()
{
	if(destroyed==0)
	{
		destroyed=1;
		if(Graphic!=NULL)
		{
			delete Graphic;
			Graphic=NULL;
		}
		if(sound!=NULL)
		{
			delete sound;
			sound=NULL;
		}
		if(input!=NULL)
		{
			input->destroy();
			delete input;
			input=NULL;
			error->write("Destroying Input...OK\n");
		}

		if(window!=NULL)
		{
			window->Close_Message();
			message=window->msg;
			delete window;
			window=NULL;
			error->write("Closing Window...OK\n");
		}

		finish_time=GetTickCount();
		DWORD pol=(finish_time-start_time);
		int temp1=0;
		if(pol>1000)
			temp1=(int)pol/1000;
		int temp2=0;
		if(temp1!=0)
			temp2=(int)num_frames/temp1;
		error->write("\nStatistics:\n");
		error->write("Avg FPS: ");
		error->write(temp2);
		error->write("\nNum. Frames: ");
		error->write(num_frames);
		error->write("\nTotal Time (in sec): ");
		error->write(temp1);
		error->write("\n");
		CoUninitialize();
	}
	return D_FINE;
}

CNova::~CNova()
{
	this->Destroy();
	error->write("[END HESH]");
	delete error;
}

int CNova::Loop()
{
	num_frames++;
	if(window->Check_Message()!=D_FINE)
		return D_ERROR;
	if(Graphic->Loop()==D_ERROR)
	{
		error->write("Error occurred when flipping the buffers.\n");
		return D_FINE;
	}
	if(input->get_mouse()!=D_FINE)
	{
		error->write("Error with getting mouse input, probably due to ALT-TAB\n");
		return D_FINE;
	}
	if(input->get_keyboard()!=D_FINE)
		error->write("Error with getting keyboard input, probably due to ALT-TAB\n");
	return D_FINE;
}

MSG CNova::Get_Message()
{
	if(window!=NULL)
	{
		return window->msg;
	}
	return message;
}