// MacStyle.cpp: implementation of the CMacStyle class.
//
//////////////////////////////////////////////////////////////////////

// 
//	This example uses Paul Meidinger's code:
//	CMacButton class, version 1.0
//
//------------------------------------------------------------
//	Copyright (c) 1999 Paul Meidinger (pmmeidinger@yahoo.com)
//
//
// Feel free to modifiy and/or distribute this file, but
// do not remove this header.
//
// I would appreciate a notification of any bugs discovered or 
// improvements that could be made.
//
// This file is provided "as is" with no expressed or implied warranty.
//------------------------------------------------------------
//

#include "stdafx.h"
#include "BCGPSkins.h"
#include "MacStyle.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMacStyle::CMacStyle()
{
	m_nMenuShadowDepth = 3;

	m_brFace.CreateSolidBrush (RGB (221, 221, 221));

	m_crHilight = ::GetSysColor(COLOR_3DHILIGHT);
	m_crFace = RGB (221, 221, 221);
	m_crLiteFace = ::GetSysColor(COLOR_3DLIGHT);
	m_crShadow = ::GetSysColor(COLOR_3DSHADOW);
	m_crDkShadow = ::GetSysColor(COLOR_3DDKSHADOW);

	// Create some intermediate colors. This is done by averaging two colors.
	BYTE byRedFace = GetRValue(m_crFace);
	BYTE byGreenFace = GetGValue(m_crFace);
	BYTE byBlueFace = GetBValue(m_crFace);
	BYTE byRedShadow = GetRValue(m_crShadow);
	BYTE byGreenShadow = GetGValue(m_crShadow);
	BYTE byBlueShadow = GetBValue(m_crShadow);
	BYTE byRedDkShadow = GetRValue(m_crDkShadow);
	BYTE byGreenDkShadow = GetGValue(m_crDkShadow);
	BYTE byBlueDkShadow = GetBValue(m_crDkShadow);

	m_crLiteShadow = RGB(byRedFace + ((byRedShadow - byRedFace) >> 1),
										 byGreenFace + ((byGreenShadow - byGreenFace) >> 1),
										 byBlueFace + ((byBlueShadow - byBlueFace) >> 1));

	m_crDarkDkShadow = RGB(byRedShadow + ((byRedDkShadow - byRedShadow) >> 1),
											byGreenShadow + ((byGreenDkShadow - byGreenShadow) >> 1),
											byBlueShadow + ((byBlueDkShadow - byBlueShadow) >> 1));
}

CMacStyle::~CMacStyle()
{
}

void CMacStyle::OnDrawBarGripper (CDC* pDC, CRect rectGripper, BOOL bHorz,
									   CBCGPBaseControlBar* pBar)
{
	if (m_bmpGrid.GetSafeHandle () == NULL)
	{
		m_bmpGrid.LoadBitmap (IDB_MAC_GRID);
	}

	BOOL bSideBar = pBar->IsKindOf (RUNTIME_CLASS (CBCGPDockingControlBar));

	if (!bSideBar)
	{
		if (bHorz)
		{
			rectGripper.DeflateRect (2, 4);
		}
		else
		{
			rectGripper.DeflateRect (4, 2);
		}
	}
	else
	{
		rectGripper.DeflateRect (2, 2);
	}

	CRect rectText = rectGripper;

	for (int x = rectGripper.left; x < rectGripper.right; x += 9)
	{
		for (int y = rectGripper.top; y < rectGripper.bottom; y += 9)
		{
			pDC->DrawState (CPoint (x, y), 
				CSize (min (9, rectGripper.right - x), min (9, rectGripper.bottom - y)),
				&m_bmpGrid, 0);
		}
	}

	if (bSideBar)
	{
		CRect rectText = rectGripper;

		COLORREF clrTextOld = pDC->SetTextColor (::GetSysColor (COLOR_3DSHADOW));
		COLORREF clrBkOld = pDC->SetBkColor (bSideBar ? m_crFace : RGB (223, 208, 207));
		CFont* pOldFont = (CFont*) pDC->SelectStockObject (DEFAULT_GUI_FONT);

		// Draw caption:
		CString strCaption;
		pBar->GetWindowText (strCaption);

		CString str1 = _T(" ") + strCaption + _T(" ");

		pDC->DrawText (str1, rectText, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

		pDC->SetTextColor (clrTextOld);
		pDC->SetBkColor (clrBkOld);
		pDC->SelectObject (pOldFont);
	}
}
//****************************************************************************************
void CMacStyle::OnFillBarBackground (CDC* pDC, CBCGPBaseControlBar* pBar,
									CRect rectClient, CRect rectClip,
									BOOL bNCArea)
{
	ASSERT_VALID (pDC);
	ASSERT_VALID (pBar);

	if (rectClip.IsRectEmpty ())
	{
		rectClip = rectClient;
	}

	pDC->FillRect (rectClip, &m_brFace);
}
//**************************************************************************************
void CMacStyle::OnDrawSeparator (CDC* pDC, CBCGPBaseControlBar* pBar,
										 CRect rect, BOOL bHorz)
{
	if (!pBar->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		return;
	}

	CRect rectSeparator = rect;

	if (bHorz)
	{
		rectSeparator.left += rectSeparator.Width () / 2 - 1;
		rectSeparator.right = rectSeparator.left + 1;
	}
	else
	{
		rectSeparator.top += rectSeparator.Height () / 2 - 1;
		rectSeparator.bottom = rectSeparator.top + 1;
		rectSeparator.left = CBCGPToolBar::GetMenuImageSize ().cx + 2 * (IMAGE_MARGIN + 2);
	}

	pDC->Draw3dRect (rectSeparator, ::GetSysColor (COLOR_3DSHADOW),
									::GetSysColor (COLOR_3DSHADOW));
}
//**************************************************************************************
void CMacStyle::OnFillButtonInterior (CDC* pDC,
	CBCGPToolbarButton* pButton, CRect rect, CBCGPVisualManager::BCGBUTTON_STATE state)
{
	ASSERT_VALID (pDC);
	ASSERT_VALID (pButton);

	if (pButton->IsKindOf (RUNTIME_CLASS (CBCGPToolbarMenuButton)))
	{
		CBCGPVisualManager::OnFillButtonInterior (pDC, pButton, rect, state);
		return;
	}

	int nSaveDC = pDC->SaveDC();

	if (state == ButtonsIsPressed)
	{
		CBrush brLiteShadow(m_crLiteShadow);
		CBrush *pOldBrush	= (CBrush *)pDC->SelectObject(&brLiteShadow);
		CPen penDkShadow(PS_SOLID, 1, m_crDkShadow);
		CPen *pOldPen = (CPen *)pDC->SelectObject(&penDkShadow);

		pDC->RoundRect(rect, CPoint(6, 6));

		CPen penDarkDkShadow(PS_SOLID, 1, m_crShadow);
		pDC->SelectObject(&penDarkDkShadow);
		pDC->MoveTo(rect.left + 1, rect.bottom - 4);
		pDC->LineTo(rect.left + 1, rect.top + 2);
		pDC->LineTo(rect.left + 2, rect.top + 2);
		pDC->LineTo(rect.left + 2, rect.top + 1);
		pDC->LineTo(rect.right - 3, rect.top + 1);

		pDC->SetPixel(rect.right - 2, rect.top + 2, m_crFace);
		pDC->SetPixel(rect.left + 2, rect.bottom - 2, m_crFace);
		pDC->SetPixel(rect.right - 3, rect.top + 1, m_crShadow);
		pDC->SetPixel(rect.left + 1, rect.bottom - 3, m_crShadow);

		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
	}	// if selected
	else
	{
		CBrush brFace(m_crFace);
		CBrush *pOldBrush	= (CBrush *)pDC->SelectObject(&brFace);
		CPen penDkShadow(PS_SOLID, 1, m_crDkShadow);
		CPen *pOldPen = (CPen *)pDC->SelectObject(&penDkShadow);

		pDC->RoundRect(rect, CPoint(6, 6));

		CPen penHilight(PS_SOLID, 1, m_crHilight);
		pDC->SelectObject(&penHilight);
		pDC->MoveTo(rect.left + 2, rect.bottom - 4);
		pDC->LineTo(rect.left + 2, rect.top + 2);
		pDC->LineTo(rect.right - 3, rect.top + 2);
		pDC->SetPixel(rect.left + 3, rect.top + 3, m_crHilight);

		pDC->SetPixel(rect.left, rect.top + 2, m_crDarkDkShadow);
		pDC->SetPixel(rect.left + 2, rect.top, m_crDarkDkShadow);
		pDC->SetPixel(rect.right - 3, rect.top, m_crDarkDkShadow);
		pDC->SetPixel(rect.right - 1, rect.top + 2, m_crDarkDkShadow);
		pDC->SetPixel(rect.right - 1, rect.bottom - 3, m_crDarkDkShadow);
		pDC->SetPixel(rect.right - 3, rect.bottom - 1, m_crDarkDkShadow);
		pDC->SetPixel(rect.left + 2, rect.bottom - 1, m_crDarkDkShadow);
		pDC->SetPixel(rect.left, rect.bottom - 3, m_crDarkDkShadow);

		pDC->SetPixel(rect.left + 1, rect.top + 2, m_crLiteShadow);
		pDC->SetPixel(rect.left + 2, rect.top + 1, m_crLiteShadow);
		pDC->SetPixel(rect.right - 3, rect.top + 1, m_crLiteShadow);
		pDC->SetPixel(rect.right - 2, rect.top + 2, m_crLiteShadow);
		pDC->SetPixel(rect.left + 2, rect.bottom - 2, m_crLiteShadow);
		pDC->SetPixel(rect.left + 1, rect.bottom - 3, m_crLiteShadow);

		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
	}	// else if not selected

	pDC->SetPixel(rect.left, rect.top + 2, m_crDarkDkShadow);
	pDC->SetPixel(rect.left + 2, rect.top, m_crDarkDkShadow);
	pDC->SetPixel(rect.right - 3, rect.top, m_crDarkDkShadow);
	pDC->SetPixel(rect.right - 1, rect.top + 2, m_crDarkDkShadow);
	pDC->SetPixel(rect.right - 1, rect.bottom - 3, m_crDarkDkShadow);
	pDC->SetPixel(rect.right - 3, rect.bottom - 1, m_crDarkDkShadow);
	pDC->SetPixel(rect.left + 2, rect.bottom - 1, m_crDarkDkShadow);
	pDC->SetPixel(rect.left, rect.bottom - 3, m_crDarkDkShadow);

	pDC->RestoreDC(nSaveDC);
}
//**************************************************************************************
void CMacStyle::OnDrawButtonBorder (CDC* pDC,
		CBCGPToolbarButton* pButton, CRect rect, BCGBUTTON_STATE state)
{
	ASSERT_VALID (pDC);
	ASSERT_VALID (pButton);

	if (pButton->IsKindOf (RUNTIME_CLASS (CBCGPToolbarMenuButton)))
	{
		CBCGPVisualManager::OnDrawButtonBorder (pDC, pButton, rect, state);
	}
}
//**************************************************************************************
void CMacStyle::OnDrawCaptionButton (CDC* pDC, CBCGPCaptionButton* pButton,  BOOL bActive,
									 BOOL bHorz, BOOL bMaximized, BOOL bDisabled)
{
	CRect rect = pButton->GetRect ();

	UINT uiBmpID = IDB_BTN_MAC;
	if (pButton->m_bPushed || pButton->m_bFocused)
	{
		switch (pButton->m_nHit)
		{
		case HTCLOSE_BCG:
			uiBmpID = IDB_CLOSE_MAC;
			break;
		}
	}

	CBitmap bmp;
	bmp.LoadBitmap (uiBmpID);

	if (pButton->m_bPushed && pButton->m_bFocused)
	{
		rect.OffsetRect (1, 1);
	}

	pDC->DrawState (rect.TopLeft (), CSize (13, 13), &bmp, 0);
}
//***************************************************************************************
void CMacStyle::OnEraseTabsArea (CDC* pDC, CRect rect, const CBCGPBaseTabWnd* /*pTabWnd*/)
{
	ASSERT_VALID (pDC);
	pDC->FillRect (rect, &m_brFace);
}
//****************************************************************************************
COLORREF CMacStyle::OnDrawControlBarCaption (CDC* pDC, CBCGPDockingControlBar* /*pBar*/, 
	BOOL /*bActive*/, CRect rectCaption, CRect /*rectButtons*/)
{
	pDC->FillRect (rectCaption, &m_brFace);
	return RGB (0, 0, 0);
}
