// BCGPSkins.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "BCGPSkins.h"

#include "MainFrm.h"
#include "BCGPSkinsDoc.h"
#include "BCGPSkinsView.h"
#include "MacStyle.h"
#include "FunnyStyle.h"
#include "ImageStyle.h"
#include "BackgndImageDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBCGPSkinsApp

BEGIN_MESSAGE_MAP(CBCGPSkinsApp, CWinApp)
	//{{AFX_MSG_MAP(CBCGPSkinsApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBCGPSkinsApp construction

CBCGPSkinsApp::CBCGPSkinsApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CBCGPSkinsApp object

CBCGPSkinsApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CBCGPSkinsApp initialization

BOOL CBCGPSkinsApp::InitInstance()
{
	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("BCGSoft\\BCGControlBarPro\\Examples"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	SetRegistryBase (_T("Settings"));

	// Initialize all Managers for usage. They are automatically constructed
	// if not yet present
	InitContextMenuManager();
	InitKeyboardManager();

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CBCGPSkinsDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CBCGPSkinsView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	LoadCustomState ();

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CBCGPSkinsApp message handlers

int CBCGPSkinsApp::ExitInstance() 
{
	if (CBCGPVisualManager::GetInstance () != NULL)
	{
		delete CBCGPVisualManager::GetInstance ();
	}

	BCGCBProCleanUp();
	return CWinApp::ExitInstance();
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CBCGPURLLinkButton	m_bntURL;
	CBCGPURLLinkButton	m_btnMail;
	CString	m_strVersion;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_strVersion = _T("");
	//}}AFX_DATA_INIT
	m_strVersion.Format (_T("%d.%d"), _BCGCBPRO_VERSION_MAJOR, _BCGCBPRO_VERSION_MINOR);
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_URL, m_bntURL);
	DDX_Control(pDX, IDC_MAIL, m_btnMail);
	DDX_Text(pDX, IDC_VERSION, m_strVersion);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CBCGPSkinsApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_btnMail.SetURLPrefix (_T("mailto:"));
	m_btnMail.SetURL (_T("info@bcgsoft.com"));
	m_btnMail.SizeToContent ();
	m_btnMail.SetTooltip (_T("Send mail to author"));

	m_bntURL.SizeToContent ();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CBCGPSkinsApp::PreLoadState ()
{
}

void CBCGPSkinsApp::SetSkin (int iIndex)
{
	if (iIndex < 0 || iIndex > 4)
	{
		MessageBeep ((UINT)-1);
		return;
	}

	static CString strImagePath;
	static BOOL bInternalImage = TRUE;
	static int nBright = 100;

	if (iIndex == 4)
	{
		// Choose background image:
		CBackgndImageDlg dlg;
		dlg.m_strFilePath = strImagePath;
		dlg.m_iImageType = bInternalImage ? 0 : 1;
		dlg.m_iBright = nBright;

		if (dlg.DoModal () == IDOK)
		{
			strImagePath = dlg.m_strFilePath;
			bInternalImage = dlg.m_iImageType == 0;
			nBright = dlg.m_iBright;
		}
	}

	if (CBCGPVisualManager::GetInstance () != NULL)
	{
		delete CBCGPVisualManager::GetInstance ();
	}

	switch (iIndex)
	{
	case 0:
		CBCGPVisualManager::SetDefaultManager (NULL);
		break;

	case 1:
		// Starting version 5.5, CBCGVisualManagerXP is a part of library
		CBCGPVisualManager::SetDefaultManager (RUNTIME_CLASS (CBCGPVisualManagerXP));
		break;

	case 2:
		new CMacStyle ();
		break;

	case 3:
		new CFunnyStyle ();
		break;

	case 4:
		new CImageStyle (bInternalImage ? _T("") : strImagePath, nBright);
		break;
	}

	CBCGPVisualManager::GetInstance ()->SetLook2000 ();
	CBCGPVisualManager::GetInstance ()->RedrawAll ();
}

