// Page6.cpp : implementation file
//

#include "stdafx.h"
#include "bcgpcontrols.h"
#include "Page6.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DTPICKER_DATE_TIME			0
#define DTPICKER_DATE				1
#define DTPICKER_TIME				2

#define DTPICKER_TIME_FORMAT_LOCALE	0
#define DTPICKER_TIME_FORMAT_24		1
#define DTPICKER_TIME_FORMAT_12		2

/////////////////////////////////////////////////////////////////////////////
// CPage6 property page

IMPLEMENT_DYNCREATE(CPage6, CBCGPPropertyPage)

CPage6::CPage6() : CBCGPPropertyPage(CPage6::IDD)
{
	//{{AFX_DATA_INIT(CPage6)
	m_bDurationDays = TRUE;
	m_bDurationHours = TRUE;
	m_bDurationSpin = TRUE;
	m_bDateTimeCheckBox = TRUE;
	m_bDateTimeDrop = TRUE;
	m_bDateTimeSpin = TRUE;
	m_bCalendarNavigationButtons = TRUE;
	m_bCalendarMultSel = TRUE;
	m_bCalendarShowWeekNumber = TRUE;
	m_bCalendarDayOfWeekSel = TRUE;
	m_nDateTimeParts = DTPICKER_DATE_TIME;
	m_nTimeFormat = DTPICKER_TIME_FORMAT_LOCALE;
	//}}AFX_DATA_INIT
}

CPage6::~CPage6()
{
}

void CPage6::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPage6)
	DDX_Control(pDX, IDC_CALENDARBAR_WEEKBND, m_wndCalendarBarDayOfWeekSel);
	DDX_Control(pDX, IDC_WEEKSTART, m_weekStart);
	DDX_Control(pDX, IDC_DURATION, m_wndDuration);
	DDX_Control(pDX, IDC_DATETIMEPICKER1, m_wndDateTimePicker);
	DDX_Control(pDX, IDC_CALENDARLOCATION, m_calendarLocation);
	DDX_Check(pDX, IDC_CHECKDAYS, m_bDurationDays);
	DDX_Check(pDX, IDC_CHECKHOURS, m_bDurationHours);
	DDX_Check(pDX, IDC_CHECKSPIN, m_bDurationSpin);
	DDX_Check(pDX, IDC_CAL_CHKBOX, m_bDateTimeCheckBox);
	DDX_Check(pDX, IDC_CAL_DROPBTN, m_bDateTimeDrop);
	DDX_Check(pDX, IDC_CAL_SPIN, m_bDateTimeSpin);
	DDX_Check(pDX, IDC_CALENDARBAR_ENABLE, m_bCalendarNavigationButtons);
	DDX_Check(pDX, IDC_CALENDARBAR_MULTY, m_bCalendarMultSel);
	DDX_Check(pDX, IDC_CALENDARBAR_WEEKNOBND, m_bCalendarShowWeekNumber);
	DDX_Check(pDX, IDC_CALENDARBAR_WEEKBND, m_bCalendarDayOfWeekSel);
	DDX_Radio(pDX, IDC_DATETIME_PARTS, m_nDateTimeParts);
	DDX_Radio(pDX, IDC_TIME_FORMAT, m_nTimeFormat);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPage6, CBCGPPropertyPage)
	//{{AFX_MSG_MAP(CPage6)
	ON_BN_CLICKED(IDC_CHECKDAYS, SetDurationState)
	ON_BN_CLICKED(IDC_DURATION, OnDuration)
	ON_BN_CLICKED(IDC_CAL_CHKBOX, SetDateTimeState)
	ON_BN_CLICKED(IDC_DATETIMEPICKER1, OnDatetimepicker)
	ON_BN_CLICKED(IDC_CALENDARBAR_WEEKBND, SetCalendarBarSate)
	ON_CBN_SELCHANGE(IDC_WEEKSTART, OnSelchangeWeekstart)
	ON_BN_CLICKED(IDC_DATETIME_PARTS, SetDateTimeState)
	ON_BN_CLICKED(IDC_CHECKHOURS, SetDurationState)
	ON_BN_CLICKED(IDC_CHECKSPIN, SetDurationState)
	ON_BN_CLICKED(IDC_CAL_DROPBTN, SetDateTimeState)
	ON_BN_CLICKED(IDC_CAL_SPIN, SetDateTimeState)
	ON_BN_CLICKED(IDC_CALENDARBAR_ENABLE, SetCalendarBarSate)
	ON_BN_CLICKED(IDC_CALENDARBAR_MULTY, SetCalendarBarSate)
	ON_BN_CLICKED(IDC_CALENDARBAR_WEEKNOBND, SetCalendarBarSate)
	ON_BN_CLICKED(IDC_DATETIME_PARTS2, SetDateTimeState)
	ON_BN_CLICKED(IDC_DATETIME_PARTS3, SetDateTimeState)
	ON_BN_CLICKED(IDC_TIME_FORMAT, SetDateTimeState)
	ON_BN_CLICKED(IDC_TIME_FORMAT2, SetDateTimeState)
	ON_BN_CLICKED(IDC_TIME_FORMAT3, SetDateTimeState)
	//}}AFX_MSG_MAP
	ON_REGISTERED_MESSAGE(BCGM_CALENDAR_ON_SELCHANGED, OnCalendarSelectionChanged)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPage6 message handlers

BOOL CPage6::OnInitDialog() 
{
	CBCGPPropertyPage::OnInitDialog();
	
	//-------------------------
	// Create Calendar Control:
	//-------------------------
	CRect rectCalendar;
	m_calendarLocation.GetClientRect (&rectCalendar);
	m_calendarLocation.MapWindowPoints (this, &rectCalendar);

	m_wndCalendarCtrl.CreateControl (this, rectCalendar, (UINT)-1, TRUE);

	CList<int, int> lstMarkedDays;
	lstMarkedDays.AddTail (3);
	lstMarkedDays.AddTail (7);
	lstMarkedDays.AddTail (11);
	lstMarkedDays.AddTail (19);
	lstMarkedDays.AddTail (23);

	m_wndCalendarCtrl.MarkDays (lstMarkedDays);

	//-----------------------------
	// Initialize Date/time picker:
	//-----------------------------
	SetDateTimeState ();
	m_wndDateTimePicker.SizeToContent();

	SetDurationState ();

	//----------------------------
	// Fill "Week Days" combo box:
	//----------------------------
	COleDateTime t = COleDateTime::GetCurrentTime ();
	COleDateTimeSpan sp (t.GetDayOfWeek () - 1, 0, 0, 0);
	t -= sp;

	COleDateTimeSpan oneDay (1, 0, 0, 0);
	for (int i = 0; i < 7; i ++)
	{
		m_weekStart.AddString (t.Format (_T("%A")));
		t += oneDay;
	}

	m_weekStart.SetCurSel (m_wndCalendarCtrl.GetFirstDayOfWeek ());

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//**************************************************************************************
void CPage6::SetDurationState()
{
	UpdateData ();

	UINT showFlags = 0;

	if (m_bDurationDays)
	{
		showFlags |= CBCGPDurationCtrl::DRTN_DAYS;
	}

	if (m_bDurationHours)
	{
		showFlags |= CBCGPDurationCtrl::DRTN_HOURS_MINS;
	}

	if (m_bDurationSpin)
	{
		showFlags |= CBCGPDurationCtrl::DRTN_SPIN;
	}

	const UINT showMask = 
		CBCGPDurationCtrl::DRTN_DAYS | 
		CBCGPDurationCtrl::DRTN_HOURS_MINS | 
		CBCGPDurationCtrl::DRTN_SPIN;

	m_wndDuration.SetState (showFlags, showMask);

	OnDuration ();
}
//***************************************************************************************
void CPage6::OnDuration() 
{
	COleDateTimeSpan dts = m_wndDuration.GetDuration();
//	m_strDuration.Format(_T("%ld"), dts.GetDays ());
//	m_strDuration += dts.Format(_T(" day(s) %H:%M"));
	UpdateData(FALSE);
}
//***************************************************************************************
void CPage6::SetDateTimeState() 
{
	UpdateData();

	UINT stateFlags = 0;

	if (m_bDateTimeSpin)
	{
		stateFlags |= CBCGPDateTimeCtrl::DTM_SPIN;
	}

	if (m_bDateTimeDrop)
	{
		stateFlags |= CBCGPDateTimeCtrl::DTM_DROPCALENDAR;
	}

	if (m_bDateTimeCheckBox)
	{
		stateFlags |= CBCGPDateTimeCtrl::DTM_CHECKBOX;
	}

	switch (m_nDateTimeParts)
	{
	case DTPICKER_DATE_TIME:
		stateFlags |= (CBCGPDateTimeCtrl::DTM_DATE | CBCGPDateTimeCtrl::DTM_TIME);
		break;

	case DTPICKER_DATE:
		stateFlags |= CBCGPDateTimeCtrl::DTM_DATE;
		break;

	case DTPICKER_TIME:
		stateFlags |= CBCGPDateTimeCtrl::DTM_TIME;
		break;
	}

	switch (m_nTimeFormat)
	{
	case DTPICKER_TIME_FORMAT_LOCALE:
		stateFlags |= CBCGPDateTimeCtrl::DTM_TIME24HBYLOCALE;
		break;

	case DTPICKER_TIME_FORMAT_24:
		stateFlags |= CBCGPDateTimeCtrl::DTM_TIME24H;
		break;
	}

	const UINT stateMask = 
		CBCGPDateTimeCtrl::DTM_SPIN |
		CBCGPDateTimeCtrl::DTM_DROPCALENDAR | 
		CBCGPDateTimeCtrl::DTM_DATE |
		CBCGPDateTimeCtrl::DTM_TIME24H |
		CBCGPDateTimeCtrl::DTM_CHECKBOX |
		CBCGPDateTimeCtrl::DTM_TIME | 
		CBCGPDateTimeCtrl::DTM_TIME24HBYLOCALE;

	m_wndDateTimePicker.SetState (stateFlags, stateMask);
	OnDatetimepicker();
}
//***************************************************************************************
void CPage6::OnDatetimepicker() 
{
	COleDateTime dt = m_wndDateTimePicker.GetDate();
	//m_strDateTime = dt.Format(_T("%#x %X"));
	UpdateData(FALSE);
}
//***************************************************************************************
LRESULT CPage6::OnCalendarSelectionChanged(WPARAM wParam, LPARAM lParam) 
{
	if ((HWND) lParam == m_wndCalendarCtrl.GetSafeHwnd ())
	{
		const CList<int, int>& lstSelDays = m_wndCalendarCtrl.GetSelectedDays ();
		
		CString str;
		str.Format(_T("Selected %d day(s)"), lstSelDays.GetCount ());
	}

	return 0;
}
//****************************************************************************************
void CPage6::SetCalendarBarSate() 
{
	UpdateData();

	UINT stateFlags = CBCGPCalendarBar::CBR_ENABLED;

	if (m_bCalendarNavigationButtons)
	{
		stateFlags |= CBCGPCalendarBar::CBR_NAVIGATION_BUTTONS;
	}

	if (m_bCalendarMultSel)
	{
		stateFlags |= CBCGPCalendarBar::CBR_MULTISELECTION;
	}

	if (m_bCalendarShowWeekNumber)
	{
		stateFlags |= CBCGPCalendarBar::CBR_WEEKNUMBER;
	}

	if (m_bCalendarDayOfWeekSel)
	{
		stateFlags |= CBCGPCalendarBar::CBR_WEEKDAYSEL;
	}

	const UINT stateMask = 
				CBCGPCalendarBar::CBR_WEEKDAYSEL |
				CBCGPCalendarBar::CBR_WEEKNUMBER |
				CBCGPCalendarBar::CBR_MULTISELECTION |
				CBCGPCalendarBar::CBR_ENABLED |
				CBCGPCalendarBar::CBR_NAVIGATION_BUTTONS;

	m_wndCalendarCtrl.SetState (stateFlags, stateMask);

	m_wndCalendarBarDayOfWeekSel.EnableWindow (m_bCalendarMultSel);
}
//**************************************************************************************
void CPage6::OnSelchangeWeekstart() 
{
	int nDay = m_weekStart.GetCurSel ();

	m_wndCalendarCtrl.SetFirstDayOfWeek (nDay);
    m_wndDateTimePicker.SetFirstDayOfWeek (nDay);
}
