// BCGCBDotNetExample.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "BCGCBDotNetExample.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "BCGCBDotNetExampleDoc.h"
#include "BCGCBDotNetExampleView.h"
#include "StartView.h"
#include "BCGPVisualManagerXP.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBCGCBDotNetExampleApp

BEGIN_MESSAGE_MAP(CBCGCBDotNetExampleApp, CWinApp)
	//{{AFX_MSG_MAP(CBCGCBDotNetExampleApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_HELP_SHOW_START, OnHelpShowStart)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBCGCBDotNetExampleApp construction

CBCGCBDotNetExampleApp::CBCGCBDotNetExampleApp() :
	CBCGPWorkspace (TRUE)
{
	m_pStartDocTemplate = NULL;
	m_pDocTemplateCpp = NULL;
	m_pDocTemplateWeb = NULL;
}

CBCGCBDotNetExampleApp::~CBCGCBDotNetExampleApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CBCGCBDotNetExampleApp object

CBCGCBDotNetExampleApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CBCGCBDotNetExampleApp initialization

BOOL CBCGCBDotNetExampleApp::InitInstance()
{
	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

 	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("BCGSoft\\BCGControlBarPro\\Examples"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	SetRegistryBase (_T("Settings"));

	// Initialize all Managers for usage. They are automatically constructed
	// if not yet present
	InitMouseManager();
	InitContextMenuManager();
	InitKeyboardManager();

	EnableUserTools (ID_TOOLS_ENTRY, ID_USER_TOOL1, ID_USER_TOOL10, 
					RUNTIME_CLASS (CBCGPUserTool), IDR_MENU_ARGS, IDR_MENU_DIRS);

#ifndef _BCGCBPRO_STATIC_
	InitSkinManager ();

	GetSkinManager ()->EnableSkinsDownload (_T("http://www.bcgsoft.com/Skins"));
#endif

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	m_pDocTemplateCpp = new CMultiDocTemplate(
		IDR_BCGDEVTYPE_CPP,
		RUNTIME_CLASS(CBCGCBDotNetExampleDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CBCGCBDotNetExampleView));
	AddDocTemplate (m_pDocTemplateCpp);

	m_pDocTemplateWeb = new CMultiDocTemplate(
		IDR_BCGDEVTYPE_WEB,
		RUNTIME_CLASS(CBCGCBDotNetExampleDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CBCGCBDotNetExampleView));
	AddDocTemplate (m_pDocTemplateWeb);

	m_pStartDocTemplate = new CMultiDocTemplate(
		IDR_BCGDEVTYPE0,
		RUNTIME_CLASS(CBCGCBDotNetExampleDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CStartView));
	AddDocTemplate (m_pStartDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	if (cmdInfo.m_nShellCommand == CCommandLineInfo::FileNew)
	{
		m_pStartDocTemplate->OpenDocumentFile (NULL);
	}
	else
	{
		// Dispatch commands specified on the command line
		if (!ProcessShellCommand(cmdInfo))
			return FALSE;
	}

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CBCGPButton	m_btnOk;
	CBCGPURLLinkButton	m_bntURL;
	CBCGPURLLinkButton	m_btnMail;
	CString	m_strVersion;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_strVersion = _T("");
	//}}AFX_DATA_INIT

	m_strVersion.Format (_T("%d.%d"), _BCGCBPRO_VERSION_MAJOR, _BCGCBPRO_VERSION_MINOR);
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDOK, m_btnOk);
	DDX_Control(pDX, IDC_URL, m_bntURL);
	DDX_Control(pDX, IDC_MAIL, m_btnMail);
	DDX_Text(pDX, IDC_VERSION, m_strVersion);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CBCGCBDotNetExampleApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// Customization load/save methods

void CBCGCBDotNetExampleApp::PreLoadState ()
{
	GetMouseManager()->AddView (IDR_BCGDEVTYPE0, _T("My view"), IDR_BCGDEVTYPE0);
	// TODO: add another views and windows were mouse double click
	// customization is required

	GetContextMenuManager()->AddMenu (_T("Edit Context menu"), IDR_CONTEXT_MENU);
	GetContextMenuManager()->AddMenu (_T("Edit Left Bar menu"), IDR_POPUP_SELECTIONMARGIN);
	GetContextMenuManager()->AddMenu (_T("Main Window Area menu"), IDR_POPUP_MAIN_AREA);
	GetContextMenuManager()->AddMenu (_T("Resource"), IDR_POPUP_RESOURCE);
	GetContextMenuManager()->AddMenu (_T("Solution Explorer"), IDR_POPUP_SOLUTION);
	GetContextMenuManager()->AddMenu (_T("MDI Tabs menu"), IDR_POPUP_MDITABS);
}

void CBCGCBDotNetExampleApp::LoadCustomState ()
{
}

void CBCGCBDotNetExampleApp::SaveCustomState ()
{
}

/////////////////////////////////////////////////////////////////////////////
// CBCGCBDotNetExampleApp message handlers

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_btnMail.SetURLPrefix (_T("mailto:"));
	m_btnMail.SetURL (_T("info@bcgsoft.com"));
	m_btnMail.SizeToContent ();
	m_btnMail.SetTooltip (_T("Send mail to author"));

	m_bntURL.SizeToContent ();

	m_btnOk.m_nFlatStyle = CBCGPButton::BUTTONSTYLE_SEMIFLAT;
	m_btnOk.SetImage (IDB_CHECK);
	m_btnOk.SizeToContent ();
	m_btnOk.SetTooltip (_T("Click to close"));
	m_btnOk.SetMouseCursorHand ();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

int CBCGCBDotNetExampleApp::ExitInstance() 
{
	BCGCBProCleanUp ();
	return CWinApp::ExitInstance();
}

void CBCGCBDotNetExampleApp::OnHelpShowStart() 
{
	ASSERT_VALID (m_pStartDocTemplate);

	POSITION pos = m_pStartDocTemplate->GetFirstDocPosition ();
	if (pos == NULL)
	{
		m_pStartDocTemplate->OpenDocumentFile(NULL);
		return;
	}

	CDocument* pDoc = m_pStartDocTemplate->GetNextDoc (pos);
	ASSERT_VALID (pDoc);

	pos = pDoc->GetFirstViewPosition ();
	ASSERT (pos != NULL);

	CView* pView = pDoc->GetNextView (pos);
	ASSERT_VALID (pView);

	CFrameWnd* pFrame = pView->GetParentFrame ();
	ASSERT_VALID (pFrame);

	CMainFrame* pMainFrame = (CMainFrame*) AfxGetMainWnd ();
	ASSERT_VALID (pMainFrame);

	::SendMessage (pMainFrame->m_hWndMDIClient, WM_MDIACTIVATE,
				(WPARAM) pFrame->GetSafeHwnd (), 0);
}
