/*
    SimpleAIM
    A miniature console AIM client
    http://simpleaim.sourceforge.net
    Copyright (C) 2002
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  */


/**
 * The main driver class for the SimpleAIM program.
 *
 * @author   simpleaim.sourceforge.net.
 */
public class SimpleAIM {

    /**
     * The entry point for the SimpleAIM class.
     *
     * @param args The command line arguments.
     */
    public static void main(String[] args) {

        /*
            testing for the right parameters
            for now we've only got -d
          */
        parseCommandArgs(args);

        Operations op = new Operations();

        /*
            initialize the connection
            if the init code succeeds it returns true
            else returns false
          */
        boolean success = op.connect();
        if (success == false) {
            return;
        }

        /*
            begin processing I/O
          */
        InHandler inThread = new InHandler();
        OutHandler outThread = new OutHandler();

        inThread.start();
        outThread.start();
    }



    /**
     * Parses command line arguments and sets appropriate variables.
     *
     * @param args The command line arguments.
     */
    private static void parseCommandArgs(String[] args) {

        if (args.length == 1 && args[0].equals("-d")) {
            Operations.DEBUG = true;
        } else if (args.length >= 1) {
            System.out.println("Usage: execute with -d flag to enable debugging output");
            return;
        }
    }

}
