/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;

import stec.iws.Utils;
import stec.iws.iws;
import stec.iws.Request;
import stec.iws.Response;

public class PageCounterServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		try
		{
			PrintWriter writer = _response.getWriter();

			writer.println("<html>");
			writer.println("<head><title>Page Counter Servlet</title></head>");
			writer.println("<body>");
			writer.println("<h1>Page Counter Servlet</h1>");
			writer.println("This page was accessed " + pageCounter(_request) + " times.");
			writer.println("<p>");
			writer.println("[ <a href=\"./pagecounter.html\">refresh</a> ]");
			writer.println("</body>");
			writer.println("</html>");
		}
		catch(Exception ex)
		{
			throw new ServletException(ex.getMessage());
		}
	}

	private int pageCounter(Request _request) throws Exception
	{
		String url = _request.getServletPath();
		if(url == null)
		{
			url = _request.getPathTranslated();
		}

		Properties props = new Properties();

		int pageCounter;

		String basedir = iws.getWorkDirectory("./samples/servlets");
		File fh = new File(basedir, "page_counters.dat");
		if(fh.exists())
		{
			FileInputStream is = new FileInputStream(fh);
			props.load(is);
			is.close();

			pageCounter = Integer.parseInt(props.getProperty(url, "0")) + 1;
		}
		else
		{
			pageCounter = 1;
		}

		props.put(url, String.valueOf(pageCounter));

		FileOutputStream os = new FileOutputStream(fh);
		props.save(os, "page counters");
		os.close();

		return pageCounter;
	}
}
