/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.ServletContext;

import stec.iws.Request;
import stec.iws.Response;

public class DumpServletContextServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		ServletContext servlet_context = getServletContext();

		String key;
		String value;

		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Dump Servlet Context Servlet</title></head>");
		writer.println("<body>");

		writer.println("<h1>Dump Servlet Context Servlet</h1>");

		writer.println("<hr>");

		writer.println("Servlet Name: " + getServletName() + "<br>");
		writer.println("Servlet Context Path: " + _request.getContextPath());

		dump_servlet_context(writer, servlet_context);

		writer.println("<hr>");

		writer.println("<a href=\"./servletcontexttester.html\">Servlet Context Tester</a>");

		writer.println("</body>");
		writer.println("</html>");
	}

	public static void dump_servlet_context(PrintWriter writer, ServletContext servlet_context) throws IOException
	{
		writer.println("<p>Parameters: <br>");

		String key;
		String value;

		Enumeration e = servlet_context.getInitParameterNames();
		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();
			value = servlet_context.getInitParameter(key);

			writer.println(key + " = [" + value + "]<br>");
		}

		writer.println("<p>");
		writer.println("Attributes: <br>");

		Object obj;

		e = servlet_context.getAttributeNames();
		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();

			obj = servlet_context.getAttribute(key);
			if(obj instanceof File)
			{
				value = ((File)obj).getCanonicalPath();
			}
			else if(obj instanceof String)
			{
				value = (String)obj;
			}
			else
			{
				value = obj.toString();
			}

			writer.println(key + " = [" + value + "]<br>");
		}
	}
}
