/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;
import java.util.Locale;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.File;

import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;

import stec.lang.DString;

import stec.iws.ServletConfigImpl;
import stec.iws.Utils;
import stec.iws.Request;
import stec.iws.Response;

public class DumpServlet extends BaseServlet
{
	public void service(Request request, Response response) throws ServletException, IOException
	{
		PrintWriter writer = response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Dump Servlet</title></head>");
		writer.println("<body>");

		ArgsServlet.args(writer, request, response);

		dumpServlet(writer, this);
		dumpRequest(writer, request, response);
		dumpServletContext(writer);

		writer.println("</body>");
		writer.println("</html>");
	}

	protected void dumpServlet(PrintWriter writer, GenericServlet servlet) throws IOException
	{
		writer.println("<h1>Servlet:</h1>");

		writer.println("name = " + servlet.getServletName() + "<br>");
		writer.println("info = " + servlet.getServletInfo() + "<br>");

		dumpInitParams(writer);
	}

	protected void dumpRequest(PrintWriter writer, Request request, Response response) throws IOException
	{
		writer.println("<h1>Request:</h1>");

		writer.println("method = " + request.getMethod() + "<br>");
		writer.println("content length = " + request.getContentLength() + "<br>");
		writer.println("character encoding = " + request.getCharacterEncoding() + "<br>");
		writer.println("character type = " + request.getContentType() + "<br>");
		writer.println("is secure = " + request.isSecure() + "<br>");
		writer.println("context path = " + request.getContextPath() + "<br>");
		writer.println("real path[.] = " + request.getRealPath(".") + "<br>");
		writer.println("real path[/] = " + request.getRealPath("/") + "<br>");
		writer.println("auth type = " + request.getAuthType() + "<br>");
		writer.println("method = " + request.getMethod() + "<br>");
		writer.println("path info = " + request.getPathInfo() + "<br>");
		writer.println("path translated = " + request.getPathTranslated() + "<br>");
		writer.println("query string = " + request.getQueryString() + "<br>");
		writer.println("request uri = " + request.getRequestURI() + "<br>");
		writer.println("servlet path = " + request.getServletPath() + "<br>");
		writer.println("local addr = " + request.getLocalAddr() + "<br>");
		writer.println("protocol = " + request.getProtocol() + "<br>");
		writer.println("remote addr = " + request.getRemoteAddr() + "<br>");
		writer.println("remote host = " + request.getRemoteHost() + "<br>");
		writer.println("scheme = " + request.getScheme() + "<br>");
		writer.println("server name = " + request.getServerName() + "<br>");
		writer.println("server port = " + request.getServerPort() + "<br>");
		writer.println("remote user = " + request.getRemoteUser() + "<br>");

		dumpLocales(writer, request);

		dumpFormData(writer, request);
		dumpCookies(writer, request, response);
		dumpAttributes(writer, request);
	}

	protected void dumpLocales(PrintWriter writer, Request request) throws IOException
	{
		writer.print("locales = ");

		Locale locale;

		Enumeration e = request.getLocales();

		while(e.hasMoreElements())
		{
			writer.print(" " + e.nextElement());
		}

		writer.println("<br>");
	}

	protected void dumpAttributes(PrintWriter writer, Request request) throws IOException
	{
		writer.println("<h1>Attributes:</h1>");

		String key;

		Enumeration e = request.getAttributeNames();

		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();
			writer.println(key + " = " + request.getAttribute(key) + "<br>");
		}
	}

	protected void dumpInitParams(PrintWriter writer) throws IOException
	{
		writer.println("<h1>Init Parameters:</h1>");

		String key;
		String values[];

		ServletConfigImpl config = (ServletConfigImpl)getServletConfig();

		Enumeration e = config.getInitParameterNames();

		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();
			values = config.getInitParameterValues(key);
			for(int i = 0; i < values.length; i++)
			{
				writer.println(key + "(" + i + ") = " + values[i] + "<br>");
			}
		}
	}

	protected static void dumpFormData(PrintWriter writer, Request request) throws IOException
	{
		writer.println("<h1>Form Data:</h1>");

		String key;
		String values[];

		Enumeration e = request.getParameterNames();

		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();
			values = request.getParameterValues(key);
			for(int i = 0; i < values.length; i++)
			{
				writer.println(key + "(" + i + ") = " + values[i] + "<br>");
			}
		}
	}

	protected static void dumpCookies(PrintWriter writer, Request request, Response response) throws IOException
	{
		writer.println("<h1>Cookies:</h1>");

		String charset = response.getCharacterEncoding();

		Cookie cookies[] = request.getCookies();

		for(int i = 0; i < cookies.length; i++)
		{
			writer.println(Utils.decodeURL(cookies[i].getName(), charset) + " = " + Utils.decodeURL(cookies[i].getValue(), charset) + "<br>");
		}
	}

	protected static void headers(PrintWriter writer, Request _request) throws IOException
	{
		writer.println("<h1>Headers:</h1>");

		Enumeration values;
		String key;

		Enumeration headers = _request.getHeaderNames();
		while(headers.hasMoreElements())
		{
			key = (String)headers.nextElement();
			values = _request.getHeaders(key);
			while(values.hasMoreElements())
			{
				writer.println(key + " = " + values.nextElement() + "<br>");
			}
		}
	}

	public void dumpServletContext(PrintWriter writer) throws IOException
	{
		writer.println("<h1>Servlet Context:</h1>");

		ServletContext servlet_context = getServletContext();

		writer.println("<h1>Parameters:</h1>");
		writer.println("major version = " + servlet_context.getMajorVersion() + "<br>");
		writer.println("minor version = " + servlet_context.getMinorVersion() + "<br>");
		writer.println("server info = " + servlet_context.getServerInfo() + "<br>");
		writer.println("real path[.] = " + servlet_context.getRealPath(".") + "<br>");
		writer.println("real path[/] = " + servlet_context.getRealPath("/") + "<br>");

		String key;
		String value;

		Enumeration e = servlet_context.getInitParameterNames();
		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();
			value = servlet_context.getInitParameter(key);

			writer.println(key + " = [" + value + "]<br>");
		}

		writer.println("<h1>Attributes:</h1>");

		Object obj;

		e = servlet_context.getAttributeNames();
		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();

			obj = servlet_context.getAttribute(key);
			if(obj instanceof File)
			{
				value = ((File)obj).getCanonicalPath();
			}
			else if(obj instanceof String)
			{
				value = (String)obj;
			}
			else
			{
				value = obj.toString();
			}

			writer.println(key + " = [" + value + "]<br>");
		}
	}
}
