/*
 * Decompiled with CFR 0.152.
 */
package smp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import smp.Logger;
import smp.PageRecord;
import smp.SMPApplet;

public class ListOfPages {
    public PageRecord next;
    public PageRecord top;
    public PageRecord bottom;
    private SMPApplet parent;
    private boolean spider = false;
    private String host;
    private Logger log;
    public int pageCounter = 0;

    public void addPage(PageRecord page) {
        if (this.deriveHost(page.path).compareTo(this.host) == 0 && this.spider) {
            boolean addToList = true;
            int n = 1;
            while (n < this.pageCounter) {
                PageRecord pageInList = this.getItem(n);
                if (page.path.equals(pageInList.path)) {
                    addToList = false;
                    n = this.pageCounter + 1;
                }
                ++n;
            }
            if (!page.path.endsWith("html") && !page.path.endsWith("htm")) {
                addToList = false;
            }
            if (addToList) {
                this.add(page);
                this.log.addToLog("ListOFPages", "addPage", page.path);
            }
        }
    }

    public PageRecord getItem(int n) {
        PageRecord rtn = new PageRecord("");
        if (n < 1 || n > this.pageCounter) {
            rtn.path = "Error: List Item requested is outside of list.";
            this.parent.sendWarningMessage("Error: List Item requested is outside of list.");
        } else {
            PageRecord index = this.top;
            int i = 1;
            while (i != n) {
                index = index.next;
                ++i;
            }
            rtn = index;
        }
        return rtn;
    }

    public ListOfPages(SMPApplet par, PageRecord initialPage, boolean spiderState) {
        this.top = initialPage;
        this.bottom = initialPage;
        this.parent = par;
        this.log = par.logger;
        this.spider = spiderState;
        this.host = this.deriveHost(initialPage.path);
        this.pageCounter = 1;
        this.log.addToLog("ListOFPages", "ListOfPages", initialPage.path);
    }

    private void add(PageRecord newPage) {
        this.bottom.next = newPage;
        newPage.previous = this.bottom;
        this.bottom = newPage;
        ++this.pageCounter;
    }

    private void sort() {
        Vector<PageRecord> newList = new Vector<PageRecord>();
        int n = 0;
        while (n < this.pageCounter) {
            PageRecord max = this.top;
            PageRecord i = this.top;
            while (i != null) {
                if (max.numberOfKeywordHits < i.numberOfKeywordHits) {
                    max = i;
                }
                i = i.next;
            }
            newList.addElement(max);
            if (max == this.top) {
                this.top = max.next;
            } else if (max == this.bottom) {
                this.bottom = max.previous;
                max.previous.next = null;
            } else {
                max.previous.next = max.next;
                max.next.previous = max.previous;
            }
            ++n;
        }
        PageRecord currentItem = this.top = (PageRecord)newList.elementAt(0);
        int l = 1;
        while (l < newList.size()) {
            PageRecord newListItem;
            currentItem.next = newListItem = (PageRecord)newList.elementAt(l);
            newListItem.previous = currentItem;
            currentItem = newListItem;
            ++l;
        }
        this.bottom = currentItem;
        this.bottom.next = null;
    }

    public void addInitalPage(PageRecord page) {
        this.add(page);
        this.log.addToLog("ListOFPages", "addPage", page.path);
    }

    public void normalise() {
        int maxRank;
        this.sort();
        PageRecord index = this.top;
        if (index != null && (maxRank = this.top.numberOfKeywordHits) != 0) {
            while (index != null) {
                index.rank = Math.round(index.numberOfKeywordHits * 100 / maxRank);
                if (index.rank == 0 && index.numberOfKeywordHits > 0) {
                    index.rank = 1;
                }
                index = index.next;
            }
        }
    }

    private String deriveHost(String pageFileName) {
        String derivedHost = new String("Error in host");
        try {
            URL pageFileNameUrl = new URL(this.parent.getDocumentBase(), pageFileName);
            derivedHost = pageFileNameUrl.getHost();
        }
        catch (MalformedURLException e) {
            this.parent.sendWarningMessage("Error in the format of the file: " + pageFileName + " it should be of the form http://my.site.co.uk/myfile.htm");
            this.parent.logger.addToLog("ListOfPages", "deriveHost", "MalformedURLException: " + pageFileName);
        }
        catch (SecurityException e) {
            this.parent.sendWarningMessage("Error reading the following file: " + pageFileName + " You have broken Java security rules.  The file to be read must reside on the same server as the Applet");
            this.parent.logger.addToLog("ListOfPages", "deriveHost", "SecurityException: " + pageFileName);
        }
        return derivedHost;
    }

    public void printListToConsole() {
        PageRecord index = this.top;
        boolean complete = false;
        while (!complete) {
            System.out.println("=============Next Entry ===================");
            System.out.println("ranking:" + index.rank);
            System.out.println("numberOfKeywordHits:" + index.numberOfKeywordHits);
            System.out.println("path:" + index.path);
            System.out.println("titleText:" + index.titleText);
            System.out.println("descriptionText:" + index.descriptionText);
            if (index.next != null) {
                index = index.next;
                continue;
            }
            complete = true;
        }
    }
}

