@echo off
REM --------------- BEGIN CONFIG ------------------------
REM Update the following values to match your need
REM -----------------------------------------------------

REM Set the server network share you are using for OCS Inventory.
REM This script assume that it is the Application folder which is shared.
REM So, the Drivers folder is just under the network share.
SET SERVER_SHARE="\\SNOOPY\Inventory"

REM Set the drive letter you want to use to connect the server network share.
SET DRIVE_LETTER=Z:

REM Update the following destination directory to match your need.
REM It must be the same directory under Win9X/ME/NT/2000/XP.
SET DEST_FOLDER=C:\BIOSINFO

REM --------------- END OF CONFIG -----------------------
REM Do not modify below unless you know what you are doing.
REM -----------------------------------------------------

REM Test is not already done.
if exist %DEST_FOLDER%\BiosInfo.exe goto NO_SETUP

REM Setup BiosInfo.exe is required.
echo.
echo Setting up BIOSINFO Tool.
echo BIOSINFO Tool, by Daniel Arbour.
echo.

REM Connect the server network share to a drive letter.
net use %DRIVE_LETTER% %SERVER_SHARE% /PERSISTENT:NO

REM Create the destination directory.
md %DEST_FOLDER%

REM Copy executable to dest dir.
copy /v %DRIVE_LETTER%\Drivers\BiosInfo.exe %DEST_FOLDER%

REM Disconnect the drive letter from server network share.
net use %DRIVE_LETTER% /DELETE

echo.
echo BIOSINFO Tool successfully setup.
echo.

:NO_SETUP

REM Call BIOSINFO Tool to store results in a file named BIOS.CSV
%DEST_FOLDER%\BiosInfo.exe BIOS %DEST_FOLDER%\Bios.csv

REM Launch OCS Inventory with import of BIOSINFO results.
%SERVER_SHARE%\OCSInventoryCSV.exe /CSV /BIOS=%DEST_FOLDER%\BIOS.CSV

REM Nothing else to do.
