VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsINIRegistry"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private m_INI As clsINI
Private m_FileName As String
Private oColl As Collection
Private Declare Function WriteString Lib "kernel32" _
                         Alias "WritePrivateProfileStringA" _
                        (ByVal lpApplicationName As String, _
                         ByVal lpKeyName As String, _
                         ByVal lpString As String, _
                         ByVal lpFileName As String) As Long
                         
Public Property Get FileName() As String
    FileName = m_FileName
End Property
Public Property Let FileName(NewFileName As String)
On Error GoTo ET
    m_FileName = sTrimNull(Trim$(NewFileName))
    If Right$(oReg.FileName, Len(m_FileName) - lFindLast(m_FileName, "\")) <> Dir(m_FileName) Then
        'MsgBox Dir(oReg.FileName)
        Err.Raise 3000, "clsINIRegistry: FileName", "Invalid command line arguments: " & oReg.FileName & " File Not Found"
        Do Until Dir(m_FileName) = Right$(m_FileName, Len(m_FileName) - lFindLast(m_FileName, "\"))
            m_FileName = CommonOpenDialog("Open Configuration (INI) File", "Configuration Files (*.INI)" & vbNullChar & "*.INI" & vbNullChar, , "*.ini")
            If m_FileName = "" Then
                End 'Unload frmINI
                Exit Property
            End If
        Loop
    End If
    Exit Property
ET:
    Select Case Err.Number
        Case 3000
            MsgBox Err.Description & vbCrLf & "Source= " & Err.Source, vbCritical
            Resume Next
        Case Else
            MsgBox Err.Description & vbCrLf & "Source: clsINIRegistry: FileName", vbCritical
    End Select
End Property

Private Property Set INI(NewINI As clsINI)
    Set m_INI = NewINI
End Property
Private Property Get INI() As clsINI
    Set INI = m_INI
End Property

Public Property Get Registry() As Collection
Attribute Registry.VB_UserMemId = 0
    Set Registry = oColl
End Property

Public Function GetRegValue(Section As String, Key As String) As String
    Dim oINI As clsINI
    For Each oINI In oColl
        'MsgBox "Section=" & oINI.Section & vbCr & _
                "Key=" & oINI.Key & vbCr & _
                "Value=" & oINI.Value
        If UCase$(oINI.Section) = UCase$(Section) And UCase$(oINI.Key) = UCase$(Key) Then
            GetRegValue = oINI.Value
            Exit Function
        End If
    Next
End Function

Public Function SetRegValue(Section As String, Key As String, NewValue As String) As Integer
    Dim oINI As clsINI
    If GetAttr(oReg.FileName) Mod 2 = 1 Then
        MsgBox "Cannot save setting, file is Read Only", 48
        SetRegValue = 1
    End If
    WriteString Section, Key, NewValue, Me.FileName
    
    For Each oINI In oColl
        'MsgBox "Section=" & oINI.Section & vbCr & _
                "Key=" & oINI.Key & vbCr & _
                "Value=" & oINI.Value
        If UCase$(oINI.Section) = UCase$(Section) And UCase$(oINI.Key) = UCase$(Key) Then
            oINI.Value = NewValue
            Exit Function
        End If
    Next
End Function

Public Function LoadINI() As Boolean
Dim FileNum, sLine As String, sSection As String, I As Integer, sKey As String, sValue As String
 On Error GoTo err_Handler
    If Me.FileName = "" Then
        Err.Raise 3000, "clsINIRegistry: LoadINI", "Filename is missing"
    End If
    If Dir(Me.FileName) = "" Then
        Err.Raise 3000, "clsINIRegistry: LoadINI", Me.FileName & " File Not Found"
    End If
    Me.Clear
    Open Me.FileName For Input As #1
    Do While Not EOF(1)
        Line Input #1, sLine
        If Left$(sLine, 1) = "[" And Right$(sLine, 1) = "]" Then
            sSection = Mid$(sLine, 2, Len(sLine) - 2)
            GoTo NextLine
        ElseIf InStr(1, sLine, "=") = 0 Then
            GoTo NextLine
        Else
            For I = 1 To Len(sLine)
                If Mid$(sLine, I, 1) = "=" Then
                    sKey = Left$(sLine, I - 1)
                    sValue = Right$(sLine, Len(sLine) - I)
                    Exit For
                End If
            Next I
        End If
        Set INI = New clsINI
        With INI
            .Section = sSection
            .Key = sKey
            .Value = sValue
        End With
    oColl.Add INI
NextLine:    Loop
    Close #1
    LoadINI = True
    Exit Function
err_Handler:
    Err.Raise vbObjectError + 1000, "Method: LoadINIFile", Err.Description
    Exit Function
End Function

Public Sub Clear()
'    Dim i As Integer
'    For i = 0 To oColl.Count - 1
'        oColl.Remove (i)
'    Next i
    Set oColl = Nothing
    Set oColl = New Collection
End Sub

Private Sub Class_Initialize()
    Set oColl = New Collection
    Set INI = Nothing
End Sub

Private Sub Class_Terminate()
    Set oColl = Nothing
    Set INI = Nothing
End Sub
