<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_include/parser.php
#    Beschr./Desc.:  
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  05-07-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

    $placeholder = array("ID", "Index", "Title", "Subtitle", "Image", "ImageWidth", "File", "Text1", "Text2", "Text3", "More", "Back", "Link1", "Link2", "Link3", "Author", "Initial", "Date");

    $patterns = array();
    $replaces = array();

    $patterns["img"] = "'<%IMG (.*?)%>'si";
    $replaces["img"] = "<IMG $1>";
    $patterns["a"] = "'<%A (.*?)%>'si";
    $replaces["a"] = "<A $1>";
    
    // add patterns & replaces for tags: cpXXXX
    foreach ($placeholder as $i){
        # echo $i.": ".$cpContent[$i]."\n<br>";
    }

    // add patterns & replaces for tags: cpXXXX
    foreach ($placeholder as $i){
        $patterns["cp".$i] = "'<%cp$i%>'si";
        $replaces["cp".$i] = $cpContent[$i];
        $patterns["cp".$i."_"] = "'<%cp$i_%>'si";
        $replaces["cp".$i."_"] = $cpContent[$i]."<br>";
        $patterns["cp".$i."__"] = "'<%cp$i__%>'si";
        $replaces["cp".$i."__"] = $cpContent[$i]."<br><br>";
    }

    // add patterns & replaces for tags: ifXXXX and /ifXXXX
    foreach ($placeholder as $i){
        $patterns["if".$i] = "'<%if".$i."%>(.*?)<%/if".$i."%>'si";
        if (empty($cpContent[$i])) // empty: remove tags and content
            $replaces["if".$i] = "";
        else                       // value set: remove tags, but not content
            $replaces["if".$i] = "$1";
    }

    # echo "<pre>";
    # print_r($patterns); echo "<br>";
    # print_r($replaces); echo "<br>";
    # echo "</pre>";

    # echo "<hr>";

    # echo htmlspecialchars(preg_replace($patterns, $replaces, $content))."<br>";

    $template_datei = preg_replace($patterns, $replaces, $template_datei);

?>