<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_content/start.php
#    Beschr./Desc.:  Welcome / Selection of categories
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  21-02-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

    if (file_exists("../_cfg/const.php")) require("../_cfg/const.php");
    else require("../_cfg/const.php.dist");
    require("../_include/check.php");
    require("../_include/header.php");
    require("../_include/category.inc.php");

    if ( is_readable("../_setup") == TRUE ) {
        $read1 = is_readable("../_setup/index.php");
        $read2 = is_readable("../_setup/index2.php");
    }

    if ( ( $read1 == TRUE OR $read2 == TRUE ) AND $SID_level == 4 ) {
        $message = $LP_SETUP_Warning;
        require("../_include/warning.php");
    }

    $hour = date ("H", time()); 
    // echo "H:".$hour."<br>";
    switch ($hour) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
            $welcome = $LP_First_Morning;
            break;
        case 17:
        case 18:
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
            $welcome = $LP_First_Night;
            break;
        default:
            $welcome = $LP_First_Afternoon;
    }
    
    if ( $first != 1 ) {
        echo "<table width=\"".$WIDTH."\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
        echo "<tr>\n";
        echo "<td class=\"header\">\n";
        echo "<b>".$LP_MainMenue."</b>\n";
        echo "</td>\n";
        echo "</tr>\n";
        echo "<tr>\n";
        echo "<td class=\"text\"><br>\n";
        echo $LP_MainMenueText."<br><br>\n";
        echo "</td>\n";
        echo "</tr>\n";
        echo "</table>\n";
    } else {
        echo "<table width=\"".$WIDTH."\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
        echo "<tr>\n";
        echo "<td class=\"text\">\n";
        echo "<b>".$welcome.", ".$SID_autor."!</b>\n";
        echo "</td>\n";
        echo "</tr>\n";
        echo "<tr>\n";
        echo "<td class=\"text\"><br>\n";
        echo $LP_First."<br><br>\n";
        echo "</td>\n";
        echo "</tr>\n";
        echo "</table>\n";
    }
    echo "<br>\n";

    echo "<table border=\"0\" cellpadding=\"1\" cellspacing=\"2\">\n";
    echo "<tr>";
    echo "<td align=\"left\" valign=\"top\" class=\"text\">";
    
    $query = "SELECT * FROM cpo_rubric WHERE zuordnung != 0 ";
    DEBUG(2, $query, __FILE__, __LINE__);   
    $db = new DB;
    $db->query($query);

    if ($db->num_rows()>0)
    {
        $tree_on = 1;
        echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"2\">\n";
        echo "<tr bgcolor=\"".$color_tbg_dunkel."\">\n";
        echo "<td height=\"21\" align='left' valign=\"middle\" class='text'>\n";
        echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td align='left' class='text'><b>&nbsp;".$LP_Navigation."&nbsp;</b></td></tr></table>\n";
        echo "</td></tr>\n";
        echo "<tr bgcolor=\"".$color_data_hell."\">\n";
        echo "<td align='left' valign=\"middle\" class='text'>\n";

        echo "<table border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n";
        if ( $id == 0 ) {
            echo "<tr><td bgcolor=\"".$color_tbg_dunkel."\" align=\"left\" valign=\"middle\" class=\"text\"><b>".$pre_blank."</b><A HREF=\"".$PHP_SELF."?id=0\">&nbsp;".$LP_MainTree."</A>&nbsp;</td>";
        } else {
            echo "<tr><td align=\"left\" valign=\"middle\" class=\"text\"><b>".$pre_blank."</b><A HREF=\"".$PHP_SELF."?id=0\">&nbsp;".$LP_MainTree."</A>&nbsp;</td>";
        }
        echo "</tr>";
        tree_select(0,0,$id);
        echo "</table>\n";

        echo "<br></td></tr>\n";
        echo "</table>\n";

        echo "</td>\n";
        echo "<td align=\"left\" valign=\"top\" class=\"text\">";
    } else {
        $tree_on = 0;
    }


    $tree_selection = $id;
    require("../_include/category_selection.php");

    echo "</td>\n";
    echo "</tr>\n";
    echo "</table>\n";

    // Untere Navigation
    require("../_include/footer.php");
?>
