/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.io.PrintStream;

public class HexDump {
    private static final int ROW_BYTES = 16;
    private static final int ROW_QTR1 = 3;
    private static final int ROW_HALF = 7;
    private static final int ROW_QTR2 = 11;

    public static void dumpHexData(PrintStream out, String title, byte[] buf, int numBytes) {
        String saveStr;
        int j;
        String idxStr;
        int hexVal;
        byte[] save_buf = new byte[18];
        byte[] hex_buf = new byte[4];
        byte[] idx_buf = new byte[8];
        byte[] hex_chars = new byte[20];
        hex_chars[0] = 48;
        hex_chars[1] = 49;
        hex_chars[2] = 50;
        hex_chars[3] = 51;
        hex_chars[4] = 52;
        hex_chars[5] = 53;
        hex_chars[6] = 54;
        hex_chars[7] = 55;
        hex_chars[8] = 56;
        hex_chars[9] = 57;
        hex_chars[10] = 65;
        hex_chars[11] = 66;
        hex_chars[12] = 67;
        hex_chars[13] = 68;
        hex_chars[14] = 69;
        hex_chars[15] = 70;
        out.println(title + " - " + numBytes + " bytes.");
        int rows = numBytes >> 4;
        int residue = numBytes & 0xF;
        int i = 0;
        while (i < rows) {
            hexVal = i * 16;
            idx_buf[0] = hex_chars[hexVal >> 12 & 0xF];
            idx_buf[1] = hex_chars[hexVal >> 8 & 0xF];
            idx_buf[2] = hex_chars[hexVal >> 4 & 0xF];
            idx_buf[3] = hex_chars[hexVal & 0xF];
            idxStr = new String(idx_buf, 0, 4);
            out.print(idxStr + ": ");
            j = 0;
            while (j < 16) {
                save_buf[j] = buf[i * 16 + j];
                hex_buf[0] = hex_chars[save_buf[j] >> 4 & 0xF];
                hex_buf[1] = hex_chars[save_buf[j] & 0xF];
                out.print((char)hex_buf[0]);
                out.print((char)hex_buf[1]);
                out.print(' ');
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                if (save_buf[j] < 32 || save_buf[j] > 217) {
                    save_buf[j] = 46;
                }
                ++j;
            }
            saveStr = new String(save_buf, 0, j);
            out.println(" | " + saveStr + " |");
            ++i;
        }
        if (residue > 0) {
            hexVal = i * 16;
            idx_buf[0] = hex_chars[hexVal >> 12 & 0xF];
            idx_buf[1] = hex_chars[hexVal >> 8 & 0xF];
            idx_buf[2] = hex_chars[hexVal >> 4 & 0xF];
            idx_buf[3] = hex_chars[hexVal & 0xF];
            idxStr = new String(idx_buf, 0, 4);
            out.print(idxStr + ": ");
            j = 0;
            while (j < residue) {
                save_buf[j] = buf[i * 16 + j];
                hex_buf[0] = hex_chars[save_buf[j] >> 4 & 0xF];
                hex_buf[1] = hex_chars[save_buf[j] & 0xF];
                out.print((char)hex_buf[0]);
                out.print((char)hex_buf[1]);
                out.print(' ');
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                if (save_buf[j] < 32 || save_buf[j] > 217) {
                    save_buf[j] = 46;
                }
                ++j;
            }
            while (j < 16) {
                save_buf[j] = 32;
                out.print("   ");
                if (j == 3 || j == 7 || j == 11) {
                    out.print(" ");
                }
                ++j;
            }
            saveStr = new String(save_buf, 0, j);
            out.println(" | " + saveStr + " |");
        }
    }

    public static void main(String[] args) {
        byte[] data = new byte[132];
        int i = 0;
        while (i < 132) {
            data[i] = (byte)i;
            ++i;
        }
        HexDump.dumpHexData(System.err, "Test HexDump", data, 132);
    }
}

