/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.SetupFileFilter;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Stats;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Step;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.StepFactory;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.UpgradeInfo;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.UpgradeStep;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Arrays;

public abstract class AbstractInstall {
    public static final int CANCEL = 1;
    public static final int BACK = 2;
    public static final int NEXT = 4;
    public static final int FINISH = 8;
    protected static final int LANGUAGE = 0;
    protected static final int START = 1;
    protected static final int WELCOME = 2;
    protected static final int LICENSE = 3;
    protected static final int README = 4;
    protected static final int LICENSE_KEY = 5;
    protected static final int UPGRADE = 6;
    protected static final int COMPONENTS = 7;
    protected static final int DIRECTORY = 8;
    protected static final int JVM = 9;
    protected static final int INSTALL = 10;
    protected static final int SHORTCUTS = 11;
    protected static final int END = 12;
    protected Step step_;
    protected boolean dirty_;
    protected StepFactory ui_;
    protected Stats stats_;
    protected int state_;
    protected int actionEnabled_;
    protected File sharedDir_;
    protected File classloaderTempDir_;
    protected UpgradeInfo uInfo_;
    protected String language;

    public AbstractInstall() {
        if (Globals.IS_WIN) {
            this.extractJniDll();
        }
        this.actionEnabled_ = 0;
        this.stats_ = new Stats();
        this.sharedDir_ = null;
        this.uInfo_ = null;
        this.dirty_ = false;
        this.state_ = 1;
    }

    public void deleteDirRecursive(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] filelist = dir.listFiles();
        int i = 0;
        while (i < filelist.length) {
            boolean isdir = filelist[i].isDirectory();
            if (isdir) {
                this.deleteDirRecursive(filelist[i]);
            } else if (!filelist[i].delete()) {
                this.stats_.addFile(filelist[i], false);
                Globals.printDebug("F " + filelist[i] + " not deleted");
            }
            ++i;
        }
        if (!dir.delete()) {
            this.stats_.addDirectory(dir, false);
            Globals.printDebug("D " + dir + " not deleted");
        }
    }

    public void setActionEnabled(int a) {
        this.actionEnabled_ = a;
        this.ui_.setActionEnabled(a);
    }

    public void cancel() {
        this.cleanInstall(this.sharedDir_, this.uInfo_);
        this.quit();
    }

    protected void cleanInstall(File sharedDir, UpgradeInfo uInfo) {
        if (!this.dirty_ || sharedDir == null || !sharedDir.exists()) {
            Globals.printDebug("No cleaning needed");
            return;
        }
        File uninstDir = new File(sharedDir.getAbsolutePath() + File.separator + Globals.APP_NAME + "_" + Globals.APP_VERSION);
        if (!uninstDir.exists()) {
            Globals.printDebug("No cleaning needed");
            return;
        }
        Globals.printDebug("Deleting uninstall files...");
        if (uInfo != null && uInfo.upgrade) {
            this.restoreLastVersion(sharedDir, uInfo);
        } else {
            this.deleteDirRecursive(uninstDir);
        }
        Globals.printDebug("All cleaned OK");
    }

    private void restoreLastVersion(File sharedDir, UpgradeInfo uInfo) {
        File lastVerPath;
        if (uInfo == null || !uInfo.upgrade) {
            return;
        }
        File destPath = new File(sharedDir, Globals.APP_NAME + "_" + Globals.APP_VERSION);
        if (!destPath.renameTo(lastVerPath = new File(sharedDir, Globals.APP_NAME + "_" + uInfo.lastVersion()))) {
            Globals.printDebug("could not rename directory to: " + lastVerPath);
        }
    }

    protected void checkUpgrade(File sharedDir, UpgradeInfo uInfo) {
        UpgradeStep step = (UpgradeStep)this.step_;
        step.status(Globals.i18n("Setup_LookPreviousVersions"));
        this.ui_.uiSleep(2000L);
        this.checkVersions(sharedDir, uInfo);
        if (uInfo.upgrade) {
            Globals.printDebug("Previous version found : " + uInfo.lastVersion());
            step.status(Globals.i18n("Setup_PreviousVersionFound") + " " + uInfo.lastVersion());
            step.version(uInfo.lastVersion());
            step.directory(uInfo.lastPath().getAbsolutePath());
        } else {
            Globals.printDebug("No previous version found");
            step.status(Globals.i18n("Setup_NoPreviousVersionFound"));
            step.version(Globals.i18n("Setup_None"));
            step.directory(Globals.i18n("Setup_None"));
        }
    }

    private void checkVersions(File sharedDir, UpgradeInfo uInfo) {
        Object[] ls = sharedDir.list(new SetupFileFilter(Globals.APP_NAME + "_", 1, 1));
        if (ls != null && ls.length > 0) {
            Arrays.sort(ls);
            uInfo.versions = new String[ls.length];
            uInfo.paths = new File[ls.length];
            int i = 0;
            while (i < ls.length) {
                uInfo.versions[i] = ((String)ls[i]).substring(((String)ls[i]).lastIndexOf(95) + 1);
                try {
                    LineNumberReader log = new LineNumberReader(new FileReader(new File(new File(sharedDir, (String)ls[i]), "uninstall.daf")));
                    String f = log.readLine();
                    if (f != null) {
                        uInfo.paths[i] = new File(f);
                    }
                    log.close();
                }
                catch (IOException ex) {
                    uInfo.paths[i] = null;
                }
                ++i;
            }
        }
        uInfo.upgrade = uInfo.lastVersion() != null && uInfo.lastPath() != null;
    }

    private void extractJniDll() {
        try {
            String entryName = "/ICE_JNIRegistry.dll";
            InputStream dll = this.getClass().getResourceAsStream(entryName);
            File dllFile = new File(System.getProperty("java.io.tmpdir") + File.separator + entryName.substring(entryName.lastIndexOf(47) + 1));
            Globals.printDebug("Extracting library " + dllFile);
            FileOutputStream dllout = new FileOutputStream(dllFile);
            byte[] data = new byte[512];
            int read = dll.read(data, 0, data.length);
            while (read > 0) {
                dllout.write(data, 0, read);
                read = dll.read(data, 0, data.length);
            }
            dll.close();
            dllout.close();
            Globals.printDebug(" library extracted");
            Globals.JNI_DLL_FILE = dllFile.getAbsolutePath();
            dllFile.deleteOnExit();
        }
        catch (IOException e) {
            this.exitOnError(e);
        }
    }

    protected void exitOnError(Throwable e) {
        if (this.ui_ != null) {
            this.ui_.showFatalError(e);
        } else {
            e.printStackTrace();
        }
        System.exit(1);
    }

    protected void quit() {
        if (this.classloaderTempDir_ != null) {
            Globals.printDebug("Temporary directory deleted: " + this.classloaderTempDir_.getAbsolutePath());
            this.deleteDirRecursive(this.classloaderTempDir_);
        }
        this.ui_ = null;
        Globals.printDebug("Exiting");
        System.exit(0);
    }

    public abstract void nextStep();

    public abstract void previousStep();

    public abstract void redoStep();
}

