/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.sql.CallableStatement;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.postgresql.Driver;
import org.postgresql.PG_Stream;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.util.PSQLException;

public abstract class AbstractJdbc2Connection
extends AbstractJdbc1Connection {
    protected Map typemap;
    private static final String[] jdbc2Types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "date", "time", "abstime", "timestamp", "timestamptz", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea"};
    private static final int[] jdbc2Typei = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, -7, 91, 92, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003};

    public void cancelQuery() throws SQLException {
        PG_Stream cancelStream = null;
        try {
            cancelStream = new PG_Stream(this.PG_HOST, this.PG_PORT);
        }
        catch (ConnectException connectException) {
            throw new PSQLException("postgresql.con.refused");
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.con.failed", e);
        }
        try {
            try {
                cancelStream.SendInteger(16, 4);
                cancelStream.SendInteger(80877102, 4);
                cancelStream.SendInteger(this.pid, 4);
                cancelStream.SendInteger(this.ckey, 4);
                cancelStream.flush();
            }
            catch (IOException e) {
                throw new PSQLException("postgresql.con.failed", e);
            }
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                if (cancelStream != null) {
                    cancelStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (cancelStream != null) {
                cancelStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1004, 1007);
    }

    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null) {
            DriverManager.setLogWriter(new PrintWriter(System.out));
        }
    }

    public Object getObject(String type, String value) throws SQLException {
        SQLData d;
        if (this.typemap != null && (d = (SQLData)this.typemap.get(type)) != null) {
            throw Driver.notImplemented();
        }
        return super.getObject(type, value);
    }

    public int getSQLType(String pgTypeName) {
        int sqlType = 1111;
        int i = 0;
        while (i < jdbc2Types.length) {
            if (pgTypeName.equals(jdbc2Types[i])) {
                sqlType = jdbc2Typei[i];
                break;
            }
            ++i;
        }
        return sqlType;
    }

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007);
    }

    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1004, 1007);
    }

    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    public void setTypeMap(Map map) throws SQLException {
        this.typemap = map;
    }
}

